/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.json;

import com.dslplatform.compiler.client.json.JsonReader;
import com.dslplatform.compiler.client.json.NumberConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class JSON {
    private static Object deserializeObject(JsonReader reader) throws IOException {
        switch (reader.last()) {
            case 110: {
                if (!reader.wasNull()) {
                    throw new IOException("Expecting 'null' at position " + reader.positionInStream() + ". Found " + (char)reader.last());
                }
                return null;
            }
            case 116: {
                if (!reader.wasTrue()) {
                    throw new IOException("Expecting 'true' at position " + reader.positionInStream() + ". Found " + (char)reader.last());
                }
                return true;
            }
            case 102: {
                if (!reader.wasFalse()) {
                    throw new IOException("Expecting 'false' at position " + reader.positionInStream() + ". Found " + (char)reader.last());
                }
                return false;
            }
            case 34: {
                return reader.readString();
            }
            case 123: {
                return JSON.deserializeMap(reader);
            }
            case 91: {
                return JSON.deserializeList(reader);
            }
        }
        return NumberConverter.deserializeNumber(reader);
    }

    private static ArrayList<Object> deserializeList(JsonReader reader) throws IOException {
        if (reader.last() != 91) {
            throw new IOException("Expecting '[' at position " + reader.positionInStream() + ". Found " + (char)reader.last());
        }
        byte nextToken = reader.getNextToken();
        if (nextToken == 93) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> res = new ArrayList<Object>(4);
        res.add(JSON.deserializeObject(reader));
        while ((nextToken = reader.getNextToken()) == 44) {
            reader.getNextToken();
            res.add(JSON.deserializeObject(reader));
        }
        if (nextToken != 93) {
            throw new IOException("Expecting ']' at position " + reader.positionInStream() + ". Found " + (char)nextToken);
        }
        return res;
    }

    public static Map<String, Object> readMap(byte[] input, int length) throws IOException {
        JsonReader reader = new JsonReader(input, length);
        reader.getNextToken();
        return JSON.deserializeMap(reader);
    }

    public static List<Object> readList(byte[] input, int length) throws IOException {
        JsonReader reader = new JsonReader(input, length);
        reader.getNextToken();
        return JSON.deserializeList(reader);
    }

    private static LinkedHashMap<String, Object> deserializeMap(JsonReader reader) throws IOException {
        if (reader.last() != 123) {
            throw new IOException("Expecting '{' at position " + reader.positionInStream() + ". Found " + (char)reader.last());
        }
        byte nextToken = reader.getNextToken();
        if (nextToken == 125) {
            return new LinkedHashMap<String, Object>(0);
        }
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        String key = reader.readString();
        nextToken = reader.getNextToken();
        if (nextToken != 58) {
            throw new IOException("Expecting ':' at position " + reader.positionInStream() + ". Found " + (char)nextToken);
        }
        reader.getNextToken();
        res.put(key, JSON.deserializeObject(reader));
        while ((nextToken = reader.getNextToken()) == 44) {
            reader.getNextToken();
            key = reader.readString();
            nextToken = reader.getNextToken();
            if (nextToken != 58) {
                throw new IOException("Expecting ':' at position " + reader.positionInStream() + ". Found " + (char)nextToken);
            }
            reader.getNextToken();
            res.put(key, JSON.deserializeObject(reader));
        }
        if (nextToken != 125) {
            throw new IOException("Expecting '}' at position " + reader.positionInStream() + ". Found " + (char)nextToken);
        }
        return res;
    }
}

