/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters;

import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.ExitException;
import java.util.LinkedHashMap;
import java.util.Map;

class DatabaseInfo {
    final String database;
    final String compilerVersion;
    final String dbVersion;
    final Map<String, String> dsl;

    DatabaseInfo(String database, String compilerVersion, String dbVersion, Map<String, String> dsl) {
        this.database = database;
        this.compilerVersion = compilerVersion;
        this.dbVersion = dbVersion;
        this.dsl = dsl;
    }

    private static String unescape(String element) {
        return element.replace("\\\"", "\"").replace("\\\\", "\\");
    }

    static Map<String, String> convertToMap(String dsls, Context context) throws ExitException {
        String[] pairs;
        LinkedHashMap<String, String> tuples = new LinkedHashMap<String, String>();
        if (dsls == null || dsls.length() == 0) {
            return tuples;
        }
        int endLength = dsls.length() - 1;
        if (dsls.charAt(0) != '\"' || dsls.charAt(endLength) != '\"') {
            context.error("Invalid DSL found in database. Unable to parse it as map: " + dsls);
            throw new ExitException();
        }
        for (String pair : pairs = dsls.substring(1, endLength).split("\", ?\"", -1)) {
            String[] kv = pair.split("\"=>\"", -1);
            if (kv.length != 2) {
                context.error("Invalid DSL found in database. Unable to parse it as map: " + dsls);
                throw new ExitException();
            }
            tuples.put(DatabaseInfo.unescape(kv[0]), DatabaseInfo.unescape(kv[1]));
        }
        return tuples;
    }
}

