/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters;

import com.dslplatform.compiler.client.CompileParameter;
import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.Either;
import com.dslplatform.compiler.client.ExitException;
import com.dslplatform.compiler.client.Utils;
import com.dslplatform.compiler.client.parameters.Dependencies;
import com.dslplatform.compiler.client.parameters.Maven;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public enum Download implements CompileParameter
{
    INSTANCE;

    private static final String DEFAULT_REMOTE_URL = "https://tools.dsl-platform.com/";

    @Override
    public String getAlias() {
        return "download";
    }

    @Override
    public String getUsage() {
        return null;
    }

    public static String remoteUrl(Context context) {
        String customURL = context.get(INSTANCE);
        if (customURL != null && !customURL.isEmpty()) {
            return customURL;
        }
        return DEFAULT_REMOTE_URL;
    }

    public static boolean isDefaultUrl(Context context) {
        String remoteUrl = Download.remoteUrl(context);
        return DEFAULT_REMOTE_URL.equals(remoteUrl);
    }

    private static String websiteName(Context context) {
        String remoteUrl = Download.remoteUrl(context);
        if (Download.isDefaultUrl(context)) {
            return "DSL Platform";
        }
        return "custom url (" + remoteUrl + ")";
    }

    public static long downloadAndUnpack(Context context, String file, File path) throws IOException {
        URL server = new URL(Download.remoteUrl(context) + file + ".zip");
        String websiteName = Download.websiteName(context);
        context.show("Downloading " + file + ".zip from " + websiteName + "...");
        return Utils.unpackZip(context, path, server);
    }

    public static Either<Long> lastModified(Context context, String file, String name, long current) {
        String websiteName = Download.websiteName(context);
        try {
            URL server = new URL(Download.remoteUrl(context) + file + ".zip");
            context.log("Checking last modified info for " + file + ".zip from " + websiteName + "...");
            HttpURLConnection connection = (HttpURLConnection)server.openConnection();
            connection.setRequestMethod("HEAD");
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            long latest = connection.getLastModified();
            if (latest == 0L && connection.getResponseCode() == -1) {
                return Either.fail("Unable to check " + file + " version on " + websiteName + ". Internet connection not available?");
            }
            if (current == latest && current != 0L) {
                context.show(name + " at latest version (" + sdf.format(latest) + ")");
            } else if (current > 0L && latest > 0L) {
                context.show("Different version of " + name + " found at " + websiteName + ".");
                context.show("Local version: " + sdf.format(current));
                context.show("Upstream version: " + sdf.format(latest));
            } else if (latest == 0L) {
                context.warning(name + " not found at " + websiteName + " website.");
            } else {
                context.show("Upstream version: " + sdf.format(latest));
            }
            return Either.success(latest);
        }
        catch (UnknownHostException ex) {
            return Either.fail("Unable to check for " + file + " on " + websiteName + ".", ex);
        }
        catch (IOException ex) {
            return Either.fail(ex);
        }
    }

    public static boolean downloadZip(File dependencies, Context context, String name, String zip) {
        String websiteName = Download.websiteName(context);
        try {
            context.show("Downloading " + name + " from " + websiteName + "...");
            long lastModified = Download.downloadAndUnpack(context, zip, dependencies);
            if (!dependencies.setLastModified(lastModified)) {
                context.warning("Unable to set last modified info on: " + dependencies.getAbsolutePath());
            }
        }
        catch (IOException ex) {
            context.error("Error downloading dependencies from " + websiteName + ".");
            context.error(ex);
            return false;
        }
        return true;
    }

    private static boolean promptForAlternative(File dependencies, Context context, String name, String zip) throws ExitException {
        String answer;
        if (!context.contains(INSTANCE)) {
            if (!context.canInteract()) {
                throw new ExitException();
            }
            String websiteName = Download.websiteName(context);
            answer = context.ask("Try alternative download from " + websiteName + " (y/N):");
        } else {
            answer = "y";
        }
        if (!"y".equalsIgnoreCase(answer)) {
            throw new ExitException();
        }
        return Download.downloadZip(dependencies, context, name, zip);
    }

    public static boolean checkJars(Context context, String name, String zip, String id, String path, String ... libraries) throws ExitException {
        File dependencies = Dependencies.getDependencies(context, name, id, zip, true);
        File[] found = dependencies.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        });
        if (found == null || found.length == 0) {
            Either<String> tryMaven;
            if (zip == null && libraries.length == 0) {
                context.log("No dependencies defined for: " + name);
                return true;
            }
            context.warning(name + " not found in: " + dependencies.getAbsolutePath());
            if (!context.contains(INSTANCE)) {
                if (!context.canInteract()) {
                    context.error("Download option not enabled. Enable download option, change dependencies path or place " + name + " files in specified folder.");
                    throw new ExitException();
                }
                String answer = context.ask("Do you wish to download latest " + name + " version from the Internet (y/N):");
                if (!"y".equalsIgnoreCase(answer)) {
                    throw new ExitException();
                }
            }
            Either<String> either = tryMaven = libraries.length > 0 && path != null ? Maven.findMaven(context) : Either.fail("Library not defined");
            if (!tryMaven.isSuccess()) {
                if (zip == null) {
                    context.error("Unable to find Maven. Dependency can't be downloaded.");
                    throw new ExitException();
                }
                return Download.downloadZip(dependencies, context, name, zip);
            }
            for (String library : libraries) {
                if (Download.downloadLibrary(context, name, path, dependencies, tryMaven, library, zip)) continue;
                return false;
            }
            Either<Long> lastModified = Download.lastModified(context, zip, name, 0L);
            if (lastModified.isSuccess()) {
                if (!dependencies.setLastModified(lastModified.get())) {
                    context.warning("Unable to set last modified info on: " + dependencies.getAbsolutePath());
                }
            } else {
                context.warning("Failed to check dependency version for: " + dependencies.getAbsolutePath());
            }
        }
        return true;
    }

    private static boolean downloadLibrary(Context context, String name, String path, File dependencies, Either<String> tryMaven, String library, String zip) throws ExitException {
        context.show("Downloading " + name + " (" + library + ") from Sonatype...");
        try {
            URL maven = new URL("https://oss.sonatype.org/content/repositories/releases/" + path + "/" + library + "/maven-metadata.xml");
            Either<Document> doc = Utils.readXml(maven.openConnection().getInputStream());
            if (!doc.isSuccess()) {
                context.error("Error downloading library info from Sonatype.");
                context.error(doc.whyNot());
                return false;
            }
            Element root = doc.get().getDocumentElement();
            Element versioning = (Element)root.getElementsByTagName("versioning").item(0);
            String version = versioning.getElementsByTagName("release").item(0).getTextContent();
            String sharedUrl = "https://oss.sonatype.org/content/repositories/releases/" + path + "/" + library + "/" + version + "/" + library + "-" + version;
            URL pomUrl = new URL(sharedUrl + ".pom");
            File pomFile = new File(dependencies, library + "-" + version + ".pom");
            Utils.downloadFile(pomFile, pomUrl);
            URL jarUrl = new URL(sharedUrl + ".jar");
            Utils.downloadFile(new File(dependencies, library + "-" + version + ".jar"), jarUrl);
            context.show("Downloading " + name + " library dependencies with Maven...");
            Either<Utils.CommandResult> gatherDeps = Utils.runCommand(context, tryMaven.get(), pomFile.getParentFile(), Arrays.asList("dependency:copy-dependencies", "\"-DoutputDirectory=" + dependencies.getAbsolutePath() + "\"", "\"-f=" + pomFile.getAbsolutePath() + "\""));
            if (!gatherDeps.isSuccess()) {
                context.error("Error gathering dependencies with Maven.");
                context.error(gatherDeps.whyNot());
                return Download.promptForAlternative(dependencies, context, name, zip);
            }
            String result = gatherDeps.get().output + gatherDeps.get().error;
            if (!result.contains("BUILD SUCCESS")) {
                context.error("Maven error during dependency download.");
                context.show(result);
                return Download.promptForAlternative(dependencies, context, name, zip);
            }
        }
        catch (IOException ex) {
            context.error("Unable to download " + name + " from Sonatype.");
            context.error(ex);
            return Download.promptForAlternative(dependencies, context, name, zip);
        }
        return true;
    }

    @Override
    public boolean check(Context context) {
        String value = context.get(INSTANCE);
        if (value != null && value.length() > 0) {
            URL url;
            if (!value.endsWith("/")) {
                context.error("Invalid download url: " + value + " provided. It must end with a /. Eg: " + value + "/");
                return false;
            }
            try {
                url = new URL(value);
            }
            catch (MalformedURLException e) {
                context.error("Unable to parse provided download url: " + value + ". " + e.getMessage());
                return false;
            }
            try {
                URLConnection conn = url.openConnection();
                conn.connect();
            }
            catch (IOException e) {
                context.error("Unable to connect to server at url: " + value + ". " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public void run(Context context) {
    }

    @Override
    public String getShortDescription() {
        return "Download library dependencies if not available";
    }

    @Override
    public String getDetailedDescription() {
        return "Always download missing dependencies.\nDependencies will be checked for latest version.\nDependencies will be downloaded through Maven, DSL Platform website or custom URL specified.\nCustom download URL can be specified; default URL = https://tools.dsl-platform.com/\n\nExample:\n\tdownload\n\tdownload=http://company.domain/dsl-platform/";
    }
}

