/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters;

import com.dslplatform.compiler.client.CompileParameter;
import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.Either;
import com.dslplatform.compiler.client.ExitException;
import com.dslplatform.compiler.client.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public enum DslPath implements CompileParameter
{
    INSTANCE;

    private static final String CACHE_MAP_NAME = "current_dsl_map_cache";
    private static final String CACHE_FILE_NAME = "current_dsl_file_cache";

    @Override
    public String getAlias() {
        return "dsl";
    }

    @Override
    public String getUsage() {
        return "path";
    }

    public static Map<String, String> getCurrentDsl(Context context) throws ExitException {
        Map cache = (Map)context.load(CACHE_MAP_NAME);
        if (cache != null) {
            return cache;
        }
        DslPath.findDsls(context);
        return (Map)context.load(CACHE_MAP_NAME);
    }

    public static List<File> getDslPaths(Context context) throws ExitException {
        List cache = (List)context.load(CACHE_FILE_NAME);
        if (cache != null) {
            return cache;
        }
        DslPath.findDsls(context);
        return (List)context.load(CACHE_FILE_NAME);
    }

    private static void findDsls(Context context) throws ExitException {
        String value = context.get(INSTANCE);
        if (value == null) {
            if (!new File("./dsl").exists()) {
                context.error("DSL path not provided. Can't use default path (./dsl) since it doesn't exist");
                throw new ExitException();
            }
            value = "./dsl";
            context.put(INSTANCE, "./dsl");
        }
        ArrayList<File> allDslFiles = new ArrayList<File>();
        LinkedHashMap<String, String> dslMap = new LinkedHashMap<String, String>();
        for (String part : value.split(File.pathSeparator)) {
            File dslPath = new File(part).getAbsoluteFile();
            List<File> dslFiles = dslPath.isFile() ? Collections.singletonList(dslPath) : Utils.findFiles(context, dslPath, Arrays.asList(".dsl", ".ddd"));
            File basePath = dslPath.isFile() ? dslPath.getParentFile() : dslPath;
            int pathLen = basePath.getAbsolutePath().length();
            for (File file : dslFiles) {
                if (!file.canRead()) {
                    context.error("Can't read DSL file: " + file.getName());
                    throw new ExitException();
                }
                Either<String> content = Utils.readFile(file);
                if (content.isSuccess()) {
                    String relativeName = file.getAbsolutePath().substring(pathLen);
                    if (dslMap.containsKey(relativeName)) {
                        context.warning("Duplicate DSL file specified: " + file.getAbsolutePath() + " (" + relativeName + ") from base path: " + basePath.getAbsolutePath() + " (" + part + ")");
                        continue;
                    }
                    dslMap.put(relativeName, content.get());
                    allDslFiles.add(file);
                    continue;
                }
                context.error("Error reading DSL file: " + file.getName());
                context.error(content.whyNot());
                throw new ExitException();
            }
        }
        context.cache(CACHE_MAP_NAME, dslMap);
        context.cache(CACHE_FILE_NAME, allDslFiles);
    }

    @Override
    public boolean check(Context context) {
        String value = context.get(INSTANCE);
        if (value == null) {
            File dslPath = new File("./dsl");
            if (!dslPath.exists()) {
                context.error("DSL path not provided. Can't use default path (./dsl) since it doesn't exist");
                return false;
            }
            context.put(INSTANCE, "./dsl");
        } else {
            for (String part : value.split(File.pathSeparator)) {
                File dslPath = new File(part).getAbsoluteFile();
                if (dslPath.exists()) continue;
                context.error("Provided DSL path (" + part + ") does not exist. Please provide valid path to DSL files");
                return false;
            }
        }
        return true;
    }

    @Override
    public void run(Context context) {
    }

    @Override
    public String getShortDescription() {
        return "Path(s) to DSL files";
    }

    @Override
    public String getDetailedDescription() {
        return "Domain Specification Language files contain description of domain model in a language leveraging DDD (Domain-Driven-Design) concepts.\nDSL files should contain descriptions of data structures used through the application and from which various parts of the application will be maintained.\nSnapshot of DSL files will be saved to the database, for future comparison on database migrations.\n\nUTF-8 will be assumed for DSL files.\n.dsl and .ddd extensions are supported.\n\nMultiple files/paths can be specified via path separator.";
    }
}

