/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters;

import com.dslplatform.compiler.client.CompileParameter;
import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.ExitException;
import java.util.List;

public class Help
implements CompileParameter {
    private final List<CompileParameter> parameters;

    public Help(List<CompileParameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    public String getAlias() {
        return "help";
    }

    @Override
    public String getUsage() {
        return "command";
    }

    private CompileParameter from(String value) {
        for (CompileParameter cp : this.parameters) {
            if (!cp.getAlias().equalsIgnoreCase(value)) continue;
            return cp;
        }
        return null;
    }

    @Override
    public boolean check(Context context) throws ExitException {
        if (context.contains(this)) {
            String value = context.get(this);
            CompileParameter input = this.from(value);
            if (input == null) {
                context.error("Unknown command: " + value);
                throw new ExitException();
            }
            String help = input.getDetailedDescription();
            if (help == null) {
                context.error("Sorry, no detailed info about:" + value);
            } else {
                int len;
                if (input.getShortDescription() != null) {
                    len = value.length() + 2 + input.getShortDescription().length();
                    context.show(value + ": " + input.getShortDescription());
                } else {
                    len = value.length();
                    context.show(value);
                }
                StringBuilder sb = new StringBuilder(len);
                for (int i = 0; i < len; ++i) {
                    sb.append("=");
                }
                context.show(sb.toString());
                context.show(new String[0]);
                context.show(input.getDetailedDescription());
            }
            throw new ExitException();
        }
        return true;
    }

    @Override
    public void run(Context context) {
    }

    @Override
    public String getShortDescription() {
        return "Show detailed description of a command";
    }

    @Override
    public String getDetailedDescription() {
        return "Recursion detected...";
    }
}

