/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters;

import com.dslplatform.compiler.client.CompileParameter;
import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.Either;
import com.dslplatform.compiler.client.Utils;
import com.dslplatform.compiler.client.parameters.Version;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public enum JavaPath implements CompileParameter
{
    INSTANCE;

    private static final String CACHE_FILE_PREFIX = "java_path_cache_";
    private static final SimpleDateFormat DATE_FORMAT;

    @Override
    public String getAlias() {
        return "java";
    }

    @Override
    public String getUsage() {
        return "path";
    }

    public static Either<String> findCompiler(Context context) {
        return JavaPath.getCommand(context, "javac", "Java compiler");
    }

    private static Either<String> getJarCommand(Context context) {
        return JavaPath.getCommand(context, "jar", "Java archive tool");
    }

    private static Either<String> getCommand(Context context, String name, String description) {
        Either<String> homePath;
        if (context.contains(INSTANCE)) {
            String file = (String)context.load(CACHE_FILE_PREFIX + name);
            return Either.success(file);
        }
        String envJH = System.getenv("JAVA_HOME");
        String envJDK = System.getenv("JDK_HOME");
        Either<String> path = Utils.findCommand(context, null, name, "Usage: " + name);
        if (path.isSuccess()) {
            context.cache(CACHE_FILE_PREFIX + name, path.get());
            return Either.success(path.get());
        }
        if (envJH != null) {
            homePath = Utils.findCommand(context, new File(envJH, "bin").getPath(), name, "Usage: " + name);
            if (homePath.isSuccess()) {
                context.cache(CACHE_FILE_PREFIX + name, homePath.get());
                return Either.success(homePath.get());
            }
            context.warning("Invalid JAVA_HOME environment variable specified: " + envJH);
        } else {
            context.warning(name + " not found on PATH. JAVA_HOME environment variable not set.");
        }
        if (envJDK != null) {
            homePath = Utils.findCommand(context, new File(envJDK, "bin").getPath(), name, "Usage: " + name);
            if (homePath.isSuccess()) {
                context.cache(CACHE_FILE_PREFIX + name, homePath.get());
                return Either.success(homePath.get());
            }
            context.warning("Invalid JDK_HOME environment variable specified: " + envJDK);
        } else {
            context.warning(name + " not found on PATH. JDK_HOME environment variable not set.");
        }
        return Either.fail("Unable to find " + description + ". Add it to path or specify java compile option.");
    }

    public static synchronized Either<Utils.CommandResult> makeArchive(Context context, File classOut, File output, Map<String, List<String>> services) {
        Either<String> tryJar = JavaPath.getJarCommand(context);
        if (!tryJar.isSuccess()) {
            return Either.fail(tryJar.whyNot());
        }
        String jar = tryJar.get();
        List<String> jarArguments = JavaPath.makeJarArguments(context, classOut, "class", output, services);
        File metaInf = new File(classOut, "META-INF");
        File manifest = new File(metaInf, "MANIFEST.MF");
        if (!metaInf.exists() && !metaInf.mkdirs()) {
            return Either.fail("Error creating: " + metaInf.getAbsolutePath());
        }
        try {
            String version = context.contains(Version.INSTANCE) ? context.get(Version.INSTANCE) : DATE_FORMAT.format(new Date());
            Utils.saveFile(context, manifest, "Implementation-Version: " + version + "\n");
        }
        catch (IOException e) {
            context.error("Can't create manifest: " + manifest);
            return Either.fail(e);
        }
        if (services != null) {
            File servicePath = new File(metaInf, "services");
            if (!servicePath.exists() && !servicePath.mkdirs()) {
                return Either.fail("Error creating: " + servicePath.getAbsolutePath());
            }
            for (Map.Entry<String, List<String>> kv : services.entrySet()) {
                File service = new File(servicePath, kv.getKey());
                try {
                    StringBuilder sb = new StringBuilder();
                    for (String it : kv.getValue()) {
                        sb.append(it);
                        sb.append("\n");
                    }
                    Utils.saveFile(context, service, sb.toString());
                }
                catch (IOException e) {
                    context.error("Can't create service: " + kv);
                    return Either.fail(e);
                }
            }
        }
        context.show("Running jar for " + output.getName() + "...");
        Either<Utils.CommandResult> execArchive = Utils.runCommand(context, jar, classOut, jarArguments);
        if (!execArchive.isSuccess()) {
            return Either.fail(execArchive.whyNot());
        }
        Utils.CommandResult archiving = execArchive.get();
        if (archiving.error.length() > 0) {
            return Either.fail(archiving.error);
        }
        return Either.success(execArchive.get());
    }

    private static List<String> makeJarArguments(Context context, File source, String type, File output, Map<String, List<String>> services) {
        ArrayList<String> jarArguments = new ArrayList<String>();
        jarArguments.add("cfm");
        jarArguments.add(output.getAbsolutePath());
        jarArguments.add("META-INF" + File.separator + "MANIFEST.MF");
        if (services != null && !services.isEmpty()) {
            if (Utils.isWindows()) {
                jarArguments.add("META-INF" + File.separator + "services" + File.separator + "*");
            } else {
                for (String key : services.keySet()) {
                    jarArguments.add("META-INF" + File.separator + "services" + File.separator + key);
                }
            }
        }
        int len = source.getAbsolutePath().length() + 1;
        if (Utils.isWindows()) {
            List<File> classDirs = Utils.findNonEmptyDirs(source, "." + type);
            for (File f : classDirs) {
                if (f.equals(source)) {
                    jarArguments.add("*." + type);
                    continue;
                }
                jarArguments.add(f.getAbsolutePath().substring(len) + File.separator + "*." + type);
            }
        } else {
            List<File> classFiles = Utils.findFiles(context, source, Collections.singletonList("." + type));
            for (File f : classFiles) {
                jarArguments.add(f.getAbsolutePath().substring(len));
            }
        }
        return jarArguments;
    }

    @Override
    public boolean check(Context context) {
        if (context.contains(INSTANCE)) {
            String path = context.get(INSTANCE);
            Either<String> javac = Utils.findCommand(context, path, "javac", "Usage: javac");
            if (!javac.isSuccess()) {
                context.error("java parameter is set, but Java compiler not found/doesn't work. Please check specified java parameter.");
                context.error("Trying to find javac in " + path);
                return false;
            }
            Either<String> jar = Utils.findCommand(context, path, "jar", "Usage: jar");
            if (!jar.isSuccess()) {
                context.error("java parameter is set, but Java archive tool not found/doesn't work. Please check specified java parameter.");
                context.error("Trying to find jar in " + path);
                return false;
            }
            context.cache("java_path_cache_javac", javac.get());
            context.cache("java_path_cache_jar", jar.get());
        }
        return true;
    }

    @Override
    public void run(Context context) {
    }

    @Override
    public String getShortDescription() {
        return "Specify custom path to Java compiler (javac) and Java Archive Tool (jar)";
    }

    @Override
    public String getDetailedDescription() {
        return "To compile Java libraries a Java compiler is required.\nIf javac is not available in the path, custom path can be used to specify it.\njar is required to package compiled .class files into .jar\n\nJDK_HOME and JAVA_HOME environment variables will be checked for Java tools.\n\nExample:\n\t/var/user/java-8\nwhere /var/user/java-8/javac and /var/user/java-8/jar exist";
    }

    static {
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
    }
}

