/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters;

import com.dslplatform.compiler.client.CompileParameter;
import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.Either;
import com.dslplatform.compiler.client.Utils;
import java.util.Collections;

public enum Mono implements CompileParameter
{
    INSTANCE;


    @Override
    public String getAlias() {
        return "mono";
    }

    @Override
    public String getUsage() {
        return "path";
    }

    public static Either<String> findMono(Context context) {
        if (context.contains(INSTANCE)) {
            return Either.success(context.get(INSTANCE));
        }
        if (Utils.testCommand(context, "mono", "Mono", Collections.singletonList("--version"))) {
            return Either.success("mono");
        }
        if (Utils.testCommand(context, "/usr/local/bin/mono", "Mono", Collections.singletonList("--version"))) {
            return Either.success("/usr/local/bin/mono");
        }
        if (Utils.testCommand(context, "/Library/Frameworks/Mono.framework/Versions/Current/bin/mono", "Mono", Collections.singletonList("--version"))) {
            return Either.success("/Library/Frameworks/Mono.framework/Versions/Current/bin/mono");
        }
        return Either.fail("Unable to find Mono. Add it to path or specify mono compile option.");
    }

    @Override
    public boolean check(Context context) {
        String compiler;
        if (context.contains(INSTANCE) && Utils.testCommand(context, compiler = context.get(INSTANCE), "Mono", Collections.singletonList("--version"))) {
            context.error("mono parameter is set, but Mono not found/doesn't work. Please check specified mono parameter.");
            return false;
        }
        return true;
    }

    @Override
    public void run(Context context) {
    }

    @Override
    public String getShortDescription() {
        return "Specify path to Mono";
    }

    @Override
    public String getDetailedDescription() {
        return "To run Mono applications, Mono is required (3+).\nOn Windows Mono is not required, but can be used, while on Linux Mono is usually available via command line.\n\nOn Linux Mono can be installed with sudo apt-get install mono-complete.\nMac version of Mono can be installed through installer at: http://www.mono-project.com/download/.\n\nIf custom path is required this option can be used to specify it.\n\nExample:\n\t/var/user/mono-3.10/mono";
    }
}

