/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters;

import com.dslplatform.compiler.client.CompileParameter;
import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.ExitException;
import com.dslplatform.compiler.client.parameters.DatabaseInfo;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum OracleConnection implements CompileParameter
{
    INSTANCE;

    private static final String CACHE_NAME = "oracle_dsl_cache";
    private static final String ORACLE_CUSTOM_DRIVER = "oracle_jdbc_driver";

    @Override
    public String getAlias() {
        return "oracle";
    }

    @Override
    public String getUsage() {
        return "connection_string";
    }

    public static Map<String, String> getDatabaseDsl(Context context) throws ExitException {
        return OracleConnection.getDatabaseDslAndVersion((Context)context).dsl;
    }

    static String extractOracleVersion(String version, Context context) {
        Matcher matcher = Pattern.compile("^\\w+\\s+(\\d+\\.\\d+)").matcher(version);
        if (!matcher.find()) {
            context.warning("Unable to detect Oracle version. Found version info: " + version);
            return "";
        }
        return matcher.group(1);
    }

    private static Connection getConnection(Context context, String url) throws SQLException {
        Driver driver = (Driver)context.load(ORACLE_CUSTOM_DRIVER);
        return driver == null ? DriverManager.getConnection(url) : driver.connect(url, null);
    }

    public static DatabaseInfo getDatabaseDslAndVersion(Context context) throws ExitException {
        String oracle;
        Statement stmt;
        Connection conn;
        DatabaseInfo cache = (DatabaseInfo)context.load(CACHE_NAME);
        if (cache != null) {
            return cache;
        }
        String previous = (String)context.load("previous-sql:oracle");
        if (previous != null) {
            return OracleConnection.extractDatabaseInfoFromMigration(context, previous);
        }
        String value = context.get(INSTANCE);
        String connectionString = "jdbc:oracle:thin:" + value;
        try {
            conn = OracleConnection.getConnection(context, connectionString);
            stmt = conn.createStatement();
            ResultSet dbVersion = stmt.executeQuery("SELECT * FROM V$VERSION where banner LIKE 'CORE%'");
            oracle = dbVersion.next() ? OracleConnection.extractOracleVersion(dbVersion.getString(1), context) : "";
            dbVersion.close();
        }
        catch (SQLException e) {
            context.error("Error opening connection to " + connectionString);
            context.error(e);
            throw new ExitException();
        }
        DatabaseInfo emptyResult = new DatabaseInfo("Oracle", "", oracle, new HashMap<String, String>());
        try {
            ResultSet migrationExist = stmt.executeQuery("SELECT COUNT(*) FROM sys.all_tables t\nWHERE (t.OWNER = '-DSL-' OR t.OWNER = '-NGS-') AND t.TABLE_NAME = 'DATABASE_MIGRATION'");
            boolean hasTable = migrationExist.next() && migrationExist.getLong(1) > 0L;
            migrationExist.close();
            if (!hasTable) {
                stmt.close();
                conn.close();
                context.cache(CACHE_NAME, emptyResult);
                return emptyResult;
            }
        }
        catch (SQLException ex) {
            context.error("Error checking for migration table in -DSL- schema");
            context.error(ex);
            OracleConnection.cleanup(conn, context);
            throw new ExitException();
        }
        try {
            String compiler;
            String lastDsl;
            ResultSet lastMigration;
            try {
                lastMigration = stmt.executeQuery("SELECT sq.Dsls, sq.Version\nFROM (SELECT m.Dsls, m.Version FROM \"-DSL-\".Database_Migration m ORDER BY m.Ordinal DESC) sq\nWHERE RowNum = 1");
            }
            catch (Throwable ignore) {
                lastMigration = stmt.executeQuery("SELECT sq.Dsls, sq.Version\nFROM (SELECT m.Dsls, m.Version FROM \"-NGS-\".Database_Migration m ORDER BY m.Ordinal DESC) sq\nWHERE RowNum = 1");
            }
            if (lastMigration.next()) {
                lastDsl = lastMigration.getString(1);
                compiler = lastMigration.getString(2);
            } else {
                compiler = "";
                lastDsl = "";
            }
            lastMigration.close();
            stmt.close();
            conn.close();
            if (lastDsl != null && lastDsl.length() > 0) {
                Map<String, String> dslMap = DatabaseInfo.convertToMap(lastDsl, context);
                DatabaseInfo result = new DatabaseInfo("Oracle", compiler, oracle, dslMap);
                context.cache(CACHE_NAME, result);
                return result;
            }
        }
        catch (SQLException ex) {
            context.error("Error loading previous DSL from migration table in -DSL- schema");
            context.error(ex);
            OracleConnection.cleanup(conn, context);
            throw new ExitException();
        }
        context.cache(CACHE_NAME, emptyResult);
        return emptyResult;
    }

    static DatabaseInfo extractDatabaseInfoFromMigration(Context context, String previous) throws ExitException {
        String lastDsl;
        String compiler;
        String dbVersion = (String)context.load("db-version:oracle");
        String pattern = "INSERT INTO \"-DSL-\".Database_Migration (Ordinal, Dsls, Version) VALUES(\"-DSL-\".DM_SEQ.nextval,";
        int persistInd = previous.lastIndexOf("INSERT INTO \"-DSL-\".Database_Migration (Ordinal, Dsls, Version) VALUES(\"-DSL-\".DM_SEQ.nextval,");
        if (persistInd == -1) {
            context.error("Unable to find INSERT INTO \"-DSL-\".Database_Migration in previous sql migration. Wrong file provided");
            throw new ExitException();
        }
        int patternSimpleStart = previous.indexOf("INSERT INTO \"-DSL-\".Database_Migration (Ordinal, Dsls, Version) VALUES(\"-DSL-\".DM_SEQ.nextval, '");
        int patternComplexStart = previous.indexOf("INSERT INTO \"-DSL-\".Database_Migration (Ordinal, Dsls, Version) VALUES(\"-DSL-\".DM_SEQ.nextval, dsls, '");
        String afterPersist = previous.substring(persistInd);
        int compilerEnd = afterPersist.lastIndexOf(39);
        int compilerStart = compilerEnd == -1 ? -1 : afterPersist.substring(0, compilerEnd - 1).lastIndexOf(39);
        String string = compiler = compilerStart == -1 ? "" : afterPersist.substring(compilerStart + 1, compilerEnd);
        if (compiler.length() == 0) {
            context.error("Unable to find appropriate compiler info after INSERT INTO \"-DSL-\".Database_Migration in previous sql migration. Wrong file provided");
            throw new ExitException();
        }
        if (patternSimpleStart >= 0) {
            lastDsl = afterPersist.substring("INSERT INTO \"-DSL-\".Database_Migration (Ordinal, Dsls, Version) VALUES(\"-DSL-\".DM_SEQ.nextval,".length() + 2, compilerStart - 3);
        } else if (patternComplexStart >= 0) {
            int scEnd;
            StringBuilder dsls = new StringBuilder();
            int clobStart = previous.indexOf("dsls := '");
            if (clobStart == -1) {
                context.error("Unable to find appropriate dsls := in previous sql migration. Wrong file provided");
                throw new ExitException();
            }
            clobStart += "dsls := '".length();
            int clobEnd = previous.indexOf("dsls := dsls || '");
            while (clobEnd != -1) {
                String part = previous.substring(clobStart, clobEnd);
                scEnd = part.lastIndexOf(39);
                dsls.append(part, 0, scEnd);
                clobStart = clobEnd + "dsls := dsls || '".length();
                clobEnd = previous.indexOf("dsls := dsls || '", clobStart);
            }
            String lastPart = previous.substring(clobStart, persistInd);
            scEnd = lastPart.lastIndexOf(39);
            dsls.append(lastPart, 0, scEnd);
            lastDsl = dsls.toString();
        } else {
            context.error("Unable to find appropriate INSERT INTO \"-DSL-\".Database_Migration in previous sql migration. Wrong file provided");
            throw new ExitException();
        }
        Map<String, String> dslMap = DatabaseInfo.convertToMap(lastDsl.replace("''", "'"), context);
        DatabaseInfo result = new DatabaseInfo("Oracle", compiler, dbVersion, dslMap);
        context.cache(CACHE_NAME, result);
        return result;
    }

    public static void execute(Context context, String sql) throws ExitException {
        Statement stmt;
        Connection conn;
        String value = context.get(INSTANCE);
        String connectionString = "jdbc:oracle:thin:" + value;
        try {
            conn = OracleConnection.getConnection(context, connectionString);
            stmt = conn.createStatement();
        }
        catch (SQLException e) {
            context.error("Error opening connection to " + connectionString);
            context.error(e);
            throw new ExitException();
        }
        int migrationEnds = sql.indexOf("MIGRATION_DESCRIPTION*/");
        String rawSql = migrationEnds == -1 ? sql : sql.substring(migrationEnds + "MIGRATION_DESCRIPTION*/".length());
        String[] parts = rawSql.contains("\r\n") ? rawSql.split("\r\n/\r\n") : rawSql.split("\n/\n");
        try {
            for (String part : parts) {
                String trimmed = part.trim();
                if (trimmed.length() <= 0) continue;
                context.log(trimmed);
                stmt.execute(trimmed);
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            context.error("Error executing SQL script");
            context.error(ex);
            OracleConnection.cleanup(conn, context);
            throw new ExitException();
        }
    }

    private static void cleanup(Connection conn, Context context) {
        try {
            conn.close();
        }
        catch (SQLException ex2) {
            context.error("Error cleaning up connection.");
            context.error(ex2);
        }
    }

    private static Credentials parse(String connectionString) {
        String[] args = connectionString.substring(0, connectionString.indexOf(64)).split("/");
        if (args.length == 2) {
            return new Credentials(args[0], args[1]);
        }
        return null;
    }

    private static boolean testConnection(Context context) throws ExitException {
        String connectionString = context.get(INSTANCE);
        try {
            Connection conn = OracleConnection.getConnection(context, "jdbc:oracle:thin:" + connectionString);
            Statement stmt = conn.createStatement();
            stmt.execute("SELECT 1 FROM dual");
            stmt.close();
            conn.close();
        }
        catch (SQLException e) {
            String password;
            if (context.canInteract()) {
                context.warning("Error connecting to the database.");
                context.warning(e);
            } else {
                context.error("Error connecting to the database.");
                context.error(e);
            }
            if (e.getErrorCode() == 12514) {
                context.error("Oracle database not found. Please create database before using clc or check if correct connection string was provided");
                return false;
            }
            if (e.getErrorCode() != 1017) {
                return false;
            }
            if (!context.canInteract()) {
                context.show(new String[0]);
                context.error("Please provide correct password to access Oracle database.");
                throw new ExitException();
            }
            Credentials args = OracleConnection.parse(connectionString);
            String user = args != null ? args.user : "";
            String string = password = args != null ? args.password : "";
            if (password.length() != 0) {
                String answer = context.ask("Retry database connection with different credentials (y/N):");
                if (!"y".equalsIgnoreCase(answer)) {
                    return false;
                }
            } else {
                String question = user.length() != 0 ? "Oracle username (" + user + "): " : "Oracle username: ";
                String value = context.ask(question);
                if (value.length() > 0) {
                    user = value;
                } else if (user.length() == 0) {
                    context.error("Username not provided");
                    throw new ExitException();
                }
            }
            char[] pass = context.askSecret("Oracle password: ");
            password = new String(pass);
            int questionIndex = connectionString.indexOf(64);
            String newCs = user + "/" + password + connectionString.substring(questionIndex);
            context.put(INSTANCE, newCs);
            return OracleConnection.testConnection(context);
        }
        return true;
    }

    @Override
    public boolean check(Context context) throws ExitException {
        block22: {
            if (!context.contains(INSTANCE)) {
                return true;
            }
            String value = context.get(INSTANCE);
            if (value == null || !value.contains("@") || !value.contains(":")) {
                context.error("Invalid connection string defined. An example: @localhost:1521/DbRevenj");
                throw new ExitException();
            }
            try {
                Class.forName("oracle.jdbc.OracleDriver");
            }
            catch (ClassNotFoundException ex) {
                ArrayList<File> jars;
                context.warning("Error loading Oracle driver (oracle.jdbc.OracleDriver). Will look into alternative locations ...");
                File loc = new File(".");
                File[] foundFiles = loc.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        String name = file.getName().toLowerCase();
                        return name.startsWith("ojdbc") && name.endsWith(".jar");
                    }
                });
                ArrayList<File> arrayList = jars = foundFiles == null ? new ArrayList<File>(0) : new ArrayList<File>(Arrays.asList(foundFiles));
                if (jars.size() == 0) {
                    String envOH = System.getenv("ORACLE_HOME");
                    if (envOH != null) {
                        context.log("Found ORACLE_HOME environment variable: " + envOH);
                        File jdbcRootFile = new File(new File(envOH), "ojdbc6.jar");
                        File jdbcLibFile = new File(new File(new File(new File(envOH), "jdbc"), "lib"), "ojdbc6.jar");
                        if (jdbcRootFile.exists()) {
                            jars.add(jdbcRootFile.getAbsoluteFile());
                        } else if (jdbcLibFile.exists()) {
                            jars.add(jdbcLibFile.getAbsoluteFile());
                        } else {
                            context.warning("Found ORACLE_HOME environment variable, but jar driver is missing from: " + jdbcRootFile.getAbsolutePath() + " and " + jdbcLibFile.getAbsolutePath());
                        }
                    } else {
                        context.warning("ORACLE_HOME environment variable not set");
                    }
                }
                if (jars.size() == 0) {
                    context.error("Try downloading ojdbc6.jar from Oracle: http://www.oracle.com/technetwork/apps-tech/jdbc-112010-090769.html and place it in: " + new File(".").getAbsolutePath() + "\nAlternatively, try adding thin ojdbc to the classpath or set correct ORACLE_HOME environment variable.");
                    throw new ExitException();
                }
                URL[] urls = new URL[jars.size()];
                for (int i = 0; i < jars.size(); ++i) {
                    try {
                        urls[i] = ((File)jars.get(i)).toURI().toURL();
                        continue;
                    }
                    catch (MalformedURLException mex) {
                        context.error(mex);
                    }
                }
                URLClassLoader ucl = new URLClassLoader(urls);
                ServiceLoader<Driver> drivers = ServiceLoader.load(Driver.class, ucl);
                for (Driver d : drivers) {
                    context.log("Found: " + d);
                    if (!"oracle.jdbc.OracleDriver".equals(d.getClass().getName())) continue;
                    if (urls.length == 1) {
                        context.show("Found Oracle driver in: " + urls[0].getPath());
                    } else {
                        context.show("Found Oracle driver");
                    }
                    try {
                        Driver driver = (Driver)d.getClass().newInstance();
                        context.cache(ORACLE_CUSTOM_DRIVER, driver);
                    }
                    catch (Exception de) {
                        context.error(de);
                    }
                }
                try {
                    Class.forName("oracle.jdbc.OracleDriver");
                }
                catch (ClassNotFoundException oex) {
                    if (context.load(ORACLE_CUSTOM_DRIVER) != null) break block22;
                    context.error("Error trying to load Oracle driver using fallback method. Add thin ojdbc to the classpath.");
                    throw new ExitException();
                }
            }
        }
        return OracleConnection.testConnection(context);
    }

    @Override
    public void run(Context context) {
    }

    @Override
    public String getShortDescription() {
        return "Connection string to Oracle database. To create an SQL migration a database with previous DSL must be provided";
    }

    @Override
    public String getDetailedDescription() {
        return "Previous version of DSL is required for various actions, such as diff and SQL migration.\nConnection string can be passed from the properties file or as command argument.\nIf password is not defined in the connection string and console is available, it will prompt for database credentials.\n\nExample connection strings:\n\n\t@localhost:1521/ServiceName\n\tuser/pass@server:1521/DB\n\nMore info about connection strings can be found on Oracle JDBC site: http://docs.oracle.com/cd/E11882_01/appdev.112/e13995/oracle/jdbc/OracleDriver.html\nConnection string is defined without the jdbc:oracle:thin: part";
    }

    static class Credentials {
        public final String user;
        public final String password;

        public Credentials(String user, String password) {
            this.user = user;
            this.password = password;
        }
    }
}

