/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters;

import com.dslplatform.compiler.client.CompileParameter;
import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.Either;
import com.dslplatform.compiler.client.ExitException;
import com.dslplatform.compiler.client.parameters.DslCompiler;
import com.dslplatform.compiler.client.parameters.DslPath;
import java.util.Map;

public enum Parse implements CompileParameter
{
    INSTANCE;


    @Override
    public String getAlias() {
        return "parse";
    }

    @Override
    public String getUsage() {
        return null;
    }

    @Override
    public boolean check(Context context) throws ExitException {
        Map<String, String> dslMap;
        if (context.contains(INSTANCE) && (dslMap = DslPath.getCurrentDsl(context)).size() == 0) {
            context.error("DSL files not found in: '" + context.get(DslPath.INSTANCE) + "'. At least one DSL file required.");
            return false;
        }
        return true;
    }

    @Override
    public void run(Context context) throws ExitException {
        if (context.contains(INSTANCE)) {
            context.show("Validating DSL ...");
            Either<Boolean> result = DslCompiler.parse(context, DslPath.getDslPaths(context));
            if (result.isSuccess()) {
                context.show("Parse successful.");
            } else {
                context.error(result.whyNot());
                throw new ExitException();
            }
        }
    }

    @Override
    public String getShortDescription() {
        return "Parse current DSL to check for errors";
    }

    @Override
    public String getDetailedDescription() {
        return "This library uses external parser for DSL. Parser can be started through: DslCompiler.setupServer method.\nEclipse, IntelliJ IDEA and other IDE plugins use such setup for syntax highlighting.\n\nDSL Platform compiler can be used to validate current DSL. Error descriptions will be provided in case of errors.";
    }
}

