/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters;

import com.dslplatform.compiler.client.CompileParameter;
import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.ExitException;
import com.dslplatform.compiler.client.parameters.ApplyMigration;
import com.dslplatform.compiler.client.parameters.DatabaseInfo;
import com.dslplatform.compiler.client.parameters.Force;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum PostgresConnection implements CompileParameter
{
    INSTANCE;

    private static final String CACHE_NAME = "postgres_dsl_cache";

    @Override
    public String getAlias() {
        return "postgres";
    }

    @Override
    public String getUsage() {
        return "connection_string";
    }

    public static Map<String, String> getDatabaseDsl(Context context) throws ExitException {
        return PostgresConnection.getDatabaseDslAndVersion((Context)context).dsl;
    }

    static String extractPostgresVersion(String version, Context context) {
        Matcher matcher = Pattern.compile("^\\w+\\s+(\\d+\\.\\d+)").matcher(version);
        if (!matcher.find()) {
            context.warning("Unable to detect Postgres version. Found version info: " + version);
            return "";
        }
        return matcher.group(1);
    }

    public static DatabaseInfo getDatabaseDslAndVersion(Context context) throws ExitException {
        boolean hasNewTable;
        String postgres;
        Statement stmt;
        Connection conn;
        DatabaseInfo cache = (DatabaseInfo)context.load(CACHE_NAME);
        if (cache != null) {
            return cache;
        }
        String previous = (String)context.load("previous-sql:postgres");
        if (previous != null) {
            return PostgresConnection.extractDatabaseInfoFromMigration(context, previous);
        }
        String value = context.get(INSTANCE);
        String connectionString = "jdbc:postgresql://" + value;
        try {
            conn = DriverManager.getConnection(connectionString);
            stmt = conn.createStatement();
            ResultSet pgVersion = stmt.executeQuery("SELECT version()");
            postgres = pgVersion.next() ? PostgresConnection.extractPostgresVersion(pgVersion.getString(1), context) : "";
            pgVersion.close();
        }
        catch (SQLException e) {
            context.error("Error opening connection to " + connectionString);
            context.error(e);
            throw new ExitException();
        }
        DatabaseInfo emptyResult = new DatabaseInfo("Postgres", "", postgres, new HashMap<String, String>());
        try {
            boolean hasOldTable;
            ResultSet migrationExist = stmt.executeQuery("SELECT EXISTS(SELECT 1 FROM pg_tables WHERE schemaname = '-DSL-' AND tablename = 'database_migration') AS new_name, EXISTS(SELECT 1 FROM pg_tables WHERE schemaname = '-NGS-' AND tablename = 'database_migration') AS old_name");
            if (migrationExist.next()) {
                hasNewTable = migrationExist.getBoolean(1);
                hasOldTable = migrationExist.getBoolean(2);
            } else {
                hasNewTable = false;
                hasOldTable = false;
            }
            migrationExist.close();
            if (!hasNewTable && !hasOldTable) {
                stmt.close();
                conn.close();
                context.cache(CACHE_NAME, emptyResult);
                return emptyResult;
            }
        }
        catch (SQLException ex) {
            context.error("Error checking for migration table in -DSL- schema");
            context.error(ex);
            PostgresConnection.cleanup(conn, context);
            throw new ExitException();
        }
        try {
            String compiler;
            String lastDsl;
            ResultSet lastMigration;
            ResultSet resultSet = lastMigration = hasNewTable ? stmt.executeQuery("SELECT dsls, version FROM \"-DSL-\".database_migration ORDER BY ordinal DESC LIMIT 1") : stmt.executeQuery("SELECT dsls, version FROM \"-NGS-\".database_migration ORDER BY ordinal DESC LIMIT 1");
            if (lastMigration.next()) {
                lastDsl = lastMigration.getString(1);
                compiler = lastMigration.getString(2);
            } else {
                compiler = "";
                lastDsl = "";
            }
            lastMigration.close();
            stmt.close();
            conn.close();
            if (lastDsl != null && lastDsl.length() > 0) {
                Map<String, String> dslMap = DatabaseInfo.convertToMap(lastDsl, context);
                DatabaseInfo result = new DatabaseInfo("Postgres", compiler, postgres, dslMap);
                context.cache(CACHE_NAME, result);
                return result;
            }
        }
        catch (SQLException ex) {
            context.error("Error loading previous DSL from migration table in -DSL- schema");
            context.error(ex);
            PostgresConnection.cleanup(conn, context);
            throw new ExitException();
        }
        context.cache(CACHE_NAME, emptyResult);
        return emptyResult;
    }

    static DatabaseInfo extractDatabaseInfoFromMigration(Context context, String previous) throws ExitException {
        String dbVersion = (String)context.load("db-version:postgres");
        int persistInd = previous.lastIndexOf("SELECT \"-DSL-\".Persist_Concepts('");
        int notifyInd = previous.indexOf("SELECT pg_notify", persistInd + 1);
        if (persistInd == -1 || notifyInd == -1) {
            context.error("Unable to find 'Persist_Concepts' or SELECT pg_notify in previous sql migration. Wrong file provided");
            throw new ExitException();
        }
        String subset = previous.substring(persistInd + "SELECT \"-DSL-\".Persist_Concepts(".length() + 1, notifyInd - 2);
        String pattern = "\"', '\\x','";
        int lastNL = subset.lastIndexOf("\"', '\\x','");
        if (lastNL == -1) {
            context.error("Invalid content detected in previous sql migration. Unable to find magic pattern: \"', '\\x','");
            throw new ExitException();
        }
        String compiler = subset.substring(lastNL + "\"', '\\x','".length(), subset.lastIndexOf(39));
        String lastDsl = subset.substring(0, lastNL + 1).replace("''", "'");
        Map<String, String> dslMap = DatabaseInfo.convertToMap(lastDsl, context);
        DatabaseInfo result = new DatabaseInfo("Postgres", compiler, dbVersion, dslMap);
        context.cache(CACHE_NAME, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(final Context context, final String sql) throws ExitException {
        block17: {
            Statement stmt;
            Connection conn;
            String connectionString = "jdbc:postgresql://" + context.get(INSTANCE);
            try {
                Properties props = new Properties();
                props.setProperty("preferQueryMode", "simple");
                conn = DriverManager.getConnection(connectionString, props);
                stmt = conn.createStatement();
            }
            catch (SQLException e) {
                context.error("Error opening connection to " + connectionString);
                context.error(e);
                throw new ExitException();
            }
            try {
                try {
                    long startAt = System.currentTimeMillis();
                    final boolean[] isDone = new boolean[1];
                    final boolean[] hasErrors = new boolean[1];
                    final boolean[] waitingAnswer = new boolean[1];
                    Thread waitResp = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                stmt.execute(sql);
                                hasErrors[0] = false;
                            }
                            catch (Exception ex) {
                                context.error(ex);
                                hasErrors[0] = true;
                            }
                            isDone[0] = true;
                            if (waitingAnswer[0]) {
                                context.show("Query finished while waiting for answer");
                            }
                        }
                    });
                    waitResp.start();
                    waitResp.join(100L);
                    int timeout = 0;
                    while (!isDone[0] && timeout < 600) {
                        waitResp.join(1000L);
                        if (++timeout == 10) {
                            context.warning("Query execution is taking a long time...");
                        } else if (timeout % 10 == 0) {
                            context.warning("Still waiting...");
                        }
                        if (isDone[0] || timeout % 30 != 0 || !context.canInteract()) continue;
                        waitingAnswer[0] = true;
                        String response = context.ask("Abort executing query [y/N]?");
                        waitingAnswer[0] = false;
                        if (!"y".equalsIgnoreCase(response) || isDone[0]) continue;
                        stmt.cancel();
                        context.error("Canceled SQL script execution");
                        throw new ExitException();
                    }
                    long endAt = System.currentTimeMillis();
                    if (hasErrors[0]) {
                        context.error("Error executing SQL script.");
                        throw new ExitException();
                    }
                    if (isDone[0]) {
                        context.log("Script executed in " + (endAt - startAt) + "ms");
                        break block17;
                    }
                    context.error("Failed to execute script. Timeout out waiting.");
                    throw new ExitException();
                }
                catch (Exception ex) {
                    context.error("Error executing SQL script");
                    context.error(ex);
                    throw new ExitException();
                }
            }
            finally {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void cleanup(Connection conn, Context context) {
        try {
            conn.close();
        }
        catch (SQLException ex2) {
            context.error("Error cleaning up connection.");
            context.error(ex2);
        }
    }

    private static Properties parse(String connectionString) {
        int questionIndex = connectionString.indexOf(63);
        if (questionIndex == -1) {
            return new Properties();
        }
        String[] args = connectionString.substring(questionIndex + 1).split("&");
        Properties map = new Properties();
        for (String a : args) {
            String[] vals = a.split("=");
            if (vals.length != 2) {
                return null;
            }
            map.put(vals[0], vals[1]);
        }
        return map;
    }

    private static boolean testConnection(Context context) throws ExitException {
        String connectionString = context.get(INSTANCE);
        try {
            Connection conn = DriverManager.getConnection("jdbc:postgresql://" + connectionString);
            Statement stmt = conn.createStatement();
            stmt.execute(";");
            stmt.close();
            conn.close();
        }
        catch (SQLException e) {
            if (context.canInteract()) {
                context.warning("Error connecting to the database.");
                context.warning(e);
            } else {
                context.error("Error connecting to the database.");
                context.error(e);
            }
            boolean dbDoesntExists = "3D000".equals(e.getSQLState());
            boolean dbMissingPassword = "08004".equals(e.getSQLState());
            boolean dbWrongPassword = "28P01".equals(e.getSQLState());
            Properties args = PostgresConnection.parse(connectionString);
            if (args == null) {
                context.show(new String[0]);
                context.error("Invalid connection string provided: " + connectionString);
                context.show("Example connection string: 127.0.0.1:5432/RevenjDb?user=postgres&password=secret");
                return false;
            }
            if (dbDoesntExists && context.contains(Force.INSTANCE) && context.contains(ApplyMigration.INSTANCE) && args.containsKey("user") && args.containsKey("password")) {
                int sl = connectionString.indexOf("/");
                String dbName = connectionString.substring(sl + 1, connectionString.indexOf("?"));
                if (!context.canInteract()) {
                    context.show("Trying to create new database " + dbName + " due to force option");
                } else {
                    String answer = context.ask("Create a new database " + dbName + " (y/N):");
                    if (!"y".equalsIgnoreCase(answer)) {
                        throw new ExitException();
                    }
                }
                try {
                    StringBuilder newCs = new StringBuilder(connectionString.substring(0, sl + 1));
                    newCs.append("postgres?");
                    for (Map.Entry<Object, Object> kv : args.entrySet()) {
                        newCs.append(kv.getKey()).append("=").append(kv.getValue());
                        newCs.append("&");
                    }
                    Connection conn = DriverManager.getConnection("jdbc:postgresql://" + newCs.toString());
                    Statement stmt = conn.createStatement();
                    stmt.execute("CREATE DATABASE \"" + dbName + "\"");
                    stmt.close();
                    conn.close();
                }
                catch (SQLException ex) {
                    context.error("Error creating new database: " + dbName);
                    context.error(ex);
                    return false;
                }
                return true;
            }
            if (!context.canInteract()) {
                if (dbMissingPassword) {
                    context.show(new String[0]);
                    context.error("Password not sent. Since interaction is not available, password must be sent as argument.");
                    context.show("Example connection string: my.server.com:5432/MyDatabase?user=user&password=password");
                } else if (dbDoesntExists) {
                    context.show(new String[0]);
                    context.error("Database not found. Since interaction is not available and both force and apply option are not enabled, existing database must be used.");
                } else if (dbWrongPassword) {
                    context.show(new String[0]);
                    context.error("Please provide correct password to access Postgres database.");
                }
                throw new ExitException();
            }
            if (dbDoesntExists) {
                context.show(new String[0]);
                if (context.contains(ApplyMigration.INSTANCE)) {
                    context.error("Database not found. Since force option is not enabled, existing database must be used.");
                } else {
                    context.error("Database not found. Use both force and apply to both create a new database and apply migration to it.");
                }
                return false;
            }
            if (args.getProperty("password") != null) {
                String answer = context.ask("Retry database connection with different credentials (y/N):");
                if (!"y".equalsIgnoreCase(answer)) {
                    return false;
                }
            } else {
                String user = args.getProperty("user");
                String question = user != null ? "Postgres username (" + user + "): " : "Postgres username: ";
                String value = context.ask(question);
                if (value.length() > 0) {
                    args.put("user", value);
                } else if (user == null) {
                    context.error("Username not provided");
                    throw new ExitException();
                }
            }
            char[] pass = context.askSecret("Postgres password: ");
            args.put("password", new String(pass));
            int questionIndex = connectionString.indexOf(63);
            String newCs = questionIndex == -1 ? connectionString + "?" : connectionString.substring(0, questionIndex + 1);
            StringBuilder csBuilder = new StringBuilder(newCs);
            for (Map.Entry<Object, Object> kv : args.entrySet()) {
                csBuilder.append(kv.getKey()).append("=").append(kv.getValue());
                csBuilder.append("&");
            }
            context.put(INSTANCE, csBuilder.toString());
            return PostgresConnection.testConnection(context);
        }
        return true;
    }

    @Override
    public boolean check(Context context) throws ExitException {
        if (!context.contains(INSTANCE)) {
            return true;
        }
        String value = context.get(INSTANCE);
        if (value == null || !value.contains("/")) {
            context.error("Invalid connection string defined. An example: localhost:5433/DbRevenj?user=postgres&password=password");
            throw new ExitException();
        }
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException ex) {
            context.error("Error loading Postgres driver.");
            throw new ExitException();
        }
        return PostgresConnection.testConnection(context);
    }

    @Override
    public void run(Context context) {
    }

    @Override
    public String getShortDescription() {
        return "Connection string to Postgres database. To create an SQL migration a database with previous DSL must be provided";
    }

    @Override
    public String getDetailedDescription() {
        return "Previous version of DSL is required for various actions, such as diff and SQL migration.\nConnection string can be passed from the properties file or as command argument.\nIf password is not defined in the connection string and console is available, it will prompt for database credentials.\n\nExample connection strings:\n\n\tlocalhost/mydb\n\tlocalhost/Database?user=postgres\n\tserver:5432/DB?user=migration&password=secret&ssl=true\n\nMore info about connection strings can be found on PostgreSQL JDBC site: http://jdbc.postgresql.org/documentation/93/connect.html\nConnection string is defined without the jdbc:postgresql:// part";
    }
}

