/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters;

import com.dslplatform.compiler.client.CompileParameter;
import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.Either;
import com.dslplatform.compiler.client.Utils;
import java.io.File;

public enum ScalaPath implements CompileParameter
{
    INSTANCE;


    @Override
    public String getAlias() {
        return "scalac";
    }

    @Override
    public String getUsage() {
        return "file";
    }

    public static Either<String> findCompiler(Context context) {
        if (context.contains(INSTANCE)) {
            File scalac = new File(context.get(INSTANCE));
            return Either.success(scalac.getAbsolutePath());
        }
        if (Utils.testCommand(context, "scalac", "Usage: scalac")) {
            return Either.success("scalac");
        }
        String envSH = System.getenv("SCALA_HOME");
        if (envSH != null && Utils.testCommand(context, envSH + "/bin/scalac", "Usage: scalac")) {
            return Either.success(envSH + "/bin/scalac");
        }
        if (Utils.isWindows() && envSH != null && Utils.testCommand(context, envSH + "/bin/scalac.bat", "Usage: scalac")) {
            return Either.success(envSH + "/bin/scalac.bat");
        }
        if (Utils.isWindows() && Utils.testCommand(context, "scalac.bat", "Usage: scalac")) {
            return Either.success("scalac.bat");
        }
        return Either.fail("Unable to find the Scala compiler. Add it to path or specify scala compile option.");
    }

    @Override
    public boolean check(Context context) {
        String path;
        File scalac;
        if (context.contains(INSTANCE) && !Utils.testCommand(context, (scalac = new File(path = context.get(INSTANCE))).getAbsolutePath(), "Usage: scalac")) {
            context.error("scalac parameter is set, but Scala compiler not found/doesn't work. Please check specified scalac parameter.");
            context.error("Trying to use: " + scalac.getAbsolutePath());
            return false;
        }
        return true;
    }

    @Override
    public void run(Context context) {
    }

    @Override
    public String getShortDescription() {
        return "Specify custom path to Scala compiler (scalac)";
    }

    @Override
    public String getDetailedDescription() {
        return "To compile Scala libraries Scala compiler is required.\nIf scalac is not available in path, custom path can be used to specify it.\njar from Java compiler is required to package compiled .class files into .jar\nSCALA_HOME environment variables will be checked for Scala tools.\n\nExample:\n\tC:\\Scala\\scala-2.11.7\\bin\\scalac.bat\t/var/user/scala-2.11/scalac";
    }
}

