/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters;

import com.dslplatform.compiler.client.CompileParameter;
import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.Either;
import com.dslplatform.compiler.client.ParameterParser;
import com.dslplatform.compiler.client.parameters.Force;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum Settings implements CompileParameter,
ParameterParser
{
    INSTANCE;

    private static final String CACHE_NAME = "settings_option_cache";

    @Override
    public String getAlias() {
        return "settings";
    }

    @Override
    public String getUsage() {
        return "options";
    }

    public static List<String> get(Context context) {
        return (List)context.load(CACHE_NAME);
    }

    public static boolean hasSourceOnly(Context context) {
        List<String> options = Settings.get(context);
        return options != null && options.contains(Option.SOURCE_ONLY.value);
    }

    private static void listOptions(Context context) {
        for (Option o : Option.values()) {
            context.show(o.value + " - " + o.description);
        }
        context.show("Example usages:");
        context.show("\tsettings=active-record,joda-time,jackson");
        context.show("\tactive-record manual-json");
    }

    @Override
    public Either<Boolean> tryParse(String name, String value, Context context) {
        if (Option.from(name) != null) {
            if (value != null && value.length() > 0) {
                return Either.fail("Settings parameter detected, but settings don't support arguments. Parameter: " + name);
            }
            context.put(name, null);
            return Either.success(true);
        }
        return Either.success(false);
    }

    @Override
    public boolean check(Context context) {
        ArrayList<String> settings = new ArrayList<String>();
        if (context.contains(INSTANCE)) {
            String value = context.get(INSTANCE);
            if (value == null || value.length() == 0) {
                context.error("Settings not provided. Available settings: ");
                Settings.listOptions(context);
                return false;
            }
            Collections.addAll(settings, value.split(","));
        }
        for (Option option : Option.values()) {
            if (!context.contains(option.value) || settings.contains(option.value)) continue;
            settings.add(option.value);
        }
        if (settings.size() == 0) {
            if (context.contains(INSTANCE)) {
                context.error("Settings not provided. Available settings: ");
                Settings.listOptions(context);
                return false;
            }
            return true;
        }
        ArrayList<String> options = new ArrayList<String>(settings.size());
        for (String name : settings) {
            Option option = Option.from(name);
            if (option == null) {
                if (!context.contains(Force.INSTANCE)) {
                    context.error("Unknown setting: " + name + ". If you wish to use this setting, enable force option.");
                    Settings.listOptions(context);
                    return false;
                }
                context.warning("Unknown setting: " + name + ". Adding it due to force option.");
                options.add(name);
                continue;
            }
            options.add(option.value);
        }
        context.cache(CACHE_NAME, options);
        return true;
    }

    @Override
    public void run(Context context) {
    }

    @Override
    public String getShortDescription() {
        return "Custom compile settings for DSL -> target conversion (Active record, Jackson, etc...)";
    }

    @Override
    public String getDetailedDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("DSL Platform compiler supports various compilation options for tweaking target library.\n");
        sb.append("Some options are only available in some languages.\n");
        sb.append("'Unsupported' settings can be passed using force option.\n");
        sb.append("--------------------------------------------------\n");
        for (Option o : Option.values()) {
            sb.append(o.value).append(" - ").append(o.description).append("\n");
        }
        return sb.toString();
    }

    public static enum Option {
        ACTIVE_RECORD("active-record", "Active record pattern in client libraries"),
        UTC("utc", "Timestamp should use UTC by default"),
        JACKSON("jackson", "Add Jackson annotations"),
        JAVA_BEANS("java-beans", "Add Java Beans support"),
        MANUAL_JSON("manual-json", "Add optimized serialization/deserialization methods"),
        NO_HELPERS("no-helpers", "Don't use helper methods"),
        MULTI_TENANCY("multi-tenancy", "Support Multi-tenancy on server"),
        LEGACY("legacy", "Legacy methods"),
        SOURCE_ONLY("source-only", "Only provide source code, don't run post-step (compilation)"),
        JODA_TIME("joda-time", "Use Joda Time library (instead of Java time API)"),
        NO_PREPARE_EXECUTE("no-prepare-execute", "Don't use PREPARE/EXECUTE statements in Postgres"),
        MINIMAL_SERIALIZATION("minimal-serialization", "Minimize serialization output (omit default values)"),
        LAZY_LOAD_WARNING("lazy-load-warning", "Inject warning when accessing lazy load property"),
        URI_REFERENCE("uri-reference", "Helper method for setting reference through URI value"),
        JAXB("jaxb", "Add annotations and converters for Java Architecture for XML Binding (JAXB)"),
        DISABLE_COMPANION("disable-companion", "Don't use companion object for scala classes");

        private final String value;
        private final String description;

        private Option(String value, String description) {
            this.value = value;
            this.description = description;
        }

        private static Option from(String value) {
            for (Option o : Option.values()) {
                if (!o.value.equalsIgnoreCase(value)) continue;
                return o;
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

