/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters;

import com.dslplatform.compiler.client.CompileParameter;
import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.Either;
import com.dslplatform.compiler.client.ExitException;
import com.dslplatform.compiler.client.ParameterParser;
import com.dslplatform.compiler.client.Utils;
import com.dslplatform.compiler.client.parameters.DslCompiler;
import com.dslplatform.compiler.client.parameters.DslPath;
import com.dslplatform.compiler.client.parameters.Namespace;
import com.dslplatform.compiler.client.parameters.Settings;
import com.dslplatform.compiler.client.parameters.TempPath;
import com.dslplatform.compiler.client.parameters.Version;
import com.dslplatform.compiler.client.parameters.build.BuildAction;
import com.dslplatform.compiler.client.parameters.build.CompileCsClient;
import com.dslplatform.compiler.client.parameters.build.CompileJavaClient;
import com.dslplatform.compiler.client.parameters.build.CompileRevenjJava;
import com.dslplatform.compiler.client.parameters.build.CompileRevenjNet;
import com.dslplatform.compiler.client.parameters.build.CompileRevenjScala;
import com.dslplatform.compiler.client.parameters.build.CompileScalaClient;
import com.dslplatform.compiler.client.parameters.build.PreparePhpUI;
import com.dslplatform.compiler.client.parameters.build.PrepareSources;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public enum Targets implements CompileParameter,
ParameterParser
{
    INSTANCE;

    private static final String[] DOTNET_CLIENT_DEPENDENCIES;
    private static final String[] DOTNET_WPF_DEPENDENCIES;
    private static final String CACHE_NAME = "target_option_cache";

    @Override
    public String getAlias() {
        return "target";
    }

    @Override
    public String getUsage() {
        return "options";
    }

    private static void listOptions(Context context) {
        for (Option o : Option.values()) {
            context.show(o.value + " - " + o.description);
        }
        context.show("Example usages:");
        context.show("\t-target=java_client,revenj.net");
        context.show("\t-java_client -revenj.net=./model/SeverModel.dll");
    }

    @Override
    public Either<Boolean> tryParse(String name, String value, Context context) {
        if (Option.from(name) != null) {
            context.put(name, value == null || value.length() == 0 ? null : value);
            return Either.success(true);
        }
        for (Option o : Option.values()) {
            if (("dependencies:" + o.value).equalsIgnoreCase(name) || ("dependency:" + o.value).equalsIgnoreCase(name)) {
                if (value == null || value.length() == 0) {
                    return Either.fail("Target dependency parameter detected, but it's missing path as argument. Parameter: " + name);
                }
                File path = new File(value);
                if (path.exists() && !path.isDirectory()) {
                    return Either.fail("Target dependency path found, but it's not a directory. Parameter: " + name);
                }
                context.put("dependency:" + o.value, value);
                return Either.success(true);
            }
            if (("libraries:" + o.value).equalsIgnoreCase(name) || ("library:" + o.value).equalsIgnoreCase(name)) {
                if (value == null || value.length() == 0) {
                    return Either.fail("Target library parameter detected, but it's missing version as argument. Parameter: " + name);
                }
                context.put("library:" + o.value, value);
                return Either.success(true);
            }
            if (("configuration:" + o.value).equalsIgnoreCase(name)) {
                if (value == null || value.length() == 0) {
                    return Either.fail("Target library parameter detected, but it's missing configuration as argument. Parameter: " + name);
                }
                context.put("configuration:" + o.value, value);
                return Either.success(true);
            }
            if (!("sources:" + o.value).equalsIgnoreCase(name) && !("source:" + o.value).equalsIgnoreCase(name)) continue;
            if (value == null || value.length() == 0) {
                return Either.fail("Target source parameter detected, but it's missing path as argument. Parameter: " + name);
            }
            File path = new File(value);
            if (path.exists() && !path.isDirectory()) {
                return Either.fail("Target source path found, but it's not a directory. Parameter: " + name);
            }
            context.put("source:" + o.value, value);
            return Either.success(true);
        }
        return Either.success(false);
    }

    @Override
    public boolean check(Context context) throws ExitException {
        ArrayList<String> targets = new ArrayList<String>();
        HashSet<String> distinctTargets = new HashSet<String>();
        if (context.contains(INSTANCE)) {
            String value = context.get(INSTANCE);
            if (value == null || value.length() == 0) {
                context.error("Targets not provided. Available targets: ");
                Targets.listOptions(context);
                return false;
            }
            String[] stringArray = value.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String t = stringArray[i];
                if (!distinctTargets.add(t.toLowerCase())) continue;
                targets.add(t);
            }
        }
        for (Option o : Option.values()) {
            String lc = o.value.toLowerCase();
            if (!context.contains(o.value) || distinctTargets.contains(lc)) continue;
            targets.add(o.value);
            distinctTargets.add(lc);
        }
        if (targets.size() == 0) {
            if (context.contains(INSTANCE)) {
                context.error("Targets not provided. Available targets: ");
                Targets.listOptions(context);
                return false;
            }
            return true;
        }
        ArrayList<Option> options = new ArrayList<Option>(targets.size());
        for (String name : targets) {
            Option o = Option.from(name);
            if (o == null) {
                context.error("Unknown target: " + name);
                Targets.listOptions(context);
                return false;
            }
            options.add(o);
        }
        Map<String, String> dsls = DslPath.getCurrentDsl(context);
        if (dsls.size() == 0) {
            context.error("Can't compile DSL to targets since no DSL was provided.");
            context.error("Please check your DSL folder: " + context.get(DslPath.INSTANCE));
            return false;
        }
        if (!Settings.hasSourceOnly(context)) {
            for (Option o : options) {
                if (o.action.check(context)) continue;
                return false;
            }
        }
        context.cache(CACHE_NAME, options);
        return true;
    }

    @Override
    public void run(Context context) throws ExitException {
        List targets = (List)context.load(CACHE_NAME);
        if (targets == null) {
            return;
        }
        this.compile(context, targets);
    }

    public static String getTargetSourcePath(Context context, boolean sourceOnly, Option target) throws ExitException {
        String custom;
        String sourceOutput = context.get("source:" + target.value);
        String string = sourceOutput != null ? sourceOutput : (custom = sourceOnly ? context.get(target.value) : null);
        if (custom != null && !custom.isEmpty()) {
            File file = new File(custom, target.name());
            try {
                if (file.exists()) {
                    Utils.deletePath(file);
                }
                return custom;
            }
            catch (IOException e) {
                context.error("Unable to clean target source folder: " + file.getAbsolutePath());
                context.error(e);
                throw new ExitException();
            }
        }
        return TempPath.getTempProjectPath(context).getAbsolutePath();
    }

    private void compile(Context context, List<Option> targets) throws ExitException {
        List<File> dsls = DslPath.getDslPaths(context);
        List<String> settings = Settings.get(context);
        boolean sourceOnly = Settings.hasSourceOnly(context);
        for (Option t : targets) {
            String temp = Targets.getTargetSourcePath(context, sourceOnly, t);
            Map<String, String> files = DslCompiler.compile(context, t.value, settings, context.get(Namespace.INSTANCE), context.get(Version.INSTANCE), dsls, context.get("library:" + t.value), context.get("configuration:" + t.value));
            try {
                boolean hasFileWithExtension = false;
                for (String string : files.keySet()) {
                    if (!string.endsWith(t.extension)) continue;
                    hasFileWithExtension = true;
                    break;
                }
                for (Map.Entry entry : files.entrySet()) {
                    String fullName = t.name() + "/" + (String)entry.getKey() + (hasFileWithExtension ? "" : t.extension);
                    Targets.saveFile(context, temp, t.convertToPath, fullName, (String)entry.getValue());
                }
            }
            catch (IOException e) {
                context.error("Can't create temporary target file. Compilation results can't be saved locally.");
                context.error(e);
                throw new ExitException();
            }
            context.notify("TARGET", t);
            if (sourceOnly || t.action == null) continue;
            t.action.build(new File(temp, t.name()), context);
        }
    }

    private static void setupFolder(Context context, File path, int retry) throws ExitException {
        if (path.exists()) {
            return;
        }
        if (path.mkdirs()) {
            return;
        }
        if (retry <= 0) {
            context.error("Failed creating path for target file: " + path.getAbsolutePath());
            throw new ExitException();
        }
        try {
            context.warning("Failed creating path for target file: " + path.getAbsolutePath() + ". Retrying...");
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            throw new ExitException();
        }
        Targets.setupFolder(context, path, retry - 1);
    }

    private static void saveFile(Context context, String temp, boolean escapeName, String name, String content) throws ExitException, IOException {
        String cleanName = name.replace(':', '_').replace('<', '_').replace('>', '_');
        String nameOnly = cleanName.contains("\\") ? cleanName.substring(0, cleanName.lastIndexOf(92)) : (cleanName.contains(".") ? cleanName.substring(0, cleanName.lastIndexOf(46)) : cleanName);
        File file = escapeName ? new File(temp, nameOnly.replace('.', '/').replace('\\', '/') + cleanName.substring(nameOnly.length())) : new File(temp, cleanName);
        File parentPath = file.getParentFile();
        Targets.setupFolder(context, parentPath, 2);
        if (!file.createNewFile()) {
            context.error("Failed creating target file: " + file.getAbsolutePath());
            throw new ExitException();
        }
        Utils.saveFile(context, file, content);
    }

    @Override
    public String getShortDescription() {
        return "Convert DSL to specified target (Java client, PHP, Revenj server, ...)";
    }

    @Override
    public String getDetailedDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("DSL Platform converts DSL model to various target sources which are then locally compiled (if possible).\n\n");
        sb.append("Custom output name can be specified with as -java_client=/home/model.jar,revenj=/home/revenj.dll\n\n");
        sb.append("Custom dependency path can be specified as -dependencies:java_client=/home/java_libs\n\n");
        sb.append("Library version can be passed to DSL Compiler with as -library:revenj.net=1.4.1\n\n");
        sb.append("Custom source folder can be specified as -source:java_client=/tmp/java_src\n\n");
        sb.append("This option specifies which target sources are available.\n");
        sb.append("---------------------------------------------------------\n");
        for (Option o : Option.values()) {
            sb.append(o.value).append(" - ").append(o.description).append("\n");
        }
        return sb.toString();
    }

    static /* synthetic */ String[] access$000() {
        return DOTNET_CLIENT_DEPENDENCIES;
    }

    static /* synthetic */ String[] access$100() {
        return DOTNET_WPF_DEPENDENCIES;
    }

    static {
        DOTNET_CLIENT_DEPENDENCIES = new String[]{"System.dll", "System.Core.dll", "System.Dynamic.dll", "System.ComponentModel.Composition.dll", "System.Configuration.dll", "System.Data.dll", "System.Drawing.dll", "System.Xml.dll", "System.Xml.Linq.dll", "System.Runtime.Serialization.dll"};
        DOTNET_WPF_DEPENDENCIES = new String[]{"System.dll", "System.Core.dll", "System.Dynamic.dll", "System.ComponentModel.Composition.dll", "System.Configuration.dll", "System.Data.dll", "System.Drawing.dll", "System.Xml.dll", "System.Xml.Linq.dll", "System.Runtime.Serialization.dll", "Microsoft.CSharp.dll", "System.Xaml.dll", "gac/PresentationFramework", "gac/WindowsBase", "gac/PresentationCore"};
    }

    public static enum Option {
        REVENJ_JAVA("revenj.java", "Revenj.Java server for Postgres", ".java", new CompileRevenjJava("revenj.java", "revenj-java", "revenj-servlet", "revenj-storage"), true),
        REVENJ_JAVA_POSTGRES("java_server_postgres", "Revenj.Java server for Postgres", ".java", new CompileRevenjJava("java_server_postgres", "revenj-java", "revenj-servlet", "revenj-storage"), true),
        REVENJ_SPRING("revenj.spring", "Revenj.Java server for Spring with Postgres", ".java", new CompileRevenjJava("revenj.spring", "revenj-spring", "revenj-spring", "revenj-storage"), true),
        JAVA_CLIENT("java_client", "Java client", ".java", new CompileJavaClient("Java client", "java-client", "java_client", "com/dslplatform", "dsl-client-java", "./generated-client-java.jar"), true),
        JAVA_POJO("java_pojo", "Plain Old Java Object", ".java", new CompileJavaClient("Java POJO", "java-pojo", "java_pojo", null, null, "./generated-model-java.jar"), true),
        JAVA_EXTERNAL_JSON("java_external_json", "Java JSON serializers for an existing POJO", ".java", new CompileJavaClient("Java JSON", "java-pojo", "java_external_json", null, null, "./generated-json-java.jar"), true),
        ANDORID("android", "Android", ".java", new CompileJavaClient("Android", "android", "android", "com/dslplatform", "dsl-client-java", "./generated-model-android.jar"), true),
        ANDORID_EXTERNAL_JSON("android_external_json", "Android JSON serializers for an existing POJO", ".java", new CompileJavaClient("Android JSON", "android", "android_external_json", null, null, "./generated-json-android.jar"), true),
        REVENJ_NET("revenj.net", "Revenj.NET server for Postgres", ".cs", new CompileRevenjNet("revenj.net", null), false),
        REVENJ_NET_POSTGRES("dotnet_server_postgres", "Revenj.NET server for Postgres", ".cs", new CompileRevenjNet("dotnet_server_postgres", null), false),
        REVENJ_NET_ORACLE_32("dotnet_server_oracle_32", "Revenj.NET server for Oracle with 32bit client driver", ".cs", new CompileRevenjNet("dotnet_server_oracle_32", "oracle-driver-32bit"), false),
        REVENJ_NET_ORACLE_64("dotnet_server_oracle_64", "Revenj.NET server for Oracle with 64bit client driver", ".cs", new CompileRevenjNet("dotnet_server_oracle_64", "oracle-driver-64bit"), false),
        DOTNET_POCO("dotnet_poco", "Plain Old C# Object", ".cs", new CompileCsClient(".NET POCO", null, "dotnet_poco", "./GeneratedModel.dll", Targets.access$000(), false), false),
        DOTNET_CLIENT("dotnet_client", ".NET client", ".cs", new CompileCsClient(".NET client", "client", "dotnet_client", "./ClientModel.dll", Targets.access$000(), false), false),
        DOTNET_PORTABLE("dotnet_portable", ".NET portable", ".cs", new CompileCsClient(".NET portable", "portable", "dotnet_portable", "./PortableModel.dll", new String[0], false), false),
        DOTNET_WPF("wpf", ".NET WPF GUI", ".cs", new CompileCsClient(".NET WPF GUI", "wpf", "wpf", "./WpfModel.dll", Targets.access$100(), true), false),
        PHP("php_client", "PHP client", ".php", new PrepareSources("PHP", "php_client", "Generated-PHP"), true),
        PHP_UI("php_ui", "PHP UI client", ".php", new PreparePhpUI("PHP UI", "php_ui", "Generated-PHP-UI"), true),
        KNOCKOUT("knockout", "Knockout", ".js", new PrepareSources("knockout", "knockout", "Generated-Knockout"), true),
        TYPESCRIPT("typescript", "Typescript", ".ts", new PrepareSources("typescript", "typescript", "Generated-Typescript"), false),
        REACT("react", "React", ".ts", new PrepareSources("react", "react", "Generated-React"), false),
        SCALA_CLIENT("scala_client", "Scala client", ".scala", new CompileScalaClient("Scala client", "scala-client", "scala_client", "dsl-client-scala_2.11", "./generated-model-scala-client.jar"), true),
        SCALA_POSO("scala_poso", "Plain Old Scala Object", ".scala", new CompileScalaClient("Scala", "scala-poso", "scala_client", null, "./generated-model-scala.jar"), true),
        REVENJ_SCALA("revenj.scala", "Revenj.Scala server for Postgres", ".scala", new CompileRevenjScala("revenj.scala", "revenj-scala", "revenj-core_2.11"), true),
        REVENJ_SCALA_POSTGRES("scala_server_postgres", "Revenj.Scala server for Postgres", ".scala", new CompileRevenjScala("scala_server_postgres", "revenj-scala", "revenj-core_2.11"), true),
        SCALA_SERVER_ORACLE("scala_server_oracle", "Scala server (Oracle)", ".scala", new CompileScalaClient("Scala server (Oracle)", "scala-poso", "scala_server_oracle", null, "./generated-scala-oracle.jar"), true),
        HTML_DOCUMENTATION("html_docs", "HTML documentation", ".html", new PrepareSources("HTML Documentation", "html_docs", "generated-html-documentation"), false);

        private final String value;
        private final String description;
        private final String extension;
        private final BuildAction action;
        private final boolean convertToPath;

        private Option(String value, String description, String extension, BuildAction action, boolean convertToPath) {
            this.value = value;
            this.description = description;
            this.extension = extension;
            this.action = action;
            this.convertToPath = convertToPath;
        }

        private static Option from(String value) {
            for (Option o : Option.values()) {
                if (!o.value.equalsIgnoreCase(value)) continue;
                return o;
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

