/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters.build;

import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.Either;
import com.dslplatform.compiler.client.ExitException;
import com.dslplatform.compiler.client.Utils;
import com.dslplatform.compiler.client.parameters.Dependencies;
import com.dslplatform.compiler.client.parameters.Download;
import com.dslplatform.compiler.client.parameters.Nuget;
import com.dslplatform.compiler.client.parameters.build.BuildAction;
import com.dslplatform.compiler.client.parameters.build.DotNetCompilation;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;

public class CompileCsClient
implements BuildAction {
    private final String name;
    private final String zip;
    private final String library;
    private final String dll;
    private final String[] dependencies;
    private final boolean force32Bit;

    public CompileCsClient(String name, String zip, String library, String dll, String[] dependencies, boolean force32Bit) {
        this.name = name;
        this.zip = zip;
        this.library = library;
        this.dll = dll;
        this.dependencies = dependencies;
        this.force32Bit = force32Bit;
    }

    @Override
    public boolean check(Context context) throws ExitException {
        Map<String, String> nugets = Nuget.getNugets(context);
        if (this.force32Bit && !Utils.isWindows()) {
            context.error(this.name + " is only currently available on Windows.");
            throw new ExitException();
        }
        if (nugets != null) {
            return true;
        }
        for (int i = 0; i < this.dependencies.length; ++i) {
            if (!this.dependencies[i].startsWith("gac/")) continue;
            String name = this.dependencies[i].substring(4);
            File assemblyPath = new File(new File(new File(System.getenv("WINDIR")), "Microsoft.NET"), "assembly");
            File gac32 = new File(assemblyPath, "GAC_32");
            File gacMsil = new File(assemblyPath, "GAC_MSIL");
            File dp32 = new File(gac32, name);
            File dpMsil = new File(gacMsil, name);
            File dp = dp32.exists() ? dp32 : dpMsil;
            String[] versions = dp.list();
            if (versions == null || versions.length == 0) {
                context.error("Unable to find " + name + " in GAC. Looking in: " + dp);
                throw new ExitException();
            }
            File actualFile = new File(new File(dp, versions[0]), name + ".dll");
            if (!actualFile.exists()) {
                context.error("Unable to find " + name + " in GAC. Looking in: " + actualFile);
                throw new ExitException();
            }
            this.dependencies[i] = actualFile.getAbsolutePath();
        }
        File libDeps = Dependencies.getDependencies(context, this.name, this.library, this.zip, true);
        File[] found = libDeps.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".dll");
            }
        });
        if (this.zip != null && (found == null || found.length == 0)) {
            context.warning(this.name + " dependencies not found in: " + libDeps.getAbsolutePath());
            if (!context.contains(Download.INSTANCE)) {
                if (!context.canInteract()) {
                    context.error("Download option not enabled. Enable download option, change dependencies path or place " + this.name + " files in specified folder.");
                    throw new ExitException();
                }
                String answer = context.ask("Do you wish to download latest " + this.name + " version from the Internet (y/N):");
                if (!"y".equalsIgnoreCase(answer)) {
                    throw new ExitException();
                }
            }
            return Download.downloadZip(libDeps, context, this.name, this.zip);
        }
        return true;
    }

    @Override
    public void build(File sources, Context context) throws ExitException {
        Either<String> compilation;
        Map<String, String> nugets = Nuget.getNugets(context);
        File libDeps = Dependencies.getDependenciesIf(context, this.name, this.library, nugets == null);
        String customDll = context.get(this.library);
        File model = new File(customDll != null ? customDll : this.dll);
        context.show("Compiling " + this.name + " library...");
        Either<String> either = compilation = nugets == null ? DotNetCompilation.compileLegacy(this.dependencies, libDeps, sources, model, context, this.force32Bit) : DotNetCompilation.compileNewDotnet(nugets, libDeps, sources, model, context);
        if (!compilation.isSuccess()) {
            context.error("Error during " + this.name + " library compilation.");
            context.error(compilation.whyNot());
            throw new ExitException();
        }
        if (!model.exists()) {
            context.error("Can't seem to find compiled " + this.name + " library: " + model.getAbsolutePath());
            context.log(compilation.get());
            throw new ExitException();
        }
        context.show("Compiled " + this.name + " library to: " + model.getAbsolutePath());
    }
}

