/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters.build;

import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.Either;
import com.dslplatform.compiler.client.ExitException;
import com.dslplatform.compiler.client.Utils;
import com.dslplatform.compiler.client.parameters.Dependencies;
import com.dslplatform.compiler.client.parameters.Download;
import com.dslplatform.compiler.client.parameters.Force;
import com.dslplatform.compiler.client.parameters.Nuget;
import com.dslplatform.compiler.client.parameters.build.BuildAction;
import com.dslplatform.compiler.client.parameters.build.DotNetCompilation;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class CompileRevenjNet
implements BuildAction {
    private final String id;
    private final String additionalZip;
    private static final String[] DEPENDENCIES = new String[]{"System.dll", "System.Core.dll", "System.Dynamic.dll", "System.ComponentModel.Composition.dll", "System.Configuration.dll", "System.Data.dll", "System.Drawing.dll", "System.Xml.dll", "System.Xml.Linq.dll", "System.Runtime.Serialization.dll"};

    public CompileRevenjNet(String id, String additionalZip) {
        this.id = id;
        this.additionalZip = additionalZip;
    }

    @Override
    public boolean check(Context context) throws ExitException {
        Map<String, String> nugets = Nuget.getNugets(context);
        if (nugets == null) {
            File revenjDeps = Dependencies.getDependencies(context, "Revenj.NET", this.id, "dotnet-core", true);
            File[] found = revenjDeps.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".dll");
                }
            });
            if (found == null || found.length == 0) {
                context.error("Revenj.NET dependencies not found in: " + revenjDeps.getAbsolutePath());
                return CompileRevenjNet.downloadFromGithub(context, "Revenj.NET", "revenj-core", this.additionalZip, revenjDeps);
            }
        } else if (!nugets.containsKey("revenj")) {
            if (context.contains(Force.INSTANCE)) {
                context.warning("No revenj dependency found in nuget. Compilation will most likely fail. Continuing due to force option");
            } else {
                context.error("No revenj dependency found in nuget. Unable to compile Revenj without revenj dependency. To force continue compilation regardless, specify force parameter");
                return false;
            }
        }
        return true;
    }

    @Override
    public void build(File sources, Context context) throws ExitException {
        Either<String> compilation;
        Map<String, String> nugets = Nuget.getNugets(context);
        File revenjDeps = Dependencies.getDependenciesIf(context, "Revenj.NET", this.id, nugets == null);
        String customDll = context.get(this.id);
        File model = new File(customDll != null ? customDll : "./GeneratedModel.dll");
        context.show("Compiling Revenj.NET library...");
        Either<String> either = compilation = nugets == null ? DotNetCompilation.compileLegacy(DEPENDENCIES, revenjDeps, sources, model, context, false) : DotNetCompilation.compileNewDotnet(nugets, revenjDeps, sources, model, context);
        if (!compilation.isSuccess()) {
            context.error("Error during Revenj.NET library compilation.");
            context.error(compilation.whyNot());
            throw new ExitException();
        }
        if (!model.exists()) {
            context.error("Can't seem to find compiled Revenj.NET library: " + model.getAbsolutePath());
            context.log(compilation.get());
            throw new ExitException();
        }
        context.show("Compiled Revenj.NET library to: " + model.getAbsolutePath());
    }

    private static boolean downloadFromGithub(Context context, String name, String zip, String additionalZip, File target) throws ExitException {
        if (!context.contains(Download.INSTANCE)) {
            if (!context.canInteract()) {
                context.error("Download option not enabled.\nEnable download option, change dependencies path or place " + name + " files in specified folder: " + target.getAbsolutePath());
                throw new ExitException();
            }
            String answer = context.ask("Do you wish to download latest " + name + " version from the Internet (y/N):");
            if (!"y".equalsIgnoreCase(answer)) {
                throw new ExitException();
            }
        }
        try {
            String tag;
            context.show("Downloading " + name + " from GitHub...");
            URL latest = new URL("https://github.com/ngs-doo/revenj/releases/latest");
            HttpsURLConnection conn = (HttpsURLConnection)latest.openConnection();
            conn.setInstanceFollowRedirects(false);
            conn.setUseCaches(false);
            conn.connect();
            if (conn.getResponseCode() != 302) {
                context.warning("Error downloading " + name + " from GitHub. Will continue with tag 1.5.0. Expecting redirect. Got: " + conn.getResponseCode());
                tag = "1.5.0";
            } else {
                String redirect = conn.getHeaderField("Location");
                tag = redirect.substring(redirect.lastIndexOf(47) + 1);
            }
            URL coreUrl = new URL("https://github.com/ngs-doo/revenj/releases/download/" + tag + "/" + zip + ".zip");
            Utils.unpackZip(context, target, coreUrl);
            if (additionalZip != null) {
                URL zipUrl = new URL("https://github.com/ngs-doo/revenj/releases/download/" + tag + "/" + additionalZip + ".zip");
                Utils.unpackZip(context, target, zipUrl);
            }
        }
        catch (IOException ex) {
            context.error("Unable to download " + name + " from GitHub.");
            context.error(ex);
            return false;
        }
        return true;
    }
}

