/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters.build;

import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.Either;
import com.dslplatform.compiler.client.ExitException;
import com.dslplatform.compiler.client.parameters.Dependencies;
import com.dslplatform.compiler.client.parameters.Download;
import com.dslplatform.compiler.client.parameters.build.BuildAction;
import com.dslplatform.compiler.client.parameters.build.ScalaCompilation;
import java.io.File;

public class CompileScalaClient
implements BuildAction {
    private final String name;
    private final String zip;
    private final String library;
    private final String maven;
    private final String jar;

    public CompileScalaClient(String name, String zip, String library, String maven, String jar) {
        this.name = name;
        this.zip = zip;
        this.library = library;
        this.maven = maven;
        this.jar = jar;
    }

    @Override
    public boolean check(Context context) throws ExitException {
        return Download.checkJars(context, this.name, this.zip, this.library, "com/dslplatform", this.maven);
    }

    @Override
    public void build(File sources, Context context) throws ExitException {
        String customJar;
        File model;
        File libDeps = Dependencies.getDependencies(context, this.name, this.library);
        Either<String> compilation = ScalaCompilation.compile(this.library, libDeps, sources, model = new File((customJar = context.get(this.library)) != null ? customJar : this.jar), null, context);
        if (!compilation.isSuccess()) {
            context.error("Error during " + this.name + " library compilation.");
            context.error(compilation.whyNot());
            throw new ExitException();
        }
        if (!model.exists()) {
            context.error("Can't seem to find compiled " + this.name + " library: " + model.getAbsolutePath());
            context.log(compilation.get());
            throw new ExitException();
        }
        context.show("Compiled " + this.name + " library to: " + model.getAbsolutePath());
    }
}

