/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.compiler.client.parameters.build;

import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.Either;
import com.dslplatform.compiler.client.ExitException;
import com.dslplatform.compiler.client.Utils;
import com.dslplatform.compiler.client.parameters.build.BuildAction;
import java.io.File;
import java.io.IOException;

public class PrepareSources
implements BuildAction {
    private final String targetName;
    private final String targetId;
    private final String targetFolder;

    public PrepareSources(String targetName, String targetId, String targetFolder) {
        this.targetName = targetName;
        this.targetId = targetId;
        this.targetFolder = targetFolder;
    }

    @Override
    public boolean check(Context context) throws ExitException {
        String customFolder = context.get(this.targetId);
        File target = new File(customFolder != null ? customFolder : this.targetFolder);
        if (target.exists() && target.isDirectory()) {
            try {
                Utils.deletePath(target);
            }
            catch (IOException ex) {
                context.error("Failed to clean " + this.targetName + " target folder: " + target.getAbsolutePath());
                context.error(ex);
                throw new ExitException();
            }
        } else {
            if (target.exists() && !target.isDirectory()) {
                context.error("Expecting to find folder. Found file at: " + target.getAbsolutePath());
                throw new ExitException();
            }
            if (!target.mkdirs()) {
                context.error("Failed to create " + this.targetName + " target folder: " + target.getAbsolutePath());
                throw new ExitException();
            }
        }
        context.cache(this.targetId, target);
        return true;
    }

    private void copyFolder(File sources, File target, Context context) throws ExitException {
        String[] children = sources.list();
        if (children == null) {
            return;
        }
        for (String fn : children) {
            File sf = new File(sources, fn);
            File tf = new File(target, fn);
            if (sf.isDirectory()) {
                if (!tf.mkdirs()) {
                    context.error("Failed to create target " + this.targetName + " folder: " + tf.getAbsolutePath());
                    throw new ExitException();
                }
                this.copyFolder(sf, tf, context);
                continue;
            }
            Either<String> content = Utils.readFile(sf);
            if (!content.isSuccess()) {
                context.error("Error reading source " + this.targetName + " file: " + sf.getAbsolutePath());
                throw new ExitException();
            }
            try {
                Utils.saveFile(context, tf, content.get());
            }
            catch (IOException ex) {
                context.error("Error writing target " + this.targetName + " file: " + tf.getAbsolutePath());
                throw new ExitException();
            }
        }
    }

    @Override
    public void build(File sources, Context context) throws ExitException {
        File target = (File)context.load(this.targetId);
        this.copyFolder(sources, target, context);
    }
}

