/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.junit;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.java.html.junit.AbstractTestRunner;
import net.java.html.junit.Bck2BrwsrTestRunner;
import net.java.html.junit.MultiNotifier;
import net.java.html.junit.PresenterTestRunner;
import net.java.html.junit.ScriptTestRunner;
import net.java.html.junit.SingleBrowserRunner;
import net.java.html.junit.UIListener;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;

public final class BrowserRunner
extends Suite {
    private final List<Runner> cases = new ArrayList<Runner>();
    private final List<AbstractTestRunner> runners = new ArrayList<AbstractTestRunner>();
    private static AbstractTestRunner[] contexts;

    public BrowserRunner(Class<?> klass) throws InitializationError {
        super(klass, Collections.emptyList());
        for (AbstractTestRunner info : BrowserRunner.create(klass)) {
            this.cases.add((Runner)new SingleBrowserRunner(info.name(), info, klass));
            this.runners.add(info);
        }
        Bck2BrwsrTestRunner.registerRunner(this.cases, klass);
        if (this.cases.isEmpty()) {
            throw new InitializationError("No presenter found. Add net.java.html.fx or script JAR on classpath!");
        }
    }

    protected List<Runner> getChildren() {
        return this.cases;
    }

    public void run(RunNotifier notifier) {
        try {
            MultiNotifier testNotifier = MultiNotifier.wrap(this.runners, notifier, this.getDescription());
            this.runNoWait(testNotifier);
            testNotifier.waitForAll();
        }
        catch (InterruptedException ex) {
            throw BrowserRunner.rethrow(RuntimeException.class, ex);
        }
    }

    private static <E extends Exception> E rethrow(Class<E> type, Exception ex) throws E {
        throw ex;
    }

    private void runNoWait(MultiNotifier testNotifier) {
        try {
            for (Runner each : this.getChildren()) {
                each.run((RunNotifier)testNotifier);
            }
        }
        catch (AssumptionViolatedException e) {
            testNotifier.addFailedAssumption(e);
        }
        catch (StoppedByUserException e) {
            throw e;
        }
        catch (Throwable e) {
            testNotifier.addFailure(e);
        }
    }

    public static void execute(String className) throws ClassNotFoundException, InterruptedException {
        Bck2BrwsrTestRunner.runAsJUnit(className);
    }

    private static AbstractTestRunner[] create(Class<?> klass) throws InitializationError {
        String url;
        if (contexts != null) {
            return contexts;
        }
        ArrayList<AbstractTestRunner> ctxs = new ArrayList<AbstractTestRunner>();
        try {
            boolean bck2brwsrRunner = Bck2BrwsrTestRunner.register(ctxs, klass);
            if (bck2brwsrRunner) {
                contexts = ctxs.toArray(new AbstractTestRunner[ctxs.size()]);
                return contexts;
            }
            url = UIListener.create().getPage().toURI().toASCIIString();
        }
        catch (IOException | URISyntaxException ex) {
            throw new InitializationError((Throwable)ex);
        }
        PresenterTestRunner.registerPresenters(ctxs, url, klass);
        ScriptTestRunner.register(ctxs, url, klass);
        contexts = ctxs.toArray(new AbstractTestRunner[ctxs.size()]);
        return contexts;
    }
}

