/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.junit;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.java.html.junit.AbstractTestRunner;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.MultipleFailureException;

final class MultiNotifier
extends RunNotifier {
    private final RunNotifier notifier;
    private final Description description;
    private final Set<Description> remaining;

    private MultiNotifier(RunNotifier notifier, Description description) {
        this.notifier = notifier;
        this.description = description;
        this.remaining = new HashSet<Description>();
        this.remaining.add(null);
    }

    MultiNotifier(RunListener listener, Description description) {
        RunNotifier run = new RunNotifier();
        run.addListener(listener);
        this.notifier = run;
        this.description = description;
        this.remaining = new HashSet<Description>();
        this.remaining.add(null);
    }

    static MultiNotifier wrap(List<AbstractTestRunner> runners, RunNotifier notifier, Description description) {
        if (notifier instanceof MultiNotifier) {
            MultiNotifier prev = (MultiNotifier)notifier;
            return prev;
        }
        for (AbstractTestRunner r : runners) {
            notifier.addListener(r.listener());
        }
        return new MultiNotifier(notifier, description);
    }

    public void addFailure(Throwable targetException) {
        if (targetException instanceof MultipleFailureException) {
            this.addMultipleFailureException((MultipleFailureException)targetException);
        } else {
            this.notifier.fireTestFailure(new Failure(this.description, targetException));
        }
    }

    private void addMultipleFailureException(MultipleFailureException mfe) {
        for (Throwable each : mfe.getFailures()) {
            this.addFailure(each);
        }
    }

    public void addFailedAssumption(AssumptionViolatedException e) {
        this.notifier.fireTestAssumptionFailed(new Failure(this.description, (Throwable)e));
        this.finishTest(this.description);
    }

    public void fireTestStarted(Description descr) {
        this.registerTest(descr);
        this.notifier.fireTestStarted(descr);
    }

    public void fireTestFinished(Description descr) {
        if (this.remaining.contains(descr)) {
            this.notifier.fireTestFinished(descr);
        }
        this.finishTest(descr);
    }

    public void fireTestIgnored(Description descr) {
        this.notifier.fireTestIgnored(descr);
        this.finishTest(descr);
    }

    public void fireTestAssumptionFailed(Failure failure) {
        this.notifier.fireTestAssumptionFailed(failure);
        this.finishTest(this.description);
    }

    public void fireTestFailure(Failure failure) {
        this.notifier.fireTestFailure(failure);
        this.finishTest(failure.getDescription());
    }

    public void fireTestRunFinished(Result result) {
        this.notifier.fireTestRunFinished(result);
    }

    public void fireTestRunStarted(Description description) {
        this.notifier.fireTestRunStarted(description);
        this.registerTest(description);
    }

    private synchronized void registerTest(Description descr) {
        this.remaining.add(descr);
    }

    synchronized void waitForAll() throws InterruptedException {
        while (!this.remaining.isEmpty()) {
            ((Object)((Object)this)).wait();
        }
    }

    private synchronized void finishTest(Description descr) {
        this.remaining.remove(null);
        this.remaining.remove(descr);
        if (this.remaining.isEmpty()) {
            ((Object)((Object)this)).notifyAll();
        }
    }
}

