
package org.glassfish.jersey.oauth1.signature.internal;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.oauth1.signature.internal.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableERROR_CANNOT_OBTAIN_PUBLIC_KEY() {
        return messageFactory.getMessage("error.cannot.obtain.public.key");
    }

    /**
     * Couldn''t obtain public key from consumer secret.
     * 
     */
    public static String ERROR_CANNOT_OBTAIN_PUBLIC_KEY() {
        return localizer.localize(localizableERROR_CANNOT_OBTAIN_PUBLIC_KEY());
    }

    public static Localizable localizableERROR_INVALID_CONSUMER_SECRET(Object arg0) {
        return messageFactory.getMessage("error.invalid.consumer.secret", arg0);
    }

    /**
     * Invalid consumer secret: {0}
     * 
     */
    public static String ERROR_INVALID_CONSUMER_SECRET(Object arg0) {
        return localizer.localize(localizableERROR_INVALID_CONSUMER_SECRET(arg0));
    }

    public static Localizable localizableERROR_BASE_64_INVALID_CHARACTER() {
        return messageFactory.getMessage("error.base64.invalid.character");
    }

    /**
     * Invalid character in Base64 string.
     * 
     */
    public static String ERROR_BASE_64_INVALID_CHARACTER() {
        return localizer.localize(localizableERROR_BASE_64_INVALID_CHARACTER());
    }

    public static Localizable localizableERROR_BASE_64_LENGTH() {
        return messageFactory.getMessage("error.base64.length");
    }

    /**
     * Base64 string length is not multiple of 4.
     * 
     */
    public static String ERROR_BASE_64_LENGTH() {
        return localizer.localize(localizableERROR_BASE_64_LENGTH());
    }

}
