/*
 * Decompiled with CFR 0.152.
 */
package com.edmunds.rest.databricks.DTO.clusters;

import com.edmunds.rest.databricks.DTO.clusters.AutoScaleDTO;
import com.edmunds.rest.databricks.DTO.clusters.AwsAttributesDTO;
import com.edmunds.rest.databricks.DTO.clusters.ClusterLogConfDTO;
import com.edmunds.rest.databricks.DTO.clusters.ClusterSourceDTO;
import com.edmunds.rest.databricks.DTO.clusters.ClusterStateDTO;
import com.edmunds.rest.databricks.DTO.clusters.InitScriptInfoDTO;
import com.edmunds.rest.databricks.DTO.clusters.LogSyncStatusDTO;
import com.edmunds.rest.databricks.DTO.clusters.SparkNodeDTO;
import com.edmunds.rest.databricks.DTO.clusters.TerminationReasonDTO;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

public class ClusterInfoDTO
implements Serializable {
    @JsonProperty(value="num_workers")
    private int numWorkers;
    @JsonProperty(value="autoscale")
    private AutoScaleDTO autoscale;
    @JsonProperty(value="cluster_id")
    private String clusterId;
    @JsonProperty(value="creator_user_name")
    private String creatorUserName;
    @JsonProperty(value="driver")
    private SparkNodeDTO driver;
    @JsonProperty(value="executors")
    private SparkNodeDTO[] executors;
    @JsonProperty(value="spark_context_id")
    private long sparkContextId;
    @JsonProperty(value="jdbc_port")
    private int jdbcPort;
    @JsonProperty(value="cluster_name")
    private String clusterName;
    @JsonProperty(value="spark_version")
    private String sparkVersion;
    @JsonProperty(value="spark_conf")
    private Map<String, String> sparkConf;
    @JsonProperty(value="aws_attributes")
    private AwsAttributesDTO awsAttributes;
    @JsonProperty(value="node_type_id")
    private String nodeTypeId;
    @JsonProperty(value="driver_node_type_id")
    private String driverNodeTypeId;
    @JsonProperty(value="ssh_public_keys")
    private String[] sshPublicKeys;
    @JsonProperty(value="custom_tags")
    private Map<String, String> customTags;
    @JsonProperty(value="cluster_log_conf")
    private ClusterLogConfDTO clusterLogConf;
    @JsonProperty(value="init_scripts")
    private InitScriptInfoDTO[] initScripts;
    @JsonProperty(value="spark_env_vars")
    private Map<String, String> sparkEnvVars;
    @JsonProperty(value="autotermination_minutes")
    private int autoTerminationMinutes;
    @JsonProperty(value="enable_elastic_disk")
    private boolean enableElasticDisk;
    @JsonProperty(value="instance_pool_id")
    private String instancePoolId;
    @JsonProperty(value="cluster_source")
    private ClusterSourceDTO clusterSource;
    @JsonProperty(value="state")
    private ClusterStateDTO state;
    @JsonProperty(value="state_message")
    private String stateMessage;
    @JsonProperty(value="start_time")
    private long startTime;
    @JsonProperty(value="terminated_time")
    private long terminatedTime;
    @JsonProperty(value="last_state_loss_time")
    private long lastStateLossTime;
    @JsonProperty(value="last_activity_time")
    private long lastActivityTime;
    @JsonProperty(value="cluster_memory_mb")
    private long clusterMemoryMb;
    @JsonProperty(value="cluster_cores")
    private float clusterCores;
    @JsonProperty(value="default_tags")
    private Map<String, String> defaultTags;
    @JsonProperty(value="cluster_log_status")
    private LogSyncStatusDTO clusterLogStatus;
    @JsonProperty(value="termination_reason")
    private TerminationReasonDTO terminationReason;

    public int getNumWorkers() {
        return this.numWorkers;
    }

    public AutoScaleDTO getAutoscale() {
        return this.autoscale;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getCreatorUserName() {
        return this.creatorUserName;
    }

    public SparkNodeDTO getDriver() {
        return this.driver;
    }

    public SparkNodeDTO[] getExecutors() {
        return this.executors;
    }

    public long getSparkContextId() {
        return this.sparkContextId;
    }

    public int getJdbcPort() {
        return this.jdbcPort;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getSparkVersion() {
        return this.sparkVersion;
    }

    public Map<String, String> getSparkConf() {
        return this.sparkConf;
    }

    public AwsAttributesDTO getAwsAttributes() {
        return this.awsAttributes;
    }

    public String getNodeTypeId() {
        return this.nodeTypeId;
    }

    public String getDriverNodeTypeId() {
        return this.driverNodeTypeId;
    }

    public String[] getSshPublicKeys() {
        return this.sshPublicKeys;
    }

    public Map<String, String> getCustomTags() {
        return this.customTags;
    }

    public ClusterLogConfDTO getClusterLogConf() {
        return this.clusterLogConf;
    }

    public InitScriptInfoDTO[] getInitScripts() {
        return this.initScripts;
    }

    public Map<String, String> getSparkEnvVars() {
        return this.sparkEnvVars;
    }

    public int getAutoTerminationMinutes() {
        return this.autoTerminationMinutes;
    }

    public boolean isEnableElasticDisk() {
        return this.enableElasticDisk;
    }

    public String getInstancePoolId() {
        return this.instancePoolId;
    }

    public ClusterSourceDTO getClusterSource() {
        return this.clusterSource;
    }

    public ClusterStateDTO getState() {
        return this.state;
    }

    public String getStateMessage() {
        return this.stateMessage;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTerminatedTime() {
        return this.terminatedTime;
    }

    public long getLastStateLossTime() {
        return this.lastStateLossTime;
    }

    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    public long getClusterMemoryMb() {
        return this.clusterMemoryMb;
    }

    public float getClusterCores() {
        return this.clusterCores;
    }

    public Map<String, String> getDefaultTags() {
        return this.defaultTags;
    }

    public LogSyncStatusDTO getClusterLogStatus() {
        return this.clusterLogStatus;
    }

    public TerminationReasonDTO getTerminationReason() {
        return this.terminationReason;
    }

    @JsonProperty(value="num_workers")
    public void setNumWorkers(int numWorkers) {
        this.numWorkers = numWorkers;
    }

    @JsonProperty(value="autoscale")
    public void setAutoscale(AutoScaleDTO autoscale) {
        this.autoscale = autoscale;
    }

    @JsonProperty(value="cluster_id")
    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    @JsonProperty(value="creator_user_name")
    public void setCreatorUserName(String creatorUserName) {
        this.creatorUserName = creatorUserName;
    }

    @JsonProperty(value="driver")
    public void setDriver(SparkNodeDTO driver) {
        this.driver = driver;
    }

    @JsonProperty(value="executors")
    public void setExecutors(SparkNodeDTO[] executors) {
        this.executors = executors;
    }

    @JsonProperty(value="spark_context_id")
    public void setSparkContextId(long sparkContextId) {
        this.sparkContextId = sparkContextId;
    }

    @JsonProperty(value="jdbc_port")
    public void setJdbcPort(int jdbcPort) {
        this.jdbcPort = jdbcPort;
    }

    @JsonProperty(value="cluster_name")
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @JsonProperty(value="spark_version")
    public void setSparkVersion(String sparkVersion) {
        this.sparkVersion = sparkVersion;
    }

    @JsonProperty(value="spark_conf")
    public void setSparkConf(Map<String, String> sparkConf) {
        this.sparkConf = sparkConf;
    }

    @JsonProperty(value="aws_attributes")
    public void setAwsAttributes(AwsAttributesDTO awsAttributes) {
        this.awsAttributes = awsAttributes;
    }

    @JsonProperty(value="node_type_id")
    public void setNodeTypeId(String nodeTypeId) {
        this.nodeTypeId = nodeTypeId;
    }

    @JsonProperty(value="driver_node_type_id")
    public void setDriverNodeTypeId(String driverNodeTypeId) {
        this.driverNodeTypeId = driverNodeTypeId;
    }

    @JsonProperty(value="ssh_public_keys")
    public void setSshPublicKeys(String[] sshPublicKeys) {
        this.sshPublicKeys = sshPublicKeys;
    }

    @JsonProperty(value="custom_tags")
    public void setCustomTags(Map<String, String> customTags) {
        this.customTags = customTags;
    }

    @JsonProperty(value="cluster_log_conf")
    public void setClusterLogConf(ClusterLogConfDTO clusterLogConf) {
        this.clusterLogConf = clusterLogConf;
    }

    @JsonProperty(value="init_scripts")
    public void setInitScripts(InitScriptInfoDTO[] initScripts) {
        this.initScripts = initScripts;
    }

    @JsonProperty(value="spark_env_vars")
    public void setSparkEnvVars(Map<String, String> sparkEnvVars) {
        this.sparkEnvVars = sparkEnvVars;
    }

    @JsonProperty(value="autotermination_minutes")
    public void setAutoTerminationMinutes(int autoTerminationMinutes) {
        this.autoTerminationMinutes = autoTerminationMinutes;
    }

    @JsonProperty(value="enable_elastic_disk")
    public void setEnableElasticDisk(boolean enableElasticDisk) {
        this.enableElasticDisk = enableElasticDisk;
    }

    @JsonProperty(value="instance_pool_id")
    public void setInstancePoolId(String instancePoolId) {
        this.instancePoolId = instancePoolId;
    }

    @JsonProperty(value="cluster_source")
    public void setClusterSource(ClusterSourceDTO clusterSource) {
        this.clusterSource = clusterSource;
    }

    @JsonProperty(value="state")
    public void setState(ClusterStateDTO state) {
        this.state = state;
    }

    @JsonProperty(value="state_message")
    public void setStateMessage(String stateMessage) {
        this.stateMessage = stateMessage;
    }

    @JsonProperty(value="start_time")
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @JsonProperty(value="terminated_time")
    public void setTerminatedTime(long terminatedTime) {
        this.terminatedTime = terminatedTime;
    }

    @JsonProperty(value="last_state_loss_time")
    public void setLastStateLossTime(long lastStateLossTime) {
        this.lastStateLossTime = lastStateLossTime;
    }

    @JsonProperty(value="last_activity_time")
    public void setLastActivityTime(long lastActivityTime) {
        this.lastActivityTime = lastActivityTime;
    }

    @JsonProperty(value="cluster_memory_mb")
    public void setClusterMemoryMb(long clusterMemoryMb) {
        this.clusterMemoryMb = clusterMemoryMb;
    }

    @JsonProperty(value="cluster_cores")
    public void setClusterCores(float clusterCores) {
        this.clusterCores = clusterCores;
    }

    @JsonProperty(value="default_tags")
    public void setDefaultTags(Map<String, String> defaultTags) {
        this.defaultTags = defaultTags;
    }

    @JsonProperty(value="cluster_log_status")
    public void setClusterLogStatus(LogSyncStatusDTO clusterLogStatus) {
        this.clusterLogStatus = clusterLogStatus;
    }

    @JsonProperty(value="termination_reason")
    public void setTerminationReason(TerminationReasonDTO terminationReason) {
        this.terminationReason = terminationReason;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterInfoDTO)) {
            return false;
        }
        ClusterInfoDTO other = (ClusterInfoDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumWorkers() != other.getNumWorkers()) {
            return false;
        }
        AutoScaleDTO this$autoscale = this.getAutoscale();
        AutoScaleDTO other$autoscale = other.getAutoscale();
        if (this$autoscale == null ? other$autoscale != null : !((Object)this$autoscale).equals(other$autoscale)) {
            return false;
        }
        String this$clusterId = this.getClusterId();
        String other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
            return false;
        }
        String this$creatorUserName = this.getCreatorUserName();
        String other$creatorUserName = other.getCreatorUserName();
        if (this$creatorUserName == null ? other$creatorUserName != null : !this$creatorUserName.equals(other$creatorUserName)) {
            return false;
        }
        SparkNodeDTO this$driver = this.getDriver();
        SparkNodeDTO other$driver = other.getDriver();
        if (this$driver == null ? other$driver != null : !((Object)this$driver).equals(other$driver)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getExecutors(), other.getExecutors())) {
            return false;
        }
        if (this.getSparkContextId() != other.getSparkContextId()) {
            return false;
        }
        if (this.getJdbcPort() != other.getJdbcPort()) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$sparkVersion = this.getSparkVersion();
        String other$sparkVersion = other.getSparkVersion();
        if (this$sparkVersion == null ? other$sparkVersion != null : !this$sparkVersion.equals(other$sparkVersion)) {
            return false;
        }
        Map<String, String> this$sparkConf = this.getSparkConf();
        Map<String, String> other$sparkConf = other.getSparkConf();
        if (this$sparkConf == null ? other$sparkConf != null : !((Object)this$sparkConf).equals(other$sparkConf)) {
            return false;
        }
        AwsAttributesDTO this$awsAttributes = this.getAwsAttributes();
        AwsAttributesDTO other$awsAttributes = other.getAwsAttributes();
        if (this$awsAttributes == null ? other$awsAttributes != null : !((Object)this$awsAttributes).equals(other$awsAttributes)) {
            return false;
        }
        String this$nodeTypeId = this.getNodeTypeId();
        String other$nodeTypeId = other.getNodeTypeId();
        if (this$nodeTypeId == null ? other$nodeTypeId != null : !this$nodeTypeId.equals(other$nodeTypeId)) {
            return false;
        }
        String this$driverNodeTypeId = this.getDriverNodeTypeId();
        String other$driverNodeTypeId = other.getDriverNodeTypeId();
        if (this$driverNodeTypeId == null ? other$driverNodeTypeId != null : !this$driverNodeTypeId.equals(other$driverNodeTypeId)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSshPublicKeys(), other.getSshPublicKeys())) {
            return false;
        }
        Map<String, String> this$customTags = this.getCustomTags();
        Map<String, String> other$customTags = other.getCustomTags();
        if (this$customTags == null ? other$customTags != null : !((Object)this$customTags).equals(other$customTags)) {
            return false;
        }
        ClusterLogConfDTO this$clusterLogConf = this.getClusterLogConf();
        ClusterLogConfDTO other$clusterLogConf = other.getClusterLogConf();
        if (this$clusterLogConf == null ? other$clusterLogConf != null : !((Object)this$clusterLogConf).equals(other$clusterLogConf)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInitScripts(), other.getInitScripts())) {
            return false;
        }
        Map<String, String> this$sparkEnvVars = this.getSparkEnvVars();
        Map<String, String> other$sparkEnvVars = other.getSparkEnvVars();
        if (this$sparkEnvVars == null ? other$sparkEnvVars != null : !((Object)this$sparkEnvVars).equals(other$sparkEnvVars)) {
            return false;
        }
        if (this.getAutoTerminationMinutes() != other.getAutoTerminationMinutes()) {
            return false;
        }
        if (this.isEnableElasticDisk() != other.isEnableElasticDisk()) {
            return false;
        }
        String this$instancePoolId = this.getInstancePoolId();
        String other$instancePoolId = other.getInstancePoolId();
        if (this$instancePoolId == null ? other$instancePoolId != null : !this$instancePoolId.equals(other$instancePoolId)) {
            return false;
        }
        ClusterSourceDTO this$clusterSource = this.getClusterSource();
        ClusterSourceDTO other$clusterSource = other.getClusterSource();
        if (this$clusterSource == null ? other$clusterSource != null : !this$clusterSource.equals(other$clusterSource)) {
            return false;
        }
        ClusterStateDTO this$state = this.getState();
        ClusterStateDTO other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$stateMessage = this.getStateMessage();
        String other$stateMessage = other.getStateMessage();
        if (this$stateMessage == null ? other$stateMessage != null : !this$stateMessage.equals(other$stateMessage)) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getTerminatedTime() != other.getTerminatedTime()) {
            return false;
        }
        if (this.getLastStateLossTime() != other.getLastStateLossTime()) {
            return false;
        }
        if (this.getLastActivityTime() != other.getLastActivityTime()) {
            return false;
        }
        if (this.getClusterMemoryMb() != other.getClusterMemoryMb()) {
            return false;
        }
        if (Float.compare(this.getClusterCores(), other.getClusterCores()) != 0) {
            return false;
        }
        Map<String, String> this$defaultTags = this.getDefaultTags();
        Map<String, String> other$defaultTags = other.getDefaultTags();
        if (this$defaultTags == null ? other$defaultTags != null : !((Object)this$defaultTags).equals(other$defaultTags)) {
            return false;
        }
        LogSyncStatusDTO this$clusterLogStatus = this.getClusterLogStatus();
        LogSyncStatusDTO other$clusterLogStatus = other.getClusterLogStatus();
        if (this$clusterLogStatus == null ? other$clusterLogStatus != null : !((Object)this$clusterLogStatus).equals(other$clusterLogStatus)) {
            return false;
        }
        TerminationReasonDTO this$terminationReason = this.getTerminationReason();
        TerminationReasonDTO other$terminationReason = other.getTerminationReason();
        return !(this$terminationReason == null ? other$terminationReason != null : !((Object)this$terminationReason).equals(other$terminationReason));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClusterInfoDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumWorkers();
        AutoScaleDTO $autoscale = this.getAutoscale();
        result = result * 59 + ($autoscale == null ? 43 : ((Object)$autoscale).hashCode());
        String $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
        String $creatorUserName = this.getCreatorUserName();
        result = result * 59 + ($creatorUserName == null ? 43 : $creatorUserName.hashCode());
        SparkNodeDTO $driver = this.getDriver();
        result = result * 59 + ($driver == null ? 43 : ((Object)$driver).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getExecutors());
        long $sparkContextId = this.getSparkContextId();
        result = result * 59 + (int)($sparkContextId >>> 32 ^ $sparkContextId);
        result = result * 59 + this.getJdbcPort();
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $sparkVersion = this.getSparkVersion();
        result = result * 59 + ($sparkVersion == null ? 43 : $sparkVersion.hashCode());
        Map<String, String> $sparkConf = this.getSparkConf();
        result = result * 59 + ($sparkConf == null ? 43 : ((Object)$sparkConf).hashCode());
        AwsAttributesDTO $awsAttributes = this.getAwsAttributes();
        result = result * 59 + ($awsAttributes == null ? 43 : ((Object)$awsAttributes).hashCode());
        String $nodeTypeId = this.getNodeTypeId();
        result = result * 59 + ($nodeTypeId == null ? 43 : $nodeTypeId.hashCode());
        String $driverNodeTypeId = this.getDriverNodeTypeId();
        result = result * 59 + ($driverNodeTypeId == null ? 43 : $driverNodeTypeId.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSshPublicKeys());
        Map<String, String> $customTags = this.getCustomTags();
        result = result * 59 + ($customTags == null ? 43 : ((Object)$customTags).hashCode());
        ClusterLogConfDTO $clusterLogConf = this.getClusterLogConf();
        result = result * 59 + ($clusterLogConf == null ? 43 : ((Object)$clusterLogConf).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getInitScripts());
        Map<String, String> $sparkEnvVars = this.getSparkEnvVars();
        result = result * 59 + ($sparkEnvVars == null ? 43 : ((Object)$sparkEnvVars).hashCode());
        result = result * 59 + this.getAutoTerminationMinutes();
        result = result * 59 + (this.isEnableElasticDisk() ? 79 : 97);
        String $instancePoolId = this.getInstancePoolId();
        result = result * 59 + ($instancePoolId == null ? 43 : $instancePoolId.hashCode());
        ClusterSourceDTO $clusterSource = this.getClusterSource();
        result = result * 59 + ($clusterSource == null ? 43 : $clusterSource.hashCode());
        ClusterStateDTO $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $stateMessage = this.getStateMessage();
        result = result * 59 + ($stateMessage == null ? 43 : $stateMessage.hashCode());
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        long $terminatedTime = this.getTerminatedTime();
        result = result * 59 + (int)($terminatedTime >>> 32 ^ $terminatedTime);
        long $lastStateLossTime = this.getLastStateLossTime();
        result = result * 59 + (int)($lastStateLossTime >>> 32 ^ $lastStateLossTime);
        long $lastActivityTime = this.getLastActivityTime();
        result = result * 59 + (int)($lastActivityTime >>> 32 ^ $lastActivityTime);
        long $clusterMemoryMb = this.getClusterMemoryMb();
        result = result * 59 + (int)($clusterMemoryMb >>> 32 ^ $clusterMemoryMb);
        result = result * 59 + Float.floatToIntBits(this.getClusterCores());
        Map<String, String> $defaultTags = this.getDefaultTags();
        result = result * 59 + ($defaultTags == null ? 43 : ((Object)$defaultTags).hashCode());
        LogSyncStatusDTO $clusterLogStatus = this.getClusterLogStatus();
        result = result * 59 + ($clusterLogStatus == null ? 43 : ((Object)$clusterLogStatus).hashCode());
        TerminationReasonDTO $terminationReason = this.getTerminationReason();
        result = result * 59 + ($terminationReason == null ? 43 : ((Object)$terminationReason).hashCode());
        return result;
    }

    public String toString() {
        return "ClusterInfoDTO(numWorkers=" + this.getNumWorkers() + ", autoscale=" + this.getAutoscale() + ", clusterId=" + this.getClusterId() + ", creatorUserName=" + this.getCreatorUserName() + ", driver=" + this.getDriver() + ", executors=" + Arrays.deepToString(this.getExecutors()) + ", sparkContextId=" + this.getSparkContextId() + ", jdbcPort=" + this.getJdbcPort() + ", clusterName=" + this.getClusterName() + ", sparkVersion=" + this.getSparkVersion() + ", sparkConf=" + this.getSparkConf() + ", awsAttributes=" + this.getAwsAttributes() + ", nodeTypeId=" + this.getNodeTypeId() + ", driverNodeTypeId=" + this.getDriverNodeTypeId() + ", sshPublicKeys=" + Arrays.deepToString(this.getSshPublicKeys()) + ", customTags=" + this.getCustomTags() + ", clusterLogConf=" + this.getClusterLogConf() + ", initScripts=" + Arrays.deepToString(this.getInitScripts()) + ", sparkEnvVars=" + this.getSparkEnvVars() + ", autoTerminationMinutes=" + this.getAutoTerminationMinutes() + ", enableElasticDisk=" + this.isEnableElasticDisk() + ", instancePoolId=" + this.getInstancePoolId() + ", clusterSource=" + this.getClusterSource() + ", state=" + this.getState() + ", stateMessage=" + this.getStateMessage() + ", startTime=" + this.getStartTime() + ", terminatedTime=" + this.getTerminatedTime() + ", lastStateLossTime=" + this.getLastStateLossTime() + ", lastActivityTime=" + this.getLastActivityTime() + ", clusterMemoryMb=" + this.getClusterMemoryMb() + ", clusterCores=" + this.getClusterCores() + ", defaultTags=" + this.getDefaultTags() + ", clusterLogStatus=" + this.getClusterLogStatus() + ", terminationReason=" + this.getTerminationReason() + ")";
    }
}

