/*
 * Decompiled with CFR 0.152.
 */
package com.edmunds.rest.databricks;

import com.edmunds.rest.databricks.restclient.AbstractDatabricksRestClientImpl;
import com.edmunds.rest.databricks.restclient.DatabricksRestClient;
import com.edmunds.rest.databricks.restclient.DatabricksRestClientImpl;
import com.edmunds.rest.databricks.restclient.DatabricksRestClientImpl425;
import com.edmunds.rest.databricks.service.ClusterService;
import com.edmunds.rest.databricks.service.ClusterServiceImpl;
import com.edmunds.rest.databricks.service.DbfsService;
import com.edmunds.rest.databricks.service.DbfsServiceImpl;
import com.edmunds.rest.databricks.service.GroupsService;
import com.edmunds.rest.databricks.service.GroupsServiceImpl;
import com.edmunds.rest.databricks.service.InstanceProfilesService;
import com.edmunds.rest.databricks.service.InstanceProfilesServiceImpl;
import com.edmunds.rest.databricks.service.JobService;
import com.edmunds.rest.databricks.service.JobServiceImpl;
import com.edmunds.rest.databricks.service.LibraryService;
import com.edmunds.rest.databricks.service.LibraryServiceImpl;
import com.edmunds.rest.databricks.service.ScimService;
import com.edmunds.rest.databricks.service.ScimServiceImpl;
import com.edmunds.rest.databricks.service.WorkspaceService;
import com.edmunds.rest.databricks.service.WorkspaceServiceImpl;

public class DatabricksServiceFactory {
    public static final int SOCKET_TIMEOUT = 10000;
    public static final int CONNECTION_TIMEOUT = 10000;
    public static final int CONNECTION_REQUEST_TIMEOUT = 10000;
    public static final int DEFAULT_HTTP_CLIENT_MAX_RETRY = 3;
    public static final long DEFAULT_HTTP_CLIENT_RETRY_INTERVAL = 10000L;
    private DatabricksRestClient client2dot0;
    private ClusterService clusterService;
    private LibraryService libraryService;
    private WorkspaceService workspaceService;
    private JobService jobService;
    private DbfsService dbfsService;
    private GroupsService groupsService;
    private ScimService scimService;
    private InstanceProfilesService instanceProfilesService;

    public DatabricksServiceFactory(DatabricksRestClient databricksRestClient) {
        this.client2dot0 = databricksRestClient;
    }

    @Deprecated
    public DatabricksServiceFactory(String username, String password, String host) {
        this(username, password, host, 3, 10000L);
    }

    @Deprecated
    public DatabricksServiceFactory(String username, String password, String host, int maxRetry, long retryInterval) {
        this(username, password, host, maxRetry, retryInterval, false);
    }

    @Deprecated
    public DatabricksServiceFactory(String username, String password, String host, int maxRetry, long retryInterval, boolean useLegacyAPI425) {
        this.client2dot0 = Builder.createUserPasswordAuthentication((String)username, (String)password, (String)host).withMaxRetries((int)maxRetry).withRetryInterval((long)retryInterval).withUseLegacyAPI425((boolean)useLegacyAPI425).build().client2dot0;
    }

    @Deprecated
    public DatabricksServiceFactory(String personalToken, String host, int maxRetry, long retryInterval) {
        this.client2dot0 = Builder.createTokenAuthentication((String)personalToken, (String)host).withMaxRetries((int)maxRetry).withRetryInterval((long)retryInterval).build().client2dot0;
    }

    public ClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = new ClusterServiceImpl(this.client2dot0);
        }
        return this.clusterService;
    }

    public LibraryService getLibraryService() {
        if (this.libraryService == null) {
            this.libraryService = new LibraryServiceImpl(this.client2dot0);
        }
        return this.libraryService;
    }

    public JobService getJobService() {
        if (this.jobService == null) {
            this.jobService = new JobServiceImpl(this.client2dot0);
        }
        return this.jobService;
    }

    public WorkspaceService getWorkspaceService() {
        if (this.workspaceService == null) {
            this.workspaceService = new WorkspaceServiceImpl(this.client2dot0);
        }
        return this.workspaceService;
    }

    public DbfsService getDbfsService() {
        if (this.dbfsService == null) {
            this.dbfsService = new DbfsServiceImpl(this.client2dot0);
        }
        return this.dbfsService;
    }

    public GroupsService getGroupsService() {
        if (this.groupsService == null) {
            this.groupsService = new GroupsServiceImpl(this.client2dot0);
        }
        return this.groupsService;
    }

    public ScimService getScimService() {
        if (this.scimService == null) {
            this.scimService = new ScimServiceImpl(this.client2dot0);
        }
        return this.scimService;
    }

    public InstanceProfilesService getInstanceProfilesService() {
        if (this.instanceProfilesService == null) {
            this.instanceProfilesService = new InstanceProfilesServiceImpl(this.client2dot0);
        }
        return this.instanceProfilesService;
    }

    public static class Builder {
        public boolean useLegacyAPI425 = false;
        String host;
        String token;
        String username;
        String password;
        String userAgent;
        String apiVersion = "2.0";
        long retryInterval = 10000L;
        int maxRetries = 3;
        int soTimeout = 10000;
        int connectionTimeout = 10000;
        int connectionRequestTimeout = 10000;
        boolean requestSentRetryEnabled = false;

        private Builder() {
        }

        public static Builder createTokenAuthentication(String token, String host) {
            Builder builder = new Builder();
            builder.token = token;
            builder.host = host;
            return builder;
        }

        @Deprecated
        public static Builder createUserPasswordAuthentication(String username, String password, String host) {
            Builder builder = new Builder();
            builder.username = username;
            builder.password = password;
            builder.host = host;
            return builder;
        }

        public String getHost() {
            return this.host;
        }

        public String getToken() {
            return this.token;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public String getApiVersion() {
            return this.apiVersion;
        }

        public long getRetryInterval() {
            return this.retryInterval;
        }

        public int getMaxRetries() {
            return this.maxRetries;
        }

        public int getSoTimeout() {
            return this.soTimeout;
        }

        public int getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public int getConnectionRequestTimeout() {
            return this.connectionRequestTimeout;
        }

        public boolean isRequestSentRetryEnabled() {
            return this.requestSentRetryEnabled;
        }

        public boolean isUseLegacyAPI425() {
            return this.useLegacyAPI425;
        }

        public Builder withApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder withMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder withRetryInterval(long retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public Builder withSoTimeout(int soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        public Builder withConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder withConnectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public Builder withUseLegacyAPI425(boolean useLegacyAPI425) {
            this.useLegacyAPI425 = useLegacyAPI425;
            return this;
        }

        public Builder withRequestSentRetryEnabled(boolean requestSentRetryEnabled) {
            this.requestSentRetryEnabled = requestSentRetryEnabled;
            return this;
        }

        public Builder withUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public DatabricksServiceFactory build() {
            AbstractDatabricksRestClientImpl restClient = null;
            restClient = this.useLegacyAPI425 ? new DatabricksRestClientImpl425(this) : new DatabricksRestClientImpl(this);
            return new DatabricksServiceFactory(restClient);
        }
    }
}

