/*
 * Decompiled with CFR 0.152.
 */
package com.edmunds.rest.databricks;

import java.util.HashSet;
import java.util.Set;
import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;

public class HttpServiceUnavailableRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private static final Set<Integer> retryStatusSet = new HashSet<Integer>();
    private static Logger logger = Logger.getLogger((String)HttpServiceUnavailableRetryStrategy.class.getName());
    private long retryInterval;
    private int maxRetries;
    private int executeCount = 0;

    public HttpServiceUnavailableRetryStrategy() {
        this(3, 10000L);
    }

    public HttpServiceUnavailableRetryStrategy(int maxRetries, long retryInterval) {
        this.maxRetries = maxRetries;
        this.retryInterval = retryInterval;
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        boolean isRetry;
        this.executeCount = executionCount;
        boolean bl = isRetry = executionCount <= this.maxRetries && retryStatusSet.contains(response.getStatusLine().getStatusCode());
        if (isRetry) {
            logger.warn((Object)("Retry HttpRequest " + executionCount + "th. statusCode=" + response.getStatusLine().getStatusCode()));
        }
        return isRetry;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public int getExecuteCount() {
        return this.executeCount;
    }

    static {
        retryStatusSet.add(408);
        retryStatusSet.add(429);
        retryStatusSet.add(500);
        retryStatusSet.add(503);
        retryStatusSet.add(504);
    }
}

