/*
 * Decompiled with CFR 0.152.
 */
package com.edmunds.rest.databricks;

import com.edmunds.rest.databricks.DTO.jobs.JobDTO;
import com.edmunds.rest.databricks.DTO.jobs.RunParametersDTO;
import com.edmunds.rest.databricks.DatabricksRestException;
import com.edmunds.rest.databricks.DatabricksServiceFactory;
import com.edmunds.rest.databricks.JobRunnerCliParser;
import com.edmunds.rest.databricks.RunJob;
import com.edmunds.rest.databricks.service.JobService;
import java.io.IOException;
import org.apache.commons.cli.ParseException;

public class JobRunner {
    private JobService service;
    private JobRunnerCliParser parser = new JobRunnerCliParser();

    public JobRunner(String ... args) throws ParseException {
        this.parser.parse(args);
        if (this.parser.hasHelp()) {
            this.parser.printHelp();
        }
        this.service = this.getService();
    }

    public static void main(String[] args) throws IOException, InterruptedException, DatabricksRestException, ParseException {
        JobRunner main = new JobRunner(args);
        main.runJob();
    }

    public void runJob() throws IOException, DatabricksRestException, InterruptedException {
        long jobId = this.getJobId();
        RunParametersDTO runParametersDTO = new RunParametersDTO();
        if (this.parser.hasJobJarParams()) {
            runParametersDTO.setJarParams(this.parser.getJarParams());
        } else if (this.parser.hasJobNotebookParams()) {
            runParametersDTO.setNotebookParams(this.parser.getNotebookParams());
        } else if (this.parser.hasJobSaprkSubmitParams()) {
            runParametersDTO.setSparkSubmitParams(this.parser.getSparkSubmitParams());
        } else if (this.parser.hasJobPythonParams()) {
            runParametersDTO.setPythonParams(this.parser.getPythonParams());
        }
        RunJob runJob = new RunJob(this.service, jobId, runParametersDTO, this.parser.getJobTimeout(), this.parser.getJobCheckInterval());
        runJob.process();
    }

    private JobService getService() {
        String username = this.parser.getUsername();
        String password = this.parser.getPassword();
        String token = this.parser.getToken();
        String hostname = this.parser.getHostname();
        DatabricksServiceFactory factory = token != null ? DatabricksServiceFactory.Builder.createTokenAuthentication(token, hostname).build() : DatabricksServiceFactory.Builder.createUserPasswordAuthentication(username, password, hostname).build();
        return factory.getJobService();
    }

    private long getJobId() throws IOException, DatabricksRestException {
        if (this.parser.hasJobId()) {
            return this.parser.getJobId();
        }
        return this.getJobId(this.parser.getJobName());
    }

    private long getJobId(String targetJobName) throws IOException, DatabricksRestException {
        JobDTO job = this.service.getJobByName(targetJobName);
        if (job == null) {
            throw new IllegalArgumentException("Job '" + targetJobName + "' not found");
        }
        return job.getJobId();
    }
}

