/*
 * Decompiled with CFR 0.152.
 */
package com.edmunds.rest.databricks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class JobRunnerCliParser {
    private static final String SERVICE_NAME = "Run Job";
    private static final String HELP_NAME = "help";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String TOKEN = "token";
    private static final String HOSTNAME = "hostname";
    private static final String JOB_ID = "job_id";
    private static final String JOB_NAME = "name";
    private static final String JOB_JAR_PARAMS = "jarParams";
    private static final String JOB_NOTEBOOK_PARAMS = "notebookParams";
    private static final String JOB_SPARK_SUBMIT_PARAMS = "sparkSubmitParams";
    private static final String JOB_PYTHON_PARAMS = "pythonParams";
    private static final String JOB_TIMEOUT = "timeout";
    private static final String JOB_CHECK_INTERVAL = "checkInterval";
    private static final long DEFAULT_JOB_TIMEOUT = TimeUnit.DAYS.toMillis(1L);
    private static final long DEFAULT_JOB_CHECK_INTERVAL = TimeUnit.MINUTES.toMillis(2L);
    private Options options;
    private CommandLineParser parser = new BasicParser();
    private HelpFormatter formatter = new HelpFormatter();
    private CommandLine commandLine;

    public void parse(String ... cliArgs) throws ParseException {
        if (this.options == null) {
            this.options = this.makeOptions();
        }
        cliArgs = this.splitCliArguments(cliArgs);
        this.commandLine = this.parser.parse(this.options, cliArgs);
        if (this.hasHelp()) {
            return;
        }
        if (!this.hasValidArguments()) {
            throw new IllegalArgumentException("Arguments must include -u -p -h and (-j or -n) options");
        }
    }

    private String[] splitCliArguments(String[] args) {
        ArrayList toReturn = new ArrayList();
        for (String arg : args) {
            Collections.addAll(toReturn, arg.trim().split("\\s+", 2));
        }
        return toReturn.toArray(new String[0]);
    }

    public String getUsername() {
        if (this.commandLine.hasOption(USERNAME)) {
            return this.getOptionValue(USERNAME);
        }
        return null;
    }

    public String getPassword() {
        if (this.commandLine.hasOption(PASSWORD)) {
            return this.getOptionValue(PASSWORD);
        }
        return null;
    }

    public String getToken() {
        if (this.commandLine.hasOption(TOKEN)) {
            return this.getOptionValue(TOKEN);
        }
        return null;
    }

    public String getHostname() {
        return this.getOptionValue(HOSTNAME);
    }

    public boolean hasJobId() {
        return this.commandLine.hasOption(JOB_ID);
    }

    public int getJobId() {
        return Integer.parseInt(this.getOptionValue(JOB_ID));
    }

    public String getJobName() {
        return this.getOptionValue(JOB_NAME);
    }

    public boolean hasHelp() {
        return this.commandLine.hasOption(HELP_NAME);
    }

    public void printHelp() {
        this.formatter.printHelp(SERVICE_NAME, this.options);
    }

    public boolean hasJobJarParams() {
        return this.commandLine.hasOption(JOB_JAR_PARAMS);
    }

    public String[] getJarParams() {
        if (this.hasJobJarParams()) {
            return this.commandLine.getOptionValues(JOB_JAR_PARAMS);
        }
        return new String[0];
    }

    public boolean hasJobNotebookParams() {
        return this.commandLine.hasOption(JOB_NOTEBOOK_PARAMS);
    }

    public Map<String, String> getNotebookParams() {
        HashMap<String, String> notebookParams = new HashMap<String, String>();
        if (this.hasJobNotebookParams()) {
            String[] args = this.commandLine.getOptionValues(JOB_NOTEBOOK_PARAMS);
            if (args.length % 2 != 0) {
                throw new IllegalArgumentException("Notebook parameters must be a multiple of 2 for key/value pairs.");
            }
            for (int i = 0; i < args.length; i += 2) {
                notebookParams.put(args[i], args[i + 1]);
            }
        }
        return notebookParams;
    }

    public boolean hasJobPythonParams() {
        return this.commandLine.hasOption(JOB_PYTHON_PARAMS);
    }

    public String[] getPythonParams() {
        if (this.hasJobPythonParams()) {
            return this.commandLine.getOptionValues(JOB_PYTHON_PARAMS);
        }
        return new String[0];
    }

    public boolean hasJobSaprkSubmitParams() {
        return this.commandLine.hasOption(JOB_SPARK_SUBMIT_PARAMS);
    }

    public String[] getSparkSubmitParams() {
        if (this.hasJobSaprkSubmitParams()) {
            return this.commandLine.getOptionValues(JOB_SPARK_SUBMIT_PARAMS);
        }
        return new String[0];
    }

    public long getJobTimeout() {
        if (this.commandLine.hasOption(JOB_TIMEOUT)) {
            return Long.parseLong(this.commandLine.getOptionValue(JOB_TIMEOUT));
        }
        return DEFAULT_JOB_TIMEOUT;
    }

    public long getJobCheckInterval() {
        if (this.commandLine.hasOption(JOB_CHECK_INTERVAL)) {
            return Long.parseLong(this.commandLine.getOptionValue(JOB_CHECK_INTERVAL));
        }
        return DEFAULT_JOB_CHECK_INTERVAL;
    }

    private Options makeOptions() {
        Options opts = new Options();
        opts.addOption(HELP_NAME, false, "print this message");
        opts.addOption("u", USERNAME, true, "databricks login username");
        opts.addOption("p", PASSWORD, true, "databricks login password");
        opts.addOption("t", TOKEN, true, "databricks login token");
        opts.addOption("h", HOSTNAME, true, "databricks hostname");
        opts.addOption("j", JOB_ID, true, "integer job id to run");
        opts.addOption("n", JOB_NAME, true, "name of databricks job");
        opts.addOption("pj", JOB_JAR_PARAMS, true, "parameters for jar spark");
        opts.addOption("pn", JOB_NOTEBOOK_PARAMS, true, "parameters for notebook");
        opts.addOption("ps", JOB_SPARK_SUBMIT_PARAMS, true, "parameters for spark-submit");
        opts.addOption("py", JOB_PYTHON_PARAMS, true, "parameters for python");
        opts.addOption("to", JOB_TIMEOUT, true, "job timeout milliseconds");
        opts.addOption("ci", JOB_CHECK_INTERVAL, true, "job check interval milliseconds");
        return opts;
    }

    private String getOptionValue(String optionValue) {
        return this.commandLine.getOptionValue(optionValue).trim();
    }

    private boolean hasValidArguments() {
        return this.hasValidUserPasswordArguments() || this.hasValidTokenArguments();
    }

    private boolean hasValidUserPasswordArguments() {
        return this.commandLine.hasOption(USERNAME) && this.commandLine.hasOption(PASSWORD) && this.commandLine.hasOption(HOSTNAME) && (this.commandLine.hasOption(JOB_ID) || this.commandLine.hasOption(JOB_NAME));
    }

    private boolean hasValidTokenArguments() {
        return this.commandLine.hasOption(TOKEN) && this.commandLine.hasOption(HOSTNAME) && (this.commandLine.hasOption(JOB_ID) || this.commandLine.hasOption(JOB_NAME));
    }
}

