/*
 * Decompiled with CFR 0.152.
 */
package com.edmunds.rest.databricks.restclient;

import com.edmunds.rest.databricks.DatabricksRestException;
import com.edmunds.rest.databricks.HttpServiceUnavailableRetryStrategy;
import com.edmunds.rest.databricks.RequestMethod;
import com.edmunds.rest.databricks.restclient.DatabricksRestClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.log4j.Logger;

public abstract class AbstractDatabricksRestClientImpl
implements DatabricksRestClient {
    private static Logger logger = Logger.getLogger((String)AbstractDatabricksRestClientImpl.class.getName());
    protected static final int HTTPS_PORT = 443;
    protected final String apiVersion;
    protected final String host;
    protected String url;
    protected ObjectMapper mapper;
    protected HttpClient client;
    protected HttpRequestRetryHandler retryHandler;
    protected ServiceUnavailableRetryStrategy retryStrategy;

    public AbstractDatabricksRestClientImpl(String host, String apiVersion, int maxRetry, long retryInterval) {
        this(host, apiVersion, maxRetry, retryInterval, false);
    }

    public AbstractDatabricksRestClientImpl(String host, String apiVersion, int maxRetry, long retryInterval, boolean requestSentRetryEnabled) {
        this.host = host;
        this.apiVersion = apiVersion;
        this.retryHandler = new StandardHttpRequestRetryHandler(maxRetry, requestSentRetryEnabled);
        this.retryStrategy = new HttpServiceUnavailableRetryStrategy(maxRetry, retryInterval);
    }

    static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    protected byte[] extractContent(HttpResponse httpResponse) throws IOException, DatabricksRestException {
        int status = httpResponse.getStatusLine().getStatusCode();
        if (status != 200 && status != 201 && status != 204) {
            logger.error((Object)("HTTP Response error : " + httpResponse.getStatusLine()));
            String response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)"utf-8");
            throw new DatabricksRestException("Databricks Rest API returned error: \"" + response + "\"");
        }
        HttpEntity entity = httpResponse.getEntity();
        return entity == null ? null : IOUtils.toByteArray((InputStream)entity.getContent());
    }

    @Override
    public String getHost() {
        return this.host;
    }

    protected HttpRequestBase makeHttpMethod(RequestMethod requestMethod, String path, Map<String, Object> data) throws UnsupportedEncodingException, JsonProcessingException {
        switch (requestMethod) {
            case POST: {
                return this.makePostMethod(path, data);
            }
            case GET: {
                return this.makeGetMethod(path, data);
            }
            case PATCH: {
                return this.makePatchMethod(path, data);
            }
            case DELETE: {
                return this.makeDeleteMethod(path);
            }
            case PUT: {
                return this.makePutMethod(path, data);
            }
        }
        throw new IllegalArgumentException((Object)((Object)requestMethod) + " is not a valid request method");
    }

    protected HttpGet makeGetMethod(String path, Map<String, Object> data) {
        String commands = this.makeCommands(data);
        HttpGet method = new HttpGet(this.url + path + commands);
        logger.info((Object)method.toString());
        return method;
    }

    protected HttpDelete makeDeleteMethod(String path) {
        HttpDelete method = new HttpDelete(this.url + path);
        logger.info((Object)method.toString());
        method.setHeader("Accept", "application/json");
        method.setHeader("Content-type", "application/json");
        return method;
    }

    protected HttpPatch makePatchMethod(String path, Map<String, Object> data) throws UnsupportedEncodingException, JsonProcessingException {
        HttpPatch method = new HttpPatch(this.url + path);
        logger.info((Object)method.toString());
        StringEntity requestEntity = this.makeStringRequestEntity(data);
        method.setEntity((HttpEntity)requestEntity);
        method.setHeader("Accept", "application/json");
        method.setHeader("Content-type", "application/json");
        return method;
    }

    protected String makeCommands(Map<String, Object> data) {
        if (data == null || data.isEmpty()) {
            return "";
        }
        StringBuilder commands = new StringBuilder();
        commands.append("?");
        String commandSeparator = "";
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            commands.append(commandSeparator);
            commandSeparator = "&";
            commands.append(entry.getKey());
            commands.append("=");
            commands.append(entry.getValue());
        }
        return commands.toString();
    }

    protected HttpPost makePostMethod(String path, Map<String, Object> data) throws UnsupportedEncodingException, JsonProcessingException {
        HttpPost method = new HttpPost(this.url + path);
        logger.info((Object)method.toString());
        StringEntity requestEntity = this.makeStringRequestEntity(data);
        method.setEntity((HttpEntity)requestEntity);
        method.setHeader("Accept", "application/json");
        method.setHeader("Content-type", "application/json");
        return method;
    }

    protected HttpPut makePutMethod(String path, Map<String, Object> data) throws UnsupportedEncodingException, JsonProcessingException {
        HttpPut method = new HttpPut(this.url + path);
        logger.info((Object)method.toString());
        StringEntity requestEntity = this.makeStringRequestEntity(data);
        method.setEntity((HttpEntity)requestEntity);
        method.setHeader("Accept", "application/json");
        method.setHeader("Content-type", "application/json");
        return method;
    }

    protected StringEntity makeStringRequestEntity(Map<String, Object> data) throws UnsupportedEncodingException, JsonProcessingException {
        String body = this.mapper.writeValueAsString(data);
        logger.info((Object)body);
        return new StringEntity(body);
    }
}

