/*
 * Decompiled with CFR 0.152.
 */
package com.edmunds.rest.databricks.service;

import com.edmunds.rest.databricks.DTO.ClusterEventsDTO;
import com.edmunds.rest.databricks.DTO.NodeTypesDTO;
import com.edmunds.rest.databricks.DTO.SparkVersionsDTO;
import com.edmunds.rest.databricks.DTO.UpsertClusterDTO;
import com.edmunds.rest.databricks.DTO.clusters.AutoScaleDTO;
import com.edmunds.rest.databricks.DTO.clusters.ClusterEventDTO;
import com.edmunds.rest.databricks.DTO.clusters.ClusterEventTypeDTO;
import com.edmunds.rest.databricks.DTO.clusters.ClusterInfoDTO;
import com.edmunds.rest.databricks.DTO.clusters.ClusterStateDTO;
import com.edmunds.rest.databricks.DTO.clusters.NodeTypeDTO;
import com.edmunds.rest.databricks.DTO.clusters.SparkVersionDTO;
import com.edmunds.rest.databricks.DTO.jobs.NewClusterDTO;
import com.edmunds.rest.databricks.DatabricksRestException;
import com.edmunds.rest.databricks.RequestMethod;
import com.edmunds.rest.databricks.request.CreateClusterRequest;
import com.edmunds.rest.databricks.request.EditClusterRequest;
import com.edmunds.rest.databricks.restclient.DatabricksRestClient;
import com.edmunds.rest.databricks.service.ClusterService;
import com.edmunds.rest.databricks.service.DatabricksService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;

public final class ClusterServiceImpl
extends DatabricksService
implements ClusterService {
    private static Logger log = Logger.getLogger(ClusterServiceImpl.class);

    public ClusterServiceImpl(DatabricksRestClient client) {
        super(client);
    }

    @Override
    @Deprecated
    public String create(CreateClusterRequest createClusterRequest) throws IOException, DatabricksRestException {
        byte[] responseBody = this.client.performQuery(RequestMethod.POST, "/clusters/create", createClusterRequest.getData());
        Map response = (Map)this.mapper.readValue(responseBody, Map.class);
        return (String)response.get("cluster_id");
    }

    @Override
    public String create(NewClusterDTO clusterDTO) throws IOException, DatabricksRestException {
        String marshalled = this.mapper.writeValueAsString((Object)clusterDTO);
        Map data = (Map)this.mapper.readValue(marshalled, (TypeReference)new TypeReference<Map<String, Object>>(){});
        byte[] responseBody = this.client.performQuery(RequestMethod.POST, "/clusters/create", data);
        Map response = (Map)this.mapper.readValue(responseBody, (TypeReference)new TypeReference<Map<String, String>>(){});
        return (String)response.get("cluster_id");
    }

    @Override
    @Deprecated
    public void edit(EditClusterRequest editClusterRequest) throws IOException, DatabricksRestException {
        this.client.performQuery(RequestMethod.POST, "/clusters/edit", editClusterRequest.getData());
    }

    @Override
    public void edit(UpsertClusterDTO clusterDTO) throws IOException, DatabricksRestException {
        String marshalled = this.mapper.writeValueAsString((Object)clusterDTO);
        Map data = (Map)this.mapper.readValue(marshalled, (TypeReference)new TypeReference<Map<String, Object>>(){});
        this.client.performQuery(RequestMethod.POST, "/clusters/edit", data);
    }

    @Override
    public void start(String clusterId) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("cluster_id", clusterId);
        this.client.performQuery(RequestMethod.POST, "/clusters/start", data);
    }

    @Override
    public boolean isClusterRunning(String clusterId) throws IOException, DatabricksRestException {
        ClusterInfoDTO info = this.getInfo(clusterId);
        return info.getState() == ClusterStateDTO.RUNNING;
    }

    @Override
    public void restart(String clusterId) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("cluster_id", clusterId);
        this.client.performQuery(RequestMethod.POST, "/clusters/restart", data);
    }

    @Override
    public void resize(int numWorkers, String clusterId) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("num_workers", numWorkers);
        data.put("cluster_id", clusterId);
        this.client.performQuery(RequestMethod.POST, "/clusters/resize", data);
    }

    @Override
    public void resize(AutoScaleDTO autoscale, String clusterId) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("autoscale", autoscale);
        data.put("cluster_id", clusterId);
        this.client.performQuery(RequestMethod.POST, "/clusters/resize", data);
    }

    @Override
    public void delete(String clusterId) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("cluster_id", clusterId);
        this.client.performQuery(RequestMethod.POST, "/clusters/delete", data);
    }

    @Override
    public void permanentDelete(String clusterId) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("cluster_id", clusterId);
        this.client.performQuery(RequestMethod.POST, "/clusters/permanent-delete", data);
    }

    @Override
    public ClusterInfoDTO getInfo(String clusterId) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("cluster_id", clusterId);
        byte[] responseBody = this.client.performQuery(RequestMethod.GET, "/clusters/get", data);
        return (ClusterInfoDTO)this.mapper.readValue(responseBody, ClusterInfoDTO.class);
    }

    @Override
    public ClusterInfoDTO[] list() throws IOException, DatabricksRestException {
        byte[] responseBody = this.client.performQuery(RequestMethod.GET, "/clusters/list", null);
        Map jsonObject = (Map)this.mapper.readValue(responseBody, (TypeReference)new TypeReference<Map<String, ClusterInfoDTO[]>>(){});
        return (ClusterInfoDTO[])jsonObject.get("clusters");
    }

    @Override
    public List<ClusterEventDTO> listEvents(String clusterId, ClusterEventTypeDTO[] eventsToFilter, int offset, int limit) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("cluster_id", clusterId);
        data.put("event_types", eventsToFilter);
        data.put("offset", offset);
        data.put("limit", limit);
        byte[] responseBody = this.client.performQuery(RequestMethod.POST, "/clusters/events", data);
        ClusterEventsDTO clusterEvents = (ClusterEventsDTO)this.mapper.readValue(responseBody, ClusterEventsDTO.class);
        return clusterEvents.getEvents();
    }

    @Override
    public void upsertCluster(NewClusterDTO clusterDTO) throws IOException, DatabricksRestException {
        String clusterName = clusterDTO.getClusterName();
        List<ClusterInfoDTO> clusters = this.findByName(clusterName);
        if (clusters.size() > 1) {
            log.error((Object)String.format("[%s] clusters found for name: [%s]. Please consider deleting or renaming duplicate clusters. UPDATING FIRST CLUSTER ONLY", clusters.size(), clusterName));
        }
        if (clusters.size() == 0) {
            log.info((Object)String.format("Created cluster: id=[%s]", this.create(clusterDTO)));
        } else {
            String clusterId = clusters.get(0).getClusterId();
            UpsertClusterDTO upsertClusterDTO = (UpsertClusterDTO)this.mapper.convertValue((Object)clusterDTO, UpsertClusterDTO.class);
            upsertClusterDTO.setClusterId(clusterId);
            this.edit(upsertClusterDTO);
            log.info((Object)String.format("Updated cluster: name=[%s], id=[%s]", clusterName, clusterId));
        }
    }

    @Override
    public List<ClusterInfoDTO> findByName(String clusterName) throws IOException, DatabricksRestException {
        ArrayList<ClusterInfoDTO> result = new ArrayList<ClusterInfoDTO>();
        for (ClusterInfoDTO cluster : this.list()) {
            if (!clusterName.equals(cluster.getClusterName())) continue;
            result.add(cluster);
        }
        return result;
    }

    @Override
    public Optional<ClusterInfoDTO> findUniqueByName(String clusterName) throws IOException, DatabricksRestException {
        List<ClusterInfoDTO> clusters = this.findByName(clusterName);
        if (clusters.size() > 1) {
            throw new DatabricksRestException(String.format("There are %d clusters with this name: %s", clusters.size(), clusterName));
        }
        if (clusters.size() == 1) {
            return Optional.of(clusters.get(0));
        }
        return Optional.empty();
    }

    @Override
    public void pin(String clusterId) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("cluster_id", clusterId);
        this.client.performQuery(RequestMethod.POST, "/clusters/pin", data);
    }

    @Override
    public void unpin(String clusterId) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("cluster_id", clusterId);
        this.client.performQuery(RequestMethod.POST, "/clusters/unpin", data);
    }

    @Override
    public List<NodeTypeDTO> listNodeTypes() throws IOException, DatabricksRestException {
        byte[] responseBody = this.client.performQuery(RequestMethod.GET, "/clusters/list-node-types");
        return ((NodeTypesDTO)this.mapper.readValue(responseBody, NodeTypesDTO.class)).getNodeTypes();
    }

    @Override
    public List<String> listZones() throws IOException, DatabricksRestException {
        byte[] responseBody = this.client.performQuery(RequestMethod.GET, "/clusters/list-zones");
        return (List)this.mapper.readValue(responseBody, (TypeReference)new TypeReference<List<String>>(){});
    }

    @Override
    public List<SparkVersionDTO> listSparkVersions() throws IOException, DatabricksRestException {
        byte[] responseBody = this.client.performQuery(RequestMethod.GET, "/clusters/spark-versions");
        return Arrays.asList(((SparkVersionsDTO)this.mapper.readValue(responseBody, SparkVersionsDTO.class)).getSparkVersions());
    }
}

