/*
 * Decompiled with CFR 0.152.
 */
package com.edmunds.rest.databricks.service;

import com.edmunds.rest.databricks.DTO.JobsDTO;
import com.edmunds.rest.databricks.DTO.RunMetadataDTO;
import com.edmunds.rest.databricks.DTO.RunNowDTO;
import com.edmunds.rest.databricks.DTO.RunsDTO;
import com.edmunds.rest.databricks.DTO.jobs.JobDTO;
import com.edmunds.rest.databricks.DTO.jobs.JobSettingsDTO;
import com.edmunds.rest.databricks.DTO.jobs.RunDTO;
import com.edmunds.rest.databricks.DTO.jobs.RunParametersDTO;
import com.edmunds.rest.databricks.DatabricksRestException;
import com.edmunds.rest.databricks.RequestMethod;
import com.edmunds.rest.databricks.restclient.DatabricksRestClient;
import com.edmunds.rest.databricks.service.DatabricksService;
import com.edmunds.rest.databricks.service.JobService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class JobServiceImpl
extends DatabricksService
implements JobService {
    private static Logger log = Logger.getLogger(JobServiceImpl.class);

    public JobServiceImpl(DatabricksRestClient client) {
        super(client);
    }

    @Override
    public long createJob(JobSettingsDTO jobSettingsDTO) throws IOException, DatabricksRestException {
        String marshalled = this.mapper.writeValueAsString((Object)jobSettingsDTO);
        Map data = (Map)this.mapper.readValue(marshalled, (TypeReference)new TypeReference<Map<String, Object>>(){});
        byte[] responseBody = this.client.performQuery(RequestMethod.POST, "/jobs/create", data);
        Map response = (Map)this.mapper.readValue(responseBody, (TypeReference)new TypeReference<Map<String, Long>>(){});
        return (Long)response.get("job_id");
    }

    @Override
    public void deleteJob(long jobId) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("job_id", jobId);
        this.client.performQuery(RequestMethod.POST, "/jobs/delete", data);
    }

    @Override
    public void deleteJob(String jobName) throws IOException, DatabricksRestException {
        JobDTO jobDTO = this.getJobByName(jobName);
        if (jobDTO != null) {
            log.info((Object)("Deleting: " + this.getJobLink(jobDTO.getJobId())));
            this.deleteJob(jobDTO.getJobId());
        } else {
            log.info((Object)("No jobs found for " + jobName));
        }
    }

    @Override
    public JobDTO getJob(long jobId) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("job_id", jobId);
        byte[] responseBody = this.client.performQuery(RequestMethod.GET, "/jobs/get", data);
        return (JobDTO)this.mapper.readValue(responseBody, JobDTO.class);
    }

    @Override
    public List<JobDTO> getJobsByName(String jobName) throws IOException, DatabricksRestException {
        return this.getJobsByRegex(Pattern.compile(jobName));
    }

    @Override
    public JobDTO getJobByName(String jobName) throws IOException, DatabricksRestException {
        return this.getJobByName(jobName, true);
    }

    @Override
    public JobDTO getJobByName(String jobName, boolean failOnMultipleJobs) throws IOException, DatabricksRestException {
        List<JobDTO> jobs = this.getJobsByName(jobName);
        if (jobs.size() > 1) {
            String errorMessage = String.format("[%s] job ids found for name: [%s]. Please delete duplicate jobs, or renaming conflicting jobs:\n%s\n", jobs.size(), jobName, jobs);
            if (failOnMultipleJobs) {
                throw new IllegalStateException(errorMessage);
            }
            log.error((Object)errorMessage);
            log.error((Object)"returning the job with the lowest jobId");
            long lowestJobId = Long.MAX_VALUE;
            JobDTO lowestJob = null;
            for (JobDTO job : jobs) {
                if (job.getJobId() >= lowestJobId) continue;
                lowestJobId = job.getJobId();
                lowestJob = job;
            }
            return lowestJob;
        }
        if (jobs.isEmpty()) {
            return null;
        }
        return jobs.get(0);
    }

    @Override
    public List<JobDTO> getJobsByRegex(Pattern regex) throws IOException, DatabricksRestException {
        if (regex == null) {
            throw new IllegalArgumentException("Job name must not be blank.");
        }
        ArrayList<JobDTO> foundJobDTOs = new ArrayList<JobDTO>();
        for (JobDTO jobDTO : this.listAllJobs().getJobs()) {
            JobSettingsDTO jobSettingsDTO = jobDTO.getSettings();
            Matcher matcher = regex.matcher(jobSettingsDTO.getName());
            if (!matcher.matches()) continue;
            foundJobDTOs.add(jobDTO);
        }
        return foundJobDTOs;
    }

    @Override
    public JobsDTO listAllJobs() throws DatabricksRestException, IOException {
        byte[] responseBody = this.client.performQuery(RequestMethod.GET, "/jobs/list", null);
        return (JobsDTO)this.mapper.readValue(responseBody, JobsDTO.class);
    }

    @Override
    public String getJobLink(long jobId) {
        return String.format("https://%s/#job/%s", this.client.getHost(), jobId);
    }

    @Override
    public RunNowDTO runJobNow(long jobId) throws DatabricksRestException, IOException {
        return this.runJobNow(jobId, (RunParametersDTO)null);
    }

    @Override
    public RunNowDTO runJobNow(long jobId, Map<String, String> notebookParams) throws DatabricksRestException, IOException {
        RunParametersDTO parametersDTO = new RunParametersDTO();
        parametersDTO.setNotebookParams(notebookParams);
        return this.runJobNow(jobId, parametersDTO);
    }

    @Override
    public RunNowDTO runJobNow(long jobId, RunParametersDTO params) throws DatabricksRestException, IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("job_id", jobId);
        if (params != null) {
            if (params.getJarParams() != null) {
                data.put("jar_params", params.getJarParams());
            } else if (params.getNotebookParams() != null) {
                data.put("notebook_params", params.getNotebookParams());
            } else if (params.getPythonParams() != null) {
                data.put("python_params", params.getPythonParams());
            } else if (params.getSparkSubmitParams() != null) {
                data.put("spark_submit_params", params.getSparkSubmitParams());
            }
        }
        byte[] responseBody = this.client.performQuery(RequestMethod.POST, "/jobs/run-now", data);
        return (RunNowDTO)this.mapper.readValue(responseBody, RunNowDTO.class);
    }

    @Override
    public RunsDTO listRuns(Long jobId, Boolean activeOnly, Integer offset, Integer limit) throws DatabricksRestException, IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (jobId != null) {
            data.put("job_id", jobId);
        }
        if (activeOnly != null) {
            data.put("active_only", activeOnly);
        }
        if (offset != null) {
            data.put("offset", offset);
        }
        if (limit != null) {
            data.put("limit", limit);
        }
        byte[] responseBody = this.client.performQuery(RequestMethod.GET, "/jobs/runs/list", data);
        return (RunsDTO)this.mapper.readValue(responseBody, RunsDTO.class);
    }

    @Override
    public RunDTO getRun(long runId) throws DatabricksRestException, IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("run_id", runId);
        byte[] responseBody = this.client.performQuery(RequestMethod.GET, "/jobs/runs/get", data);
        return (RunDTO)this.mapper.readValue(responseBody, RunDTO.class);
    }

    @Override
    public void cancelRun(long runId) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("run_id", runId);
        this.client.performQuery(RequestMethod.POST, "/jobs/runs/cancel", data);
    }

    @Override
    public void reset(long jobId, JobSettingsDTO jobSettings) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("job_id", jobId);
        data.put("new_settings", jobSettings);
        this.client.performQuery(RequestMethod.POST, "/jobs/reset", data);
    }

    @Override
    public String buildRunJobRestUrl(long jobId, long numberInJob) {
        return "https://" + this.client.getHost() + "/#job/" + jobId + "/run/" + numberInJob;
    }

    @Override
    public void upsertJob(JobSettingsDTO jobSettingsDTO, boolean failOnDuplicateJobNames) throws IOException, DatabricksRestException {
        String jobName = jobSettingsDTO.getName();
        List<JobDTO> jobs = this.getJobsByName(jobName);
        if (jobs.size() > 1) {
            String errorMessage = String.format("[%s] job ids found for name: [%s]. Please consider deleting duplicate jobs, or renaming conflicting jobs:\n%s\n", jobs.size(), jobName, jobs);
            if (failOnDuplicateJobNames) {
                throw new IllegalArgumentException(errorMessage);
            }
            log.error((Object)(errorMessage + "UPDATING FIRST JOB ONLY"));
        }
        if (jobs.size() == 0) {
            long newJobId = this.createJob(jobSettingsDTO);
            log.info((Object)String.format("Created job, url: %s", this.getJobLink(newJobId)));
        } else {
            for (JobDTO job : jobs) {
                this.reset(job.getJobId(), jobSettingsDTO);
                log.info((Object)String.format("Updated job, url: %s", this.getJobLink(job.getJobId())));
            }
        }
    }

    @Override
    public RunNowDTO runSubmit(JobSettingsDTO jobSettings) throws IOException, DatabricksRestException {
        String marshalled = this.mapper.writeValueAsString((Object)jobSettings);
        Map data = (Map)this.mapper.readValue(marshalled, (TypeReference)new TypeReference<Map<String, Object>>(){});
        byte[] responseBody = this.client.performQuery(RequestMethod.POST, "/jobs/runs/submit", data);
        return (RunNowDTO)this.mapper.readValue(responseBody, RunNowDTO.class);
    }

    @Override
    public String getOutput(long runId) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("run_id", runId);
        byte[] responseBody = this.client.performQuery(RequestMethod.GET, "/jobs/runs/get-output", data);
        RunMetadataDTO metadata = (RunMetadataDTO)this.mapper.readValue(responseBody, RunMetadataDTO.class);
        return metadata.getNotebookOutput().getResult();
    }
}

