/*
 * Decompiled with CFR 0.152.
 */
package com.edmunds.rest.databricks.service;

import com.edmunds.rest.databricks.DTO.workspace.ObjectInfoDTO;
import com.edmunds.rest.databricks.DatabricksRestException;
import com.edmunds.rest.databricks.RequestMethod;
import com.edmunds.rest.databricks.request.ExportWorkspaceRequest;
import com.edmunds.rest.databricks.request.ImportWorkspaceRequest;
import com.edmunds.rest.databricks.restclient.DatabricksRestClient;
import com.edmunds.rest.databricks.service.DatabricksService;
import com.edmunds.rest.databricks.service.WorkspaceService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class WorkspaceServiceImpl
extends DatabricksService
implements WorkspaceService {
    public WorkspaceServiceImpl(DatabricksRestClient client) {
        super(client);
    }

    @Override
    public void delete(String path, boolean recursive) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("path", path);
        data.put("recursive", recursive);
        this.client.performQuery(RequestMethod.POST, "/workspace/delete", data);
    }

    @Override
    public byte[] exportWorkspace(ExportWorkspaceRequest exportWorkspaceRequest) throws IOException, DatabricksRestException {
        byte[] responseBody = this.client.performQuery(RequestMethod.GET, "/workspace/export", exportWorkspaceRequest.getData());
        Map result = (Map)this.mapper.readValue(responseBody, (TypeReference)new TypeReference<Map<String, String>>(){});
        return ((String)result.get("content")).getBytes();
    }

    @Override
    public ObjectInfoDTO getStatus(String path) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("path", path);
        byte[] responseBody = this.client.performQuery(RequestMethod.GET, "/workspace/get-status", data);
        return (ObjectInfoDTO)this.mapper.readValue(responseBody, ObjectInfoDTO.class);
    }

    @Override
    public void importWorkspace(ImportWorkspaceRequest importWorkspaceRequest) throws IOException, DatabricksRestException {
        this.client.performQuery(RequestMethod.POST, "/workspace/import", importWorkspaceRequest.getData());
    }

    @Override
    public ObjectInfoDTO[] listStatus(String path) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("path", path);
        byte[] responseBody = this.client.performQuery(RequestMethod.GET, "/workspace/list", data);
        Map result = (Map)this.mapper.readValue(responseBody, (TypeReference)new TypeReference<Map<String, ObjectInfoDTO[]>>(){});
        return (ObjectInfoDTO[])result.get("objects");
    }

    @Override
    public void mkdirs(String path) throws IOException, DatabricksRestException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("path", path);
        this.client.performQuery(RequestMethod.POST, "/workspace/mkdirs", data);
    }
}

