/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.apache.org.apache.http.impl.nio.client;

import gigahorse.shaded.apache.org.apache.commons.logging.Log;
import gigahorse.shaded.apache.org.apache.commons.logging.LogFactory;
import gigahorse.shaded.apache.org.apache.http.ConnectionReuseStrategy;
import gigahorse.shaded.apache.org.apache.http.HttpHost;
import gigahorse.shaded.apache.org.apache.http.client.protocol.HttpClientContext;
import gigahorse.shaded.apache.org.apache.http.concurrent.BasicFuture;
import gigahorse.shaded.apache.org.apache.http.concurrent.FutureCallback;
import gigahorse.shaded.apache.org.apache.http.conn.ConnectionKeepAliveStrategy;
import gigahorse.shaded.apache.org.apache.http.impl.DefaultConnectionReuseStrategy;
import gigahorse.shaded.apache.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import gigahorse.shaded.apache.org.apache.http.impl.nio.client.CloseableHttpAsyncClientBase;
import gigahorse.shaded.apache.org.apache.http.impl.nio.client.FutureWrapper;
import gigahorse.shaded.apache.org.apache.http.impl.nio.client.MinimalClientExchangeHandlerImpl;
import gigahorse.shaded.apache.org.apache.http.impl.nio.client.PipeliningClientExchangeHandlerImpl;
import gigahorse.shaded.apache.org.apache.http.nio.NHttpClientEventHandler;
import gigahorse.shaded.apache.org.apache.http.nio.conn.NHttpClientConnectionManager;
import gigahorse.shaded.apache.org.apache.http.nio.protocol.HttpAsyncRequestExecutor;
import gigahorse.shaded.apache.org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import gigahorse.shaded.apache.org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import gigahorse.shaded.apache.org.apache.http.protocol.BasicHttpContext;
import gigahorse.shaded.apache.org.apache.http.protocol.HttpContext;
import gigahorse.shaded.apache.org.apache.http.protocol.HttpProcessor;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

class MinimalHttpAsyncClient
extends CloseableHttpAsyncClientBase {
    private final Log log = LogFactory.getLog(this.getClass());
    private final NHttpClientConnectionManager connmgr;
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final ConnectionKeepAliveStrategy keepaliveStrategy;

    public MinimalHttpAsyncClient(NHttpClientConnectionManager connmgr, ThreadFactory threadFactory, NHttpClientEventHandler eventHandler, HttpProcessor httpProcessor, ConnectionReuseStrategy connReuseStrategy, ConnectionKeepAliveStrategy keepaliveStrategy) {
        super(connmgr, threadFactory, eventHandler);
        this.connmgr = connmgr;
        this.httpProcessor = httpProcessor;
        this.connReuseStrategy = connReuseStrategy;
        this.keepaliveStrategy = keepaliveStrategy;
    }

    public MinimalHttpAsyncClient(NHttpClientConnectionManager connmgr, HttpProcessor httpProcessor) {
        this(connmgr, Executors.defaultThreadFactory(), new HttpAsyncRequestExecutor(), httpProcessor, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
    }

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        BasicFuture<T> future = new BasicFuture<T>(callback);
        HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
        MinimalClientExchangeHandlerImpl<T> handler = new MinimalClientExchangeHandlerImpl<T>(this.log, requestProducer, responseConsumer, localcontext, future, this.connmgr, this.httpProcessor, this.connReuseStrategy, this.keepaliveStrategy);
        this.execute(handler);
        return new FutureWrapper<T>(future, handler);
    }

    @Override
    public <T> Future<List<T>> execute(HttpHost target, List<? extends HttpAsyncRequestProducer> requestProducers, List<? extends HttpAsyncResponseConsumer<T>> responseConsumers, HttpContext context, FutureCallback<List<T>> callback) {
        BasicFuture<List<T>> future = new BasicFuture<List<T>>(callback);
        HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
        PipeliningClientExchangeHandlerImpl<T> handler = new PipeliningClientExchangeHandlerImpl<T>(this.log, target, requestProducers, responseConsumers, localcontext, future, this.connmgr, this.httpProcessor, this.connReuseStrategy, this.keepaliveStrategy);
        this.execute(handler);
        return new FutureWrapper<List<T>>(future, handler);
    }
}

