/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.apache.org.apache.http.protocol;

import gigahorse.shaded.apache.org.apache.http.HttpException;
import gigahorse.shaded.apache.org.apache.http.HttpResponse;
import gigahorse.shaded.apache.org.apache.http.HttpResponseInterceptor;
import gigahorse.shaded.apache.org.apache.http.annotation.Contract;
import gigahorse.shaded.apache.org.apache.http.annotation.ThreadingBehavior;
import gigahorse.shaded.apache.org.apache.http.protocol.HttpContext;
import gigahorse.shaded.apache.org.apache.http.protocol.HttpDateGenerator;
import gigahorse.shaded.apache.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

