/*
 * Decompiled with CFR 0.152.
 */
package treehugger;

import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import treehugger.NameTransformer;

public final class NameTransformer$ {
    public static NameTransformer$ MODULE$;
    private final String MODULE_SUFFIX_STRING;
    private final String NAME_JOIN_STRING;
    private final String MODULE_INSTANCE_NAME;
    private final int nops;
    private final int ncodes;
    private final String[] op2code;
    private final NameTransformer.OpCodes[] code2op;

    static {
        new NameTransformer$();
    }

    public String MODULE_SUFFIX_STRING() {
        return this.MODULE_SUFFIX_STRING;
    }

    public String NAME_JOIN_STRING() {
        return this.NAME_JOIN_STRING;
    }

    public String MODULE_INSTANCE_NAME() {
        return this.MODULE_INSTANCE_NAME;
    }

    private int nops() {
        return this.nops;
    }

    private int ncodes() {
        return this.ncodes;
    }

    private String[] op2code() {
        return this.op2code;
    }

    private NameTransformer.OpCodes[] code2op() {
        return this.code2op;
    }

    private void enterOp(char op, String code) {
        this.op2code()[op] = code;
        int c = (code.charAt(1) - 97) * 26 + code.charAt(2) - 97;
        this.code2op()[c] = new NameTransformer.OpCodes(op, code, this.code2op()[c]);
    }

    public String encode(String name) {
        StringBuilder buf = null;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            Object object;
            char c = name.charAt(i);
            if (c < this.nops() && this.op2code()[c] != null) {
                BoxedUnit boxedUnit;
                if (buf == null) {
                    buf = new StringBuilder();
                    boxedUnit = buf.append(name.substring(0, i));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = buf.append(this.op2code()[c]);
                continue;
            }
            if (!Character.isJavaIdentifierPart(c)) {
                BoxedUnit boxedUnit;
                if (buf == null) {
                    buf = new StringBuilder();
                    boxedUnit = buf.append(name.substring(0, i));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = buf.append(new StringOps(Predef$.MODULE$.augmentString("$u%04X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)})));
                continue;
            }
            object = buf != null ? buf.append(c) : BoxedUnit.UNIT;
        }
        return buf == null ? name : buf.toString();
    }

    public String decode(String name0) {
        String name = name0.endsWith("<init>") ? new java.lang.StringBuilder(4).append(name0.substring(0, name0.length() - "<init>".length())).append("this").toString() : name0;
        StringBuilder buf = null;
        int len = name.length();
        int i = 0;
        while (i < len) {
            char ch1;
            NameTransformer.OpCodes ops = null;
            boolean unicode = false;
            char c = name.charAt(i);
            if (c == '$' && i + 2 < len && 'a' <= (ch1 = name.charAt(i + 1)) && ch1 <= 'z') {
                char ch2 = name.charAt(i + 2);
                if ('a' <= ch2 && ch2 <= 'z') {
                    for (ops = this.code2op()[(ch1 - 97) * 26 + ch2 - 97]; ops != null && !name.startsWith(ops.code(), i); ops = ops.next()) {
                    }
                    if (ops != null) {
                        BoxedUnit boxedUnit;
                        if (buf == null) {
                            buf = new StringBuilder();
                            boxedUnit = buf.append(name.substring(0, i));
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        buf.append(ops.op());
                        i += ops.code().length();
                    }
                } else if (len - i >= 6 && ch1 == 'u' && (Character.isDigit(ch2) || 'A' <= ch2 && ch2 <= 'F')) {
                    String hex = name.substring(i + 2, i + 6);
                    try {
                        BoxedUnit boxedUnit;
                        char str = (char)Integer.parseInt(hex, 16);
                        if (buf == null) {
                            buf = new StringBuilder();
                            boxedUnit = buf.append(name.substring(0, i));
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        buf.append(str);
                        i += 6;
                        unicode = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if (ops != null || unicode) continue;
            Object object = buf != null ? buf.append(c) : BoxedUnit.UNIT;
            ++i;
        }
        return buf == null ? name : buf.toString();
    }

    private NameTransformer$() {
        MODULE$ = this;
        this.MODULE_SUFFIX_STRING = "$";
        this.NAME_JOIN_STRING = "$";
        this.MODULE_INSTANCE_NAME = "MODULE$";
        this.nops = 128;
        this.ncodes = 676;
        this.op2code = new String[this.nops()];
        this.code2op = new NameTransformer.OpCodes[this.ncodes()];
        this.enterOp('~', "$tilde");
        this.enterOp('=', "$eq");
        this.enterOp('<', "$less");
        this.enterOp('>', "$greater");
        this.enterOp('!', "$bang");
        this.enterOp('#', "$hash");
        this.enterOp('%', "$percent");
        this.enterOp('^', "$up");
        this.enterOp('&', "$amp");
        this.enterOp('|', "$bar");
        this.enterOp('*', "$times");
        this.enterOp('/', "$div");
        this.enterOp('+', "$plus");
        this.enterOp('-', "$minus");
        this.enterOp(':', "$colon");
        this.enterOp('\\', "$bslash");
        this.enterOp('?', "$qmark");
        this.enterOp('@', "$at");
    }
}

