/*
 * Decompiled with CFR 0.152.
 */
package com.emc.rest.smart;

import com.emc.rest.smart.HostStats;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Host
implements HostStats {
    private static final Logger log = LoggerFactory.getLogger(Host.class);
    public static final int DEFAULT_ERROR_WAIT_MS = 1500;
    public static final int LOG_DELAY = 60000;
    public static final int MAX_COOL_DOWN_EXP = 4;
    private final String name;
    private int port;
    private boolean healthy = true;
    protected int errorWaitTime = 1500;
    private String logName;
    protected int openConnections;
    protected long lastConnectionTime;
    protected long totalConnections;
    protected long totalErrors;
    protected long consecutiveErrors;
    protected long lastLogTime;

    public Host(String name) {
        this(name, -1);
    }

    public Host(String name, int port) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.port = port;
        this.logName = port < 0 ? name : name + ":" + port;
    }

    public synchronized void connectionOpened() {
        ++this.openConnections;
        ++this.totalConnections;
        this.lastConnectionTime = System.currentTimeMillis();
    }

    public synchronized void connectionClosed() {
        long currentTime;
        --this.openConnections;
        if (this.openConnections < 0 && (currentTime = System.currentTimeMillis()) - this.lastLogTime > 60000L) {
            log.warn("openConnections for host {} is {} !", (Object)this, (Object)this.openConnections);
            this.lastLogTime = currentTime;
        }
    }

    public synchronized void callComplete(boolean isError) {
        if (isError) {
            ++this.totalErrors;
            ++this.consecutiveErrors;
            log.debug("error tallied for {}; total errors: {}, consecutive errors: {}", new Object[]{this.logName, this.totalErrors, this.consecutiveErrors});
        } else {
            this.consecutiveErrors = 0L;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isHealthy() {
        long errorCoolDown;
        if (!this.healthy) {
            return false;
        }
        if (this.consecutiveErrors == 0L) {
            return true;
        }
        long coolDownExp = Math.min(this.consecutiveErrors - 1L, 4L);
        long msSinceLastUse = System.currentTimeMillis() - this.lastConnectionTime;
        return msSinceLastUse > (errorCoolDown = (long)Math.pow(2.0, coolDownExp) * (long)this.errorWaitTime);
    }

    public void setHealthy(boolean healthy) {
        this.healthy = healthy;
    }

    public long getResponseIndex() {
        return this.openConnections;
    }

    public synchronized void resetStats() {
        this.totalConnections = this.openConnections;
        this.totalErrors = 0L;
        this.consecutiveErrors = 0L;
    }

    @Override
    public long getTotalConnections() {
        return this.totalConnections;
    }

    @Override
    public long getTotalErrors() {
        return this.totalErrors;
    }

    @Override
    public int getOpenConnections() {
        return this.openConnections;
    }

    @Override
    public Date getLastConnectionTime() {
        return new Date(this.lastConnectionTime);
    }

    public long getConsecutiveErrors() {
        return this.consecutiveErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Host host = (Host)o;
        return this.port == host.port && this.name.equals(host.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.port);
    }

    public String toString() {
        return String.format("%s{totalConnections=%d, totalErrors=%d, openConnections=%d, lastConnectionTime=%s}", this.logName, this.totalConnections, this.totalErrors, this.openConnections, new Date(this.lastConnectionTime));
    }

    public int getErrorWaitTime() {
        return this.errorWaitTime;
    }

    public void setErrorWaitTime(int errorWaitTime) {
        this.errorWaitTime = errorWaitTime;
    }

    public Host withErrorWaitTime(int errorWaitTime) {
        this.setErrorWaitTime(errorWaitTime);
        return this;
    }
}

