/*
 * Decompiled with CFR 0.152.
 */
package com.emc.rest.smart;

import com.emc.rest.smart.Host;
import com.emc.rest.smart.HostStats;
import com.emc.rest.smart.HostVetoRule;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LoadBalancer {
    private final Deque<Host> hosts = new ArrayDeque<Host>();
    private List<HostVetoRule> vetoRules;

    public LoadBalancer(List<Host> initialHosts) {
        this.hosts.addAll(initialHosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host getTopHost(Map<String, Object> requestProperties) {
        Host topHost = null;
        Host topHealthyHost = null;
        long lowestIndex = Long.MAX_VALUE;
        long lowestHealthyIndex = Long.MAX_VALUE;
        Deque<Host> deque = this.hosts;
        synchronized (deque) {
            for (Host host : this.hosts) {
                if (this.shouldVeto(host, requestProperties)) continue;
                long hostIndex = host.getResponseIndex();
                if (hostIndex < lowestIndex) {
                    topHost = host;
                    lowestIndex = hostIndex;
                }
                if (!host.isHealthy() || hostIndex >= lowestHealthyIndex) continue;
                topHealthyHost = host;
                lowestHealthyIndex = hostIndex;
            }
            if (topHealthyHost != null) {
                topHost = topHealthyHost;
            }
            this.hosts.remove(topHost);
            this.hosts.add(topHost);
        }
        return topHost;
    }

    protected boolean shouldVeto(Host host, Map<String, Object> requestProperties) {
        if (this.vetoRules != null) {
            for (HostVetoRule vetoRule : this.vetoRules) {
                if (!vetoRule.shouldVeto(host, requestProperties)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized List<Host> getAllHosts() {
        return new ArrayList<Host>(this.hosts);
    }

    public synchronized HostStats[] getHostStats() {
        return this.hosts.toArray(new HostStats[0]);
    }

    public void resetStats() {
        for (Host host : this.getAllHosts()) {
            host.resetStats();
        }
    }

    public long getTotalConnections() {
        long totalConnections = 0L;
        for (Host host : this.getAllHosts()) {
            totalConnections += host.getTotalConnections();
        }
        return totalConnections;
    }

    public long getTotalErrors() {
        long totalErrors = 0L;
        for (Host host : this.getAllHosts()) {
            totalErrors += host.getTotalErrors();
        }
        return totalErrors;
    }

    public long getOpenConnections() {
        long openConnections = 0L;
        for (Host host : this.getAllHosts()) {
            openConnections += (long)host.getOpenConnections();
        }
        return openConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateHosts(List<Host> updatedHosts) {
        ArrayList<Host> hostList = new ArrayList<Host>(updatedHosts);
        Deque<Host> deque = this.hosts;
        synchronized (deque) {
            Iterator<Host> hostI = this.hosts.iterator();
            while (hostI.hasNext()) {
                Host host = hostI.next();
                boolean stillThere = false;
                Iterator hostListI = hostList.iterator();
                while (hostListI.hasNext()) {
                    Host hostFromUpdate = (Host)hostListI.next();
                    if (!host.equals(hostFromUpdate)) continue;
                    stillThere = true;
                    hostListI.remove();
                    break;
                }
                if (stillThere) continue;
                hostI.remove();
            }
            this.hosts.addAll(hostList);
        }
    }

    public List<HostVetoRule> getVetoRules() {
        return this.vetoRules;
    }

    public void setVetoRules(List<HostVetoRule> vetoRules) {
        this.vetoRules = vetoRules;
    }

    public LoadBalancer withVetoRules(HostVetoRule ... vetoRules) {
        this.setVetoRules(Arrays.asList(vetoRules));
        return this;
    }
}

