/*
 * Decompiled with CFR 0.152.
 */
package com.emc.rest.smart;

import com.emc.rest.smart.Host;
import com.emc.rest.smart.HostListProvider;
import com.emc.rest.smart.LoadBalancer;
import com.emc.rest.smart.SmartConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingDaemon
extends Thread {
    public static final String PROPERTY_KEY = "com.emc.rest.smart.pollingDaemon";
    private static final Logger log = LoggerFactory.getLogger(PollingDaemon.class);
    private final SmartConfig smartConfig;
    private boolean running = true;

    public PollingDaemon(SmartConfig smartConfig) {
        this.smartConfig = smartConfig;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (this.running) {
            long start = System.currentTimeMillis();
            log.debug("polling daemon running");
            LoadBalancer loadBalancer = this.smartConfig.getLoadBalancer();
            HostListProvider hostListProvider = this.smartConfig.getHostListProvider();
            if (!this.smartConfig.isHostUpdateEnabled()) {
                log.info("host update is disabled; not updating hosts");
            } else if (hostListProvider == null) {
                log.info("no host list provider; not updating hosts");
            } else {
                try {
                    loadBalancer.updateHosts(hostListProvider.getHostList());
                }
                catch (Throwable t) {
                    log.warn("unable to enumerate servers", t);
                }
            }
            if (!this.smartConfig.isHealthCheckEnabled()) {
                log.info("health check is disabled; not checking hosts");
            } else if (hostListProvider == null) {
                log.info("no host list provider; not checking hosts");
            } else {
                for (Host host : loadBalancer.getAllHosts()) {
                    try {
                        hostListProvider.runHealthCheck(host);
                        host.setHealthy(true);
                        log.debug("health check successful for {}; host is marked healthy", (Object)host.getName());
                    }
                    catch (Throwable t) {
                        host.setHealthy(false);
                        log.warn("health check failed for " + host.getName() + "; host is marked unhealthy", t);
                    }
                }
            }
            long callTime = System.currentTimeMillis() - start;
            try {
                long sleepTime = (long)this.smartConfig.getPollInterval() * 1000L - callTime;
                if (sleepTime < 0L) {
                    sleepTime = 0L;
                }
                log.debug("polling daemon finished; will poll again in {}ms..", (Object)sleepTime);
                if (sleepTime <= 0L) continue;
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                log.warn("interrupted while sleeping", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.running = false;
    }

    public SmartConfig getSmartConfig() {
        return this.smartConfig;
    }

    public boolean isRunning() {
        return this.running;
    }
}

