/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import java.util.Set;
import org.sdmxsource.sdmx.api.builder.SuperBeansBuilder;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxSuperBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.ResolutionSettings;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.superbeans.SuperBeans;
import org.sdmxsource.sdmx.api.model.superbeans.categoryscheme.CategorySchemeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.CodelistSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.HierarchicalCodelistSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.conceptscheme.ConceptSchemeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataflowSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.metadata.MetadataStructureSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.registry.ProvisionAgreementSuperBean;
import org.sdmxsource.sdmx.util.beans.SuperBeanRefUtil;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class SdmxSuperBeanRetrievalManagerImpl
implements SdmxSuperBeanRetrievalManager {
    private final SuperBeansBuilder superBeanBuilder;
    private final SdmxBeanRetrievalManager beanRetrievalManager;

    public SdmxSuperBeanRetrievalManagerImpl(SuperBeansBuilder superBeanBuilder, SdmxBeanRetrievalManager beanRetrievalManager) {
        this.superBeanBuilder = superBeanBuilder;
        this.beanRetrievalManager = beanRetrievalManager;
    }

    private SuperBeans getSuperBeans(StructureReferenceBean sRef) {
        if (this.superBeanBuilder == null) {
            throw new RuntimeException("'superBeanBuilder' is null");
        }
        SdmxBeans sdmxBeans = this.beanRetrievalManager.getSdmxBeans(sRef, ResolutionSettings.RESOLVE_CROSS_REFERENCES.RESOLVE_EXCLUDE_AGENCIES);
        return (SuperBeans)this.superBeanBuilder.build((Object)sdmxBeans);
    }

    public CategorySchemeSuperBean getCategorySchemeSuperBean(MaintainableRefBean ref) {
        Set<CategorySchemeSuperBean> beans = this.getCategorySchemeSuperBeans(ref);
        if (!ObjectUtil.validCollection(beans)) {
            return null;
        }
        return (CategorySchemeSuperBean)SuperBeanRefUtil.resolveReference(beans, (MaintainableRefBean)ref);
    }

    public Set<CategorySchemeSuperBean> getCategorySchemeSuperBeans(MaintainableRefBean ref) {
        return this.getSuperBeans((StructureReferenceBean)new StructureReferenceBeanImpl(ref, SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME)).getCategorySchemes();
    }

    public CodelistSuperBean getCodelistSuperBean(MaintainableRefBean ref) {
        Set<CodelistSuperBean> beans = this.getCodelistSuperBeans(ref);
        if (!ObjectUtil.validCollection(beans)) {
            return null;
        }
        return (CodelistSuperBean)SuperBeanRefUtil.resolveReference(beans, (MaintainableRefBean)ref);
    }

    public Set<CodelistSuperBean> getCodelistSuperBeans(MaintainableRefBean ref) {
        return this.getSuperBeans((StructureReferenceBean)new StructureReferenceBeanImpl(ref, SDMX_STRUCTURE_TYPE.CODE_LIST)).getCodelists();
    }

    public ConceptSchemeSuperBean getConceptSchemeSuperBean(MaintainableRefBean ref) {
        Set<ConceptSchemeSuperBean> beans = this.getConceptSchemeSuperBeans(ref);
        if (!ObjectUtil.validCollection(beans)) {
            return null;
        }
        return (ConceptSchemeSuperBean)SuperBeanRefUtil.resolveReference(beans, (MaintainableRefBean)ref);
    }

    public Set<ConceptSchemeSuperBean> getConceptSchemeSuperBeans(MaintainableRefBean ref) {
        return this.getSuperBeans((StructureReferenceBean)new StructureReferenceBeanImpl(ref, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME)).getConceptSchemes();
    }

    public DataflowSuperBean getDataflowSuperBean(MaintainableRefBean ref) {
        Set<DataflowSuperBean> beans = this.getDataflowSuperBeans(ref);
        if (!ObjectUtil.validCollection(beans)) {
            return null;
        }
        return (DataflowSuperBean)SuperBeanRefUtil.resolveReference(beans, (MaintainableRefBean)ref);
    }

    public Set<DataflowSuperBean> getDataflowSuperBeans(MaintainableRefBean ref) {
        return this.getSuperBeans((StructureReferenceBean)new StructureReferenceBeanImpl(ref, SDMX_STRUCTURE_TYPE.DATAFLOW)).getDataflows();
    }

    public HierarchicalCodelistSuperBean getHierarchicCodeListSuperBean(MaintainableRefBean ref) {
        Set<HierarchicalCodelistSuperBean> beans = this.getHierarchicCodeListSuperBeans(ref);
        if (!ObjectUtil.validCollection(beans)) {
            return null;
        }
        return (HierarchicalCodelistSuperBean)SuperBeanRefUtil.resolveReference(beans, (MaintainableRefBean)ref);
    }

    public Set<HierarchicalCodelistSuperBean> getHierarchicCodeListSuperBeans(MaintainableRefBean ref) {
        return this.getSuperBeans((StructureReferenceBean)new StructureReferenceBeanImpl(ref, SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST)).getHierarchicalCodelists();
    }

    public DataStructureSuperBean getDataStructureSuperBean(MaintainableRefBean ref) {
        Set<DataStructureSuperBean> beans = this.getDataStructureSuperBeans(ref);
        if (!ObjectUtil.validCollection(beans)) {
            return null;
        }
        return (DataStructureSuperBean)SuperBeanRefUtil.resolveReference(beans, (MaintainableRefBean)ref);
    }

    public Set<DataStructureSuperBean> getDataStructureSuperBeans(MaintainableRefBean ref) {
        return this.getSuperBeans((StructureReferenceBean)new StructureReferenceBeanImpl(ref, SDMX_STRUCTURE_TYPE.DSD)).getDataStructures();
    }

    public MetadataStructureSuperBean getMetadataStructureSuperBean(MaintainableRefBean ref) {
        Set<MetadataStructureSuperBean> beans = this.getMetadataStructureSuperBeans(ref);
        if (!ObjectUtil.validCollection(beans)) {
            return null;
        }
        return (MetadataStructureSuperBean)SuperBeanRefUtil.resolveReference(beans, (MaintainableRefBean)ref);
    }

    public Set<MetadataStructureSuperBean> getMetadataStructureSuperBeans(MaintainableRefBean ref) {
        return this.getSuperBeans((StructureReferenceBean)new StructureReferenceBeanImpl(ref, SDMX_STRUCTURE_TYPE.MSD)).getMetadataStructures();
    }

    public ProvisionAgreementSuperBean getProvisionAgreementSuperBean(MaintainableRefBean ref) {
        Set<ProvisionAgreementSuperBean> beans = this.getProvisionAgreementSuperBeans(ref);
        if (!ObjectUtil.validCollection(beans)) {
            return null;
        }
        return (ProvisionAgreementSuperBean)SuperBeanRefUtil.resolveReference(beans, (MaintainableRefBean)ref);
    }

    public Set<ProvisionAgreementSuperBean> getProvisionAgreementSuperBeans(MaintainableRefBean ref) {
        return this.getSuperBeans((StructureReferenceBean)new StructureReferenceBeanImpl(ref, SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT)).getProvisions();
    }
}

