/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.junit5;

import com.epam.reportportal.annotations.Description;
import com.epam.reportportal.annotations.DisplayName;
import com.epam.reportportal.annotations.Issues;
import com.epam.reportportal.annotations.TestCaseId;
import com.epam.reportportal.annotations.attribute.Attributes;
import com.epam.reportportal.junit5.ItemType;
import com.epam.reportportal.junit5.SystemAttributesFetcher;
import com.epam.reportportal.junit5.utils.ItemTreeUtils;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.service.item.TestCaseIdEntry;
import com.epam.reportportal.service.tree.TestItemTree;
import com.epam.reportportal.utils.AttributeParser;
import com.epam.reportportal.utils.IssueUtils;
import com.epam.reportportal.utils.ParameterUtils;
import com.epam.reportportal.utils.TestCaseIdUtils;
import com.epam.reportportal.utils.formatting.ExceptionUtils;
import com.epam.reportportal.utils.formatting.MarkdownUtils;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.Maybe;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.DisplayNameGenerator;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.DynamicTestInvocationContext;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.opentest4j.TestAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportPortalExtension
implements Extension,
BeforeAllCallback,
BeforeEachCallback,
InvocationInterceptor,
AfterTestExecutionCallback,
AfterAllCallback,
TestWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportPortalExtension.class);
    private static final Set<String> ASSUMPTION_CLASSES = new HashSet<String>(Arrays.asList(TestAbortedException.class.getCanonicalName(), "org.junit.AssumptionViolatedException"));
    private static final Predicate<Throwable> IS_ASSUMPTION = e -> Optional.ofNullable(e).map(Object::getClass).flatMap(c -> {
        Class clazz = c;
        do {
            if (!ASSUMPTION_CLASSES.contains(clazz.getCanonicalName())) continue;
            return Optional.of(clazz);
        } while ((clazz = clazz.getSuperclass()) != null);
        return Optional.empty();
    }).isPresent();
    public static final TestItemTree TEST_ITEM_TREE = new TestItemTree();
    public static final ReportPortal REPORT_PORTAL = ReportPortal.builder().build();
    private static final Map<String, Launch> launchMap = new ConcurrentHashMap<String, Launch>();
    private final Map<ExtensionContext, Maybe<String>> idMapping = new ConcurrentHashMap<ExtensionContext, Maybe<String>>();
    private final Map<ExtensionContext, Maybe<String>> testTemplates = new ConcurrentHashMap<ExtensionContext, Maybe<String>>();
    private final Map<ExtensionContext, List<ParameterResource>> testParameters = new ConcurrentHashMap<ExtensionContext, List<ParameterResource>>();
    private final Set<ExtensionContext> failedClassInits = Collections.newSetFromMap(new ConcurrentHashMap());
    public static final String DESCRIPTION_TEST_ERROR_FORMAT = "Error: \n%s";

    @Nonnull
    protected Optional<Maybe<String>> getItemId(@Nonnull ExtensionContext context) {
        return Optional.ofNullable(this.idMapping.get(context));
    }

    public void finish() {
        new ArrayList<String>(launchMap.keySet()).forEach(this::finish);
    }

    private void finish(String id) {
        Optional.ofNullable(launchMap.remove(id)).ifPresent(ReportPortalExtension::finish);
    }

    private static void finish(Launch launch) {
        FinishExecutionRQ rq = new FinishExecutionRQ();
        rq.setEndTime(Calendar.getInstance().getTime());
        launch.finish(rq);
    }

    private static Thread getShutdownHook(String launchId) {
        return new Thread(() -> Optional.ofNullable(launchMap.remove(launchId)).ifPresent(ReportPortalExtension::finish));
    }

    protected StartLaunchRQ buildStartLaunchRq(ListenerParameters parameters) {
        StartLaunchRQ rq = new StartLaunchRQ();
        rq.setMode(parameters.getLaunchRunningMode());
        rq.setDescription(parameters.getDescription());
        rq.setName(parameters.getLaunchName());
        HashSet<ItemAttributesRQ> attributes = new HashSet<ItemAttributesRQ>(parameters.getAttributes());
        attributes.addAll(SystemAttributesFetcher.collectSystemAttributes(parameters.getSkippedAnIssue()));
        rq.setAttributes(attributes);
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setRerun(parameters.isRerun());
        rq.setRerunOf(StringUtils.isNotBlank((CharSequence)parameters.getRerunOf()) ? parameters.getRerunOf() : null);
        return rq;
    }

    protected ReportPortal getReporter() {
        return REPORT_PORTAL;
    }

    protected String getLaunchId(ExtensionContext context) {
        return context.getRoot().getUniqueId();
    }

    protected Launch getLaunch(ExtensionContext context) {
        return launchMap.computeIfAbsent(this.getLaunchId(context), id -> {
            ReportPortal rp = this.getReporter();
            ListenerParameters params = rp.getParameters();
            StartLaunchRQ rq = this.buildStartLaunchRq(params);
            Launch launch = rp.newLaunch(rq);
            Runtime.getRuntime().addShutdownHook(ReportPortalExtension.getShutdownHook(id));
            Maybe launchIdResponse = launch.start();
            if (params.isCallbackReportingEnabled()) {
                TEST_ITEM_TREE.setLaunchId(launchIdResponse);
            }
            return launch;
        });
    }

    public void beforeAll(ExtensionContext context) {
        this.getLaunch(context);
        this.startTestItem(context, ItemType.SUITE);
    }

    protected void finishTemplates(ExtensionContext parentContext) {
        Collection children;
        HashSet<ExtensionContext> parents = new HashSet<ExtensionContext>();
        parents.add(parentContext);
        ArrayList templates = new ArrayList();
        while (!(children = (Collection)this.testTemplates.keySet().stream().filter(c -> c.getParent().map(parents::contains).orElse(false)).collect(Collectors.toSet())).isEmpty()) {
            templates.addAll(children);
            parents.clear();
            parents.addAll(children);
        }
        Collections.reverse(templates);
        templates.forEach(this::finishTemplate);
    }

    public void afterAll(ExtensionContext context) {
        this.finishTemplates(context);
        this.finishTestItem(context);
    }

    public void beforeEach(ExtensionContext context) {
        context.getParent().ifPresent(this::startTemplate);
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext parentContext) throws Throwable {
        Maybe<String> id = this.startBeforeAfter((Method)invocationContext.getExecutable(), parentContext, parentContext, ItemType.BEFORE_CLASS);
        this.finishBeforeAll(invocation, invocationContext, parentContext, id);
    }

    public <T> T interceptTestClassConstructor(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Constructor<T>> invocationContext, ExtensionContext parentContext) throws Throwable {
        try {
            return (T)invocation.proceed();
        }
        catch (Throwable cause) {
            this.failedClassInits.add(parentContext);
            throw cause;
        }
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext context) throws Throwable {
        ExtensionContext parentContext = context.getParent().orElse(context.getRoot());
        Maybe<String> id = this.startBeforeAfter((Method)invocationContext.getExecutable(), parentContext, context, ItemType.BEFORE_METHOD);
        this.finishBeforeEach(invocation, invocationContext, context, id);
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext parentContext) throws Throwable {
        Maybe<String> id = this.startBeforeAfter((Method)invocationContext.getExecutable(), parentContext, parentContext, ItemType.AFTER_CLASS);
        this.finishBeforeAfter(invocation, parentContext, id);
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext context) throws Throwable {
        ExtensionContext parentContext = context.getParent().orElse(context.getRoot());
        Maybe<String> id = this.startBeforeAfter((Method)invocationContext.getExecutable(), parentContext, context, ItemType.AFTER_METHOD);
        this.finishBeforeAfter(invocation, context, id);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.startTestItem(extensionContext, invocationContext.getArguments(), ItemType.STEP);
        invocation.proceed();
    }

    public <T> T interceptTestFactoryMethod(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.startTestItem(extensionContext, invocationContext.getArguments(), ItemType.SUITE);
        return (T)invocation.proceed();
    }

    @Nonnull
    protected ItemStatus getExecutionStatus(@Nonnull ExtensionContext context, @Nullable Throwable throwable) {
        if (throwable == null) {
            return ItemStatus.PASSED;
        }
        this.sendStackTraceToRP(throwable);
        return IS_ASSUMPTION.test(throwable) ? ItemStatus.SKIPPED : ItemStatus.FAILED;
    }

    @Nonnull
    protected ItemStatus getExecutionStatus(@Nonnull ExtensionContext context) {
        return context.getExecutionException().map(t -> this.getExecutionStatus(context, (Throwable)t)).orElse(ItemStatus.PASSED);
    }

    public void interceptDynamicTest(InvocationInterceptor.Invocation<Void> invocation, DynamicTestInvocationContext invocationContext, ExtensionContext extensionContext) throws Throwable {
        Optional parent = extensionContext.getParent();
        if (parent.map(p -> !this.idMapping.containsKey(p)).orElse(false).booleanValue()) {
            ExtensionContext p2;
            ArrayList<Object> parents = new ArrayList<Object>();
            parents.add(parent.get());
            while ((parent = ((ExtensionContext)parents.get(parents.size() - 1)).getParent()).isPresent() && !this.idMapping.containsKey(p2 = (ExtensionContext)parent.get())) {
                parents.add(p2);
            }
            Collections.reverse(parents);
            parents.forEach(this::startTemplate);
        }
        this.startTestItem(extensionContext, ItemType.STEP);
        try {
            invocation.proceed();
            this.finishTest(extensionContext, ItemStatus.PASSED);
        }
        catch (Throwable throwable) {
            this.finishTest(extensionContext, this.getExecutionStatus(extensionContext, throwable));
            throw throwable;
        }
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.startTestItem(extensionContext, invocationContext.getArguments(), ItemType.STEP);
        invocation.proceed();
    }

    public void afterTestExecution(ExtensionContext context) {
        this.finishTemplates(context);
        this.finishTest(context, this.getExecutionStatus(context));
    }

    public void testDisabled(ExtensionContext context, Optional<String> reason) {
        if (Boolean.parseBoolean(System.getProperty("reportDisabledTests"))) {
            ItemType itemType = ItemType.STEP;
            String description = reason.map(r -> {
                String rawDescription = this.createStepDescription(context, itemType);
                return StringUtils.isNotBlank((CharSequence)rawDescription) ? MarkdownUtils.asTwoParts((String)r, (String)rawDescription) : r;
            }).orElse(null);
            this.startTestItem(context, Collections.emptyList(), itemType, description, null);
            this.finishTest(context, ItemStatus.SKIPPED);
        }
    }

    public void testFailed(ExtensionContext context, Throwable cause) {
        context.getParent().ifPresent(parent -> {
            if (this.failedClassInits.contains(parent)) {
                this.startTestItem(context, ItemType.STEP);
                this.sendStackTraceToRP(cause);
                this.finishTest(context, ItemStatus.FAILED);
            }
        });
    }

    protected void finishBeforeAll(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext context, Maybe<String> id) throws Throwable {
        Date startTime = Calendar.getInstance().getTime();
        try {
            this.finishBeforeAfter(invocation, context, id);
        }
        catch (Throwable throwable) {
            this.reportSkippedClassTests(invocationContext, context, startTime);
            throw throwable;
        }
    }

    protected void finishBeforeEach(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext context, Maybe<String> id) throws Throwable {
        Date startTime = Calendar.getInstance().getTime();
        try {
            this.finishBeforeAfter(invocation, context, id);
        }
        catch (Throwable throwable) {
            this.reportSkippedStep(invocationContext, context, throwable, startTime);
            throw throwable;
        }
    }

    private void finishBeforeAfter(InvocationInterceptor.Invocation<Void> invocation, ExtensionContext context, Maybe<String> id) throws Throwable {
        try {
            invocation.proceed();
        }
        catch (Throwable throwable) {
            this.finishBeforeAfter(context, id, this.getExecutionStatus(context, throwable));
            throw throwable;
        }
        this.finishBeforeAfter(context, id, ItemStatus.PASSED);
    }

    private void finishBeforeAfter(ExtensionContext context, Maybe<String> id, ItemStatus status) {
        Launch launch = this.getLaunch(context);
        launch.finishTestItem(id, this.buildFinishTestItemRq(context, status));
    }

    protected void startTemplate(ExtensionContext parentContext) {
        if (!this.idMapping.containsKey(parentContext)) {
            this.startTestItem(parentContext, ItemType.TEMPLATE);
        }
    }

    protected void startTestItem(ExtensionContext context, ItemType type) {
        this.startTestItem(context, Collections.emptyList(), type);
    }

    protected void startTestItem(ExtensionContext context, List<Object> arguments, ItemType type) {
        this.startTestItem(context, arguments, type, null, null);
    }

    protected void startTestItem(@Nonnull ExtensionContext context, @Nonnull List<Object> arguments, @Nonnull ItemType itemType, @Nullable String description, @Nullable Date startTime) {
        this.idMapping.computeIfAbsent(context, c -> {
            TestItemTree.TestItemLeaf leaf;
            Maybe itemId;
            StartTestItemRQ rq = this.buildStartStepRq((ExtensionContext)c, arguments, itemType, description, startTime);
            Launch launch = this.getLaunch((ExtensionContext)c);
            Maybe parentId = c.getParent().flatMap(parent -> Optional.ofNullable(this.idMapping.get(parent))).orElse(null);
            if (parentId == null) {
                itemId = launch.startTestItem(rq);
                leaf = TestItemTree.createTestItemLeaf((Maybe)itemId);
            } else {
                itemId = launch.startTestItem(parentId, rq);
                leaf = TestItemTree.createTestItemLeaf((Maybe)parentId, (Maybe)itemId);
            }
            if (this.getReporter().getParameters().isCallbackReportingEnabled()) {
                TEST_ITEM_TREE.getTestItems().put(ItemTreeUtils.createItemTreeKey(rq.getName()), leaf);
            }
            if (ItemType.TEMPLATE == itemType) {
                this.testTemplates.put((ExtensionContext)c, (Maybe<String>)itemId);
            }
            return itemId;
        });
    }

    protected Maybe<String> startBeforeAfter(Method method, ExtensionContext parentContext, ExtensionContext context, ItemType itemType) {
        Launch launch = this.getLaunch(context);
        StartTestItemRQ rq = this.buildStartConfigurationRq(method, parentContext, context, itemType);
        return this.getItemId(parentContext).map(pid -> launch.startTestItem(pid, rq)).orElseGet(() -> launch.startTestItem(rq));
    }

    protected void finishTemplate(@Nonnull ExtensionContext context) {
        Launch launch = this.getLaunch(context);
        Maybe<String> templateId = this.testTemplates.remove(context);
        launch.finishTestItem(templateId, this.buildFinishTestItemRq(context, null));
        this.idMapping.remove(context);
    }

    protected void finishTestItem(@Nonnull ExtensionContext context) {
        this.finishTestItem(context, this.buildFinishTestItemRq(context, null));
    }

    protected void finishTestItem(@Nonnull ExtensionContext context, @Nullable ItemStatus status) {
        this.finishTestItem(context, this.buildFinishTestItemRq(context, status));
    }

    protected void finishTest(@Nonnull ExtensionContext context, @Nullable ItemStatus status) {
        this.finishTestItem(context, this.buildFinishTestRq(context, status));
    }

    protected void finishTestItem(@Nonnull ExtensionContext context, @Nonnull FinishTestItemRQ rq) {
        Launch launch = this.getLaunch(context);
        Maybe<String> id = this.idMapping.remove(context);
        Maybe finishResponse = launch.finishTestItem(id, rq);
        if (this.getReporter().getParameters().isCallbackReportingEnabled()) {
            Optional.ofNullable(TEST_ITEM_TREE.getTestItems().get(ItemTreeUtils.createItemTreeKey(context))).ifPresent(itemLeaf -> itemLeaf.setFinishResponse(finishResponse));
        }
    }

    protected TestCaseIdEntry getTestCaseId(@Nonnull Method method, @Nonnull String codeRef, @Nonnull List<Object> arguments, @Nullable Object instance) {
        TestCaseId caseId = method.getAnnotation(TestCaseId.class);
        TestCaseIdEntry id = TestCaseIdUtils.getTestCaseId((TestCaseId)caseId, (Executable)method, (String)codeRef, arguments, (Object)instance);
        if (id == null) {
            return null;
        }
        return id.getId().endsWith("[]") ? new TestCaseIdEntry(id.getId().substring(0, id.getId().length() - 2)) : id;
    }

    private static String getCodeRef(@Nonnull Method method) {
        return method.getDeclaringClass().getCanonicalName() + "." + method.getName();
    }

    private static String appendSuffixIfNotEmpty(String str, @Nonnull String suffix) {
        return str + (StringUtils.isNotBlank((CharSequence)suffix) ? "$" + suffix : "");
    }

    @Nonnull
    private String getCodeRef(@Nonnull ExtensionContext context, @Nonnull String currentCodeRef) {
        return context.getTestMethod().map(m -> ReportPortalExtension.appendSuffixIfNotEmpty(ReportPortalExtension.getCodeRef(m), currentCodeRef)).orElseGet(() -> context.getTestClass().map(c -> ReportPortalExtension.appendSuffixIfNotEmpty(c.getCanonicalName(), currentCodeRef)).orElseGet(() -> {
            String newCodeRef = ReportPortalExtension.appendSuffixIfNotEmpty(context.getDisplayName(), currentCodeRef);
            return context.getParent().map(c -> this.getCodeRef((ExtensionContext)c, newCodeRef)).orElse(newCodeRef);
        }));
    }

    @Nonnull
    protected String getCodeRef(@Nonnull ExtensionContext context) {
        return this.getCodeRef(context, "");
    }

    protected Optional<Method> getTestMethod(ExtensionContext context) {
        return Optional.ofNullable(context.getTestMethod().orElseGet(() -> context.getParent().flatMap(this::getTestMethod).orElse(null)));
    }

    @Nonnull
    protected Set<ItemAttributesRQ> getAttributes(@Nonnull AnnotatedElement annotatedElement) {
        return Optional.ofNullable(annotatedElement.getAnnotation(Attributes.class)).map(AttributeParser::retrieveAttributes).orElse(Collections.emptySet());
    }

    @Nonnull
    protected List<ParameterResource> getParameters(@Nonnull Method method, List<Object> arguments) {
        return ParameterUtils.getParameters((Executable)method, arguments);
    }

    private Optional<Method> getOptionalTestMethod(ExtensionContext context) {
        Optional optionalMethod = context.getTestMethod();
        if (!optionalMethod.isPresent()) {
            Optional parentContext = context.getParent();
            if (!parentContext.isPresent()) {
                return Optional.empty();
            }
            return ((ExtensionContext)parentContext.get()).getTestMethod();
        }
        return optionalMethod;
    }

    private String getMethodName(String value) {
        return value.length() > 1024 ? value.substring(0, 1021) + "..." : value;
    }

    protected String createStepName(ExtensionContext context, ItemType itemType) {
        String name = context.getDisplayName();
        String defaultValue = this.getMethodName(name);
        if (itemType != ItemType.STEP) {
            return defaultValue;
        }
        Optional<Method> optionalMethod = this.getOptionalTestMethod(context);
        if (!optionalMethod.isPresent()) {
            return defaultValue;
        }
        Method method = optionalMethod.get();
        DisplayName displayNameFromMethod = method.getAnnotation(DisplayName.class);
        if (displayNameFromMethod != null) {
            return this.getMethodName(displayNameFromMethod.value());
        }
        DisplayName displayNameFromClass = method.getDeclaringClass().getAnnotation(DisplayName.class);
        if (displayNameFromClass != null) {
            return this.getMethodName(displayNameFromClass.value());
        }
        return defaultValue;
    }

    @Nonnull
    protected StartTestItemRQ buildStartStepRq(@Nonnull ExtensionContext context, @Nonnull List<Object> arguments, @Nonnull ItemType itemType, @Nullable String description, @Nullable Date startTime) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setStartTime(Optional.ofNullable(startTime).orElseGet(Calendar.getInstance()::getTime));
        rq.setName(this.createStepName(context, itemType));
        rq.setDescription(Optional.ofNullable(description).orElseGet(() -> this.createStepDescription(context, itemType)));
        rq.setType(itemType == ItemType.TEMPLATE ? ItemType.SUITE.name() : itemType.name());
        String codeRef = this.getCodeRef(context);
        rq.setCodeRef(codeRef);
        rq.setAttributes(context.getTags().stream().map(it -> new ItemAttributesRQ(null, it)).collect(Collectors.toSet()));
        if (ItemType.SUITE == itemType) {
            context.getTestClass().ifPresent(c -> rq.getAttributes().addAll(this.getAttributes((AnnotatedElement)c)));
        }
        Optional<Method> testMethod = this.getTestMethod(context);
        TestCaseIdEntry caseId = testMethod.map(m -> {
            rq.getAttributes().addAll(this.getAttributes((AnnotatedElement)m));
            rq.setParameters(this.getParameters((Method)m, arguments));
            return this.getTestCaseId((Method)m, codeRef, arguments, context.getTestInstance().orElse(null));
        }).orElseGet(() -> TestCaseIdUtils.getTestCaseId((String)codeRef, (List)arguments));
        if (ItemType.STEP == itemType) {
            this.testParameters.put(context, rq.getParameters());
        }
        rq.setTestCaseId((String)Optional.ofNullable(caseId).map(TestCaseIdEntry::getId).orElse(null));
        return rq;
    }

    @Nonnull
    protected StartTestItemRQ buildStartConfigurationRq(@Nonnull Method method, @Nonnull ExtensionContext parentContext, @Nonnull ExtensionContext context, @Nonnull ItemType itemType) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setStartTime(Calendar.getInstance().getTime());
        Optional testClass = context.getTestClass();
        if (testClass.isPresent()) {
            rq.setName(this.createConfigurationName((Class)testClass.get(), method));
            rq.setDescription(this.createConfigurationDescription((Class)testClass.get(), method));
        } else {
            rq.setName(this.createConfigurationName(method.getDeclaringClass(), method));
            rq.setDescription(this.createConfigurationDescription(method.getDeclaringClass(), method));
        }
        Optional.ofNullable(context.getTags()).ifPresent(it -> rq.setAttributes(it.stream().map(tag -> new ItemAttributesRQ(null, tag)).collect(Collectors.toSet())));
        rq.setType(itemType.name());
        rq.setRetry(Boolean.valueOf(false));
        String codeRef = method.getDeclaringClass().getCanonicalName() + "." + method.getName();
        rq.setCodeRef(codeRef);
        TestCaseIdEntry caseId = Optional.ofNullable(method.getAnnotation(TestCaseId.class)).map(TestCaseId::value).map(TestCaseIdEntry::new).orElseGet(() -> TestCaseIdUtils.getTestCaseId((String)codeRef, Collections.emptyList()));
        rq.setTestCaseId((String)Optional.ofNullable(caseId).map(TestCaseIdEntry::getId).orElse(null));
        return rq;
    }

    protected void createSkippedSteps(ExtensionContext context, Throwable cause) {
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishTestRq(@Nonnull ExtensionContext context, @Nullable ItemStatus status) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        ItemStatus myStatus = Optional.ofNullable(status).orElseGet(() -> this.getExecutionStatus(context));
        Optional myException = context.getExecutionException();
        if (myStatus != ItemStatus.PASSED && myException.isPresent()) {
            String stepDescription = this.createStepDescription(context, ItemType.STEP);
            String stackTrace = String.format(DESCRIPTION_TEST_ERROR_FORMAT, ExceptionUtils.getStackTrace((Throwable)((Throwable)myException.get()), (Throwable)new Throwable()));
            String description = StringUtils.isNotBlank((CharSequence)stepDescription) ? MarkdownUtils.asTwoParts((String)stepDescription, (String)stackTrace) : stackTrace;
            rq.setDescription(description);
        }
        rq.setIssue(this.getIssue(context));
        Optional.ofNullable(status).ifPresent(s -> rq.setStatus(s.name()));
        rq.setEndTime(Calendar.getInstance().getTime());
        return rq;
    }

    @Nullable
    protected Issue getIssue(@Nonnull ExtensionContext context) {
        String stepName = this.createStepName(context, ItemType.STEP);
        List parameters = this.testParameters.containsKey(context) ? this.testParameters.remove(context) : Collections.emptyList();
        return this.getOptionalTestMethod(context).map(m -> Optional.ofNullable(m.getAnnotation(Issues.class)).map(i -> IssueUtils.createIssue((Issues)i, (String)stepName, (List)parameters)).orElseGet(() -> IssueUtils.createIssue((com.epam.reportportal.annotations.Issue)m.getAnnotation(com.epam.reportportal.annotations.Issue.class), (String)stepName, (List)parameters))).orElse(null);
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishTestItemRq(@Nonnull ExtensionContext context, @Nullable ItemStatus status) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        Optional.ofNullable(status).ifPresent(s -> rq.setStatus(s.name()));
        rq.setEndTime(Calendar.getInstance().getTime());
        return rq;
    }

    @Nonnull
    protected String createConfigurationName(@Nonnull Class<?> testClass, @Nonnull Method method) {
        org.junit.jupiter.api.DisplayName displayName = method.getDeclaredAnnotation(org.junit.jupiter.api.DisplayName.class);
        if (displayName != null) {
            return displayName.value();
        }
        DisplayNameGeneration displayNameGenerator = method.getDeclaredAnnotation(DisplayNameGeneration.class);
        if (displayNameGenerator == null) {
            displayNameGenerator = testClass.getDeclaredAnnotation(DisplayNameGeneration.class);
        }
        if (displayNameGenerator != null) {
            Class generatorClass = displayNameGenerator.value();
            try {
                DisplayNameGenerator generator = (DisplayNameGenerator)generatorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                return generator.generateDisplayNameForMethod(testClass, method);
            }
            catch (Exception e) {
                LOGGER.error("Unable instantiate a display name generator. Name generation skipped.", (Throwable)e);
            }
        }
        return method.getName() + "()";
    }

    @Nonnull
    protected String createStepDescription(ExtensionContext context, ItemType itemType) {
        String defaultValue = "";
        if (itemType != ItemType.STEP) {
            return defaultValue;
        }
        Optional<Method> optionalMethod = this.getOptionalTestMethod(context);
        if (!optionalMethod.isPresent()) {
            return defaultValue;
        }
        Method method = optionalMethod.get();
        Description descriptionFromMethod = method.getAnnotation(Description.class);
        if (descriptionFromMethod != null) {
            return descriptionFromMethod.value();
        }
        Description descriptionFromClass = method.getDeclaringClass().getAnnotation(Description.class);
        if (descriptionFromClass != null) {
            return descriptionFromClass.value();
        }
        return defaultValue;
    }

    protected String createConfigurationDescription(Class<?> testClass, Method method) {
        return "";
    }

    protected void reportSkippedStep(ReflectiveInvocationContext<Method> invocationContext, ExtensionContext context, Throwable throwable, Date eventTime) {
        Date skipStartTime = Calendar.getInstance().getTime();
        if (skipStartTime.after(eventTime)) {
            skipStartTime = new Date(skipStartTime.getTime() - 1L);
        }
        ItemType itemType = ItemType.STEP;
        this.startTestItem(context, invocationContext.getArguments(), itemType, this.createStepDescription(context, itemType), skipStartTime);
        this.createSkippedSteps(context, throwable);
        FinishTestItemRQ finishRq = this.buildFinishTestItemRq(context, ItemStatus.SKIPPED);
        finishRq.setIssue(Launch.NOT_ISSUE);
        this.finishTestItem(context, finishRq);
    }

    protected void reportSkippedClassTests(ReflectiveInvocationContext<Method> invocationContext, ExtensionContext context, Date eventTime) {
    }

    protected void sendStackTraceToRP(Throwable cause) {
        ReportPortal.emitLog(itemUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setItemUuid(itemUuid);
            rq.setLevel("ERROR");
            rq.setLogTime(Calendar.getInstance().getTime());
            if (cause != null) {
                rq.setMessage(ExceptionUtils.getStackTrace((Throwable)cause, (Throwable)new Throwable()));
            } else {
                rq.setMessage("Test has failed without exception");
            }
            rq.setLogTime(Calendar.getInstance().getTime());
            return rq;
        });
    }
}

