/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.step;

import com.epam.reportportal.listeners.ItemStatus;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StepRequestUtils {
    private StepRequestUtils() {
    }

    @Nonnull
    public static StartTestItemRQ buildStartStepRequest(@Nonnull String name, @Nullable String description) {
        StartTestItemRQ request = new StartTestItemRQ();
        Optional.ofNullable(description).filter(d -> !d.isEmpty()).ifPresent(arg_0 -> ((StartTestItemRQ)request).setDescription(arg_0));
        request.setName(name);
        request.setStartTime(Calendar.getInstance().getTime());
        request.setType("STEP");
        request.setHasStats(false);
        return request;
    }

    @Nonnull
    public static FinishTestItemRQ buildFinishTestItemRequest(@Nonnull ItemStatus status, @Nonnull Date endTime) {
        FinishTestItemRQ finishTestItemRQ = new FinishTestItemRQ();
        finishTestItemRQ.setStatus(status.name());
        finishTestItemRQ.setEndTime(endTime);
        return finishTestItemRQ;
    }

    @Nonnull
    public static FinishTestItemRQ buildFinishTestItemRequest(@Nonnull ItemStatus status) {
        return StepRequestUtils.buildFinishTestItemRequest(status, Calendar.getInstance().getTime());
    }
}

