/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.service.Launch;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.Maybe;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public class LoggingContext {
    private static final ThreadLocal<Pair<Long, Deque<LoggingContext>>> CONTEXT_THREAD_LOCAL = new InheritableThreadLocal<Pair<Long, Deque<LoggingContext>>>();
    private static final Set<Long> THREAD_IDS = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Maybe<String> itemUuid;

    @Nonnull
    private static Deque<LoggingContext> createContext() {
        Long threadKey = Thread.currentThread().getId();
        if (!THREAD_IDS.contains(threadKey) || CONTEXT_THREAD_LOCAL.get() == null) {
            ArrayDeque<LoggingContext> context = new ArrayDeque<LoggingContext>();
            CONTEXT_THREAD_LOCAL.set((Pair<Long, Deque<LoggingContext>>)Pair.of((Object)threadKey, context));
            THREAD_IDS.add(threadKey);
            return context;
        }
        return (Deque)CONTEXT_THREAD_LOCAL.get().getValue();
    }

    @Nullable
    private static Deque<LoggingContext> getContext() {
        Long threadKey = Thread.currentThread().getId();
        return Optional.ofNullable(CONTEXT_THREAD_LOCAL.get()).filter(ctx -> threadKey.equals(ctx.getKey())).map(Pair::getValue).orElse(null);
    }

    @Nullable
    public static LoggingContext context() {
        return Optional.ofNullable(CONTEXT_THREAD_LOCAL.get()).map(Pair::getValue).map(Deque::peek).orElse(null);
    }

    @Nonnull
    public static LoggingContext init(@Nonnull Maybe<String> itemUuid) {
        LoggingContext context = new LoggingContext(itemUuid);
        LoggingContext.createContext().push(context);
        return context;
    }

    public static void dispose() {
        Optional.ofNullable(LoggingContext.getContext()).ifPresent(Deque::poll);
    }

    LoggingContext(@Nonnull Maybe<String> itemUuid) {
        this.itemUuid = itemUuid;
    }

    public void emit(@Nonnull Maybe<String> logItemUuid, @Nonnull Function<String, SaveLogRQ> logSupplier) {
        Launch launch = Launch.currentLaunch();
        if (launch == null) {
            return;
        }
        launch.log(logItemUuid, logSupplier);
    }

    public void emit(@Nonnull Function<String, SaveLogRQ> logSupplier) {
        this.emit(this.itemUuid, logSupplier);
    }
}

