/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.launch;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.LaunchIdLock;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.service.launch.AbstractJoinedLaunch;
import com.epam.reportportal.utils.Waiter;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.launch.LaunchResource;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.disposables.Disposable;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecondaryLaunch
extends AbstractJoinedLaunch {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecondaryLaunch.class);
    private final ReportPortalClient client;

    public SecondaryLaunch(ReportPortalClient rpClient, ListenerParameters parameters, Maybe<String> launch, ExecutorService executorService, LaunchIdLock launchIdLock, String instanceUuid) {
        super(rpClient, parameters, launch, executorService, launchIdLock, instanceUuid);
        this.client = rpClient;
    }

    private void waitForLaunchStart() {
        new Waiter("Wait for Launch start").pollingEvery(1L, TimeUnit.SECONDS).duration(this.getParameters().getClientJoinLaunchTimeout(), TimeUnit.MILLISECONDS).timeoutFail().till(new Callable<Boolean>(){
            private volatile Boolean result = null;
            private final Queue<Disposable> disposables = new ConcurrentLinkedQueue<Disposable>();

            @Override
            public Boolean call() {
                if (this.result == null) {
                    this.disposables.add(SecondaryLaunch.this.getLaunch().subscribe(uuid -> {
                        Maybe<LaunchResource> maybeRs = SecondaryLaunch.this.client.getLaunchByUuid((String)uuid);
                        if (maybeRs != null) {
                            this.disposables.add(maybeRs.subscribe(launchResource -> {
                                this.result = Boolean.TRUE;
                            }, throwable -> LOGGER.debug("Unable to get a Launch: {}", (Object)throwable.getLocalizedMessage(), throwable)));
                        } else {
                            LOGGER.debug("RP Client returned 'null' response on get Launch by UUID call");
                        }
                    }));
                } else {
                    Disposable disposable;
                    while ((disposable = this.disposables.poll()) != null) {
                        disposable.dispose();
                    }
                }
                return this.result;
            }
        });
    }

    @Override
    @Nonnull
    public Maybe<String> start() {
        if (!this.getParameters().isAsyncReporting()) {
            this.waitForLaunchStart();
        }
        return super.start(false);
    }

    @Override
    public void finish(FinishExecutionRQ request) {
        this.waitForItemsCompletion(Completable.concat(this.queue.getOrCompute(this.getLaunch()).getChildren()));
        this.stopRunning();
        this.lock.finishInstanceUuid(this.uuid);
        this.virtualItemDisposables.removeIf(d -> {
            d.dispose();
            return true;
        });
    }
}

