/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.logs;

import com.epam.reportportal.service.Launch;
import com.epam.ta.reportportal.ws.model.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import io.reactivex.functions.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LaunchLoggingCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(Launch.class);
    public static final Consumer<OperationCompletionRS> LOG_SUCCESS = rs -> LOGGER.debug(rs.getResultMessage());
    public static final Consumer<Throwable> LOG_ERROR = rs -> LOGGER.error("[{}] ReportPortal execution error", (Object)Thread.currentThread().getId(), rs);

    private LaunchLoggingCallback() {
        throw new IllegalStateException("Static only class");
    }

    public static Consumer<EntryCreatedAsyncRS> logCreated(String entry) {
        return rs -> LOGGER.debug("ReportPortal {} with ID '{}' has been created", (Object)entry, (Object)rs.getId());
    }
}

