/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.listeners.ItemStatus;
import javax.annotation.Nullable;

public class StatusEvaluation {
    private StatusEvaluation() {
        throw new IllegalStateException("Static only class");
    }

    @Nullable
    public static ItemStatus evaluateStatus(@Nullable ItemStatus currentStatus, @Nullable ItemStatus childStatus) {
        if (childStatus == null) {
            return currentStatus;
        }
        if (currentStatus == null) {
            return childStatus;
        }
        switch (childStatus) {
            case PASSED: {
                switch (currentStatus) {
                    case SKIPPED: 
                    case STOPPED: 
                    case INFO: 
                    case WARN: {
                        return childStatus;
                    }
                }
                return currentStatus;
            }
            case SKIPPED: 
            case STOPPED: 
            case INFO: 
            case WARN: {
                return currentStatus;
            }
            case CANCELLED: {
                switch (currentStatus) {
                    case SKIPPED: 
                    case STOPPED: 
                    case INFO: 
                    case WARN: 
                    case PASSED: {
                        return ItemStatus.CANCELLED;
                    }
                }
                return currentStatus;
            }
            case INTERRUPTED: {
                switch (currentStatus) {
                    case SKIPPED: 
                    case STOPPED: 
                    case INFO: 
                    case WARN: 
                    case PASSED: 
                    case CANCELLED: {
                        return ItemStatus.INTERRUPTED;
                    }
                }
                return currentStatus;
            }
        }
        return childStatus;
    }
}

