/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.reflect;

import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AccessibleField {
    private final Field f;
    private final Object bean;

    AccessibleField(@Nonnull Object bean, @Nonnull Field f) {
        this.bean = bean;
        this.f = f;
    }

    @Nonnull
    public Class<?> getType() {
        return this.f.getType();
    }

    public void setValue(@Nullable Object value) {
        try {
            this.f.set(this.bean, value);
        }
        catch (IllegalAccessException accessException) {
            this.f.setAccessible(true);
            try {
                this.f.set(this.bean, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
        }
    }

    @Nullable
    public Object getValue() {
        try {
            return this.f.get(this.bean);
        }
        catch (IllegalAccessException accessException) {
            this.f.setAccessible(true);
            try {
                return this.f.get(this.bean);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
        }
    }
}

