/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.log4j.appender;

import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.utils.files.Utils;
import com.epam.ta.reportportal.log4j.appender.Util;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.UUID;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;

@Plugin(name="ReportPortalLog4j2Appender", category="Core", elementType="appender", printObject=true)
public class ReportPortalLog4j2Appender
extends AbstractAppender {
    protected ReportPortalLog4j2Appender(String name, Filter filter, Layout<? extends Serializable> layout) {
        super(name, filter, layout, true, Property.EMPTY_ARRAY);
    }

    @PluginFactory
    public static ReportPortalLog4j2Appender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="filter") Filter filter, @PluginElement(value="layout") Layout<? extends Serializable> layout) {
        if (name == null) {
            LOGGER.error("No name provided for ReportPortalLog4j2Appender");
            return null;
        }
        if (layout == null) {
            LOGGER.error("No layout provided for ReportPortalLog4j2Appender");
            return null;
        }
        return new ReportPortalLog4j2Appender(name, filter, layout);
    }

    public void append(LogEvent logEvent) {
        LogEvent event = logEvent.toImmutable();
        if (null == event.getMessage()) {
            return;
        }
        if (Util.isInternal(event.getLoggerName())) {
            return;
        }
        ReportPortal.emitLog(itemUuid -> {
            SaveLogRQ request = new SaveLogRQ();
            request.setItemUuid(itemUuid);
            request.setLogTime(new Date(event.getTimeMillis()));
            request.setLevel(event.getLevel().name());
            Message eventMessage = event.getMessage();
            TypeAwareByteSource byteSource = null;
            String message = "";
            try {
                if (eventMessage instanceof ObjectMessage && eventMessage.getParameters().length > 0) {
                    Object objectMessage = eventMessage.getParameters()[0];
                    if (objectMessage instanceof ReportPortalMessage) {
                        ReportPortalMessage rpMessage = (ReportPortalMessage)objectMessage;
                        byteSource = rpMessage.getData();
                        message = rpMessage.getMessage();
                    } else if (objectMessage instanceof File) {
                        File file = (File)objectMessage;
                        byteSource = Utils.getFile((File)file);
                        message = "File reported";
                    } else if (null != objectMessage) {
                        message = objectMessage.toString();
                    }
                } else if (Util.MESSAGE_PARSER.supports(eventMessage.getFormattedMessage())) {
                    ReportPortalMessage rpMessage = Util.MESSAGE_PARSER.parse(eventMessage.getFormattedMessage());
                    message = rpMessage.getMessage();
                    byteSource = rpMessage.getData();
                } else {
                    message = new String(this.getLayout().toByteArray(event), StandardCharsets.UTF_8);
                }
                if (null != byteSource) {
                    SaveLogRQ.File file = new SaveLogRQ.File();
                    file.setName(UUID.randomUUID().toString());
                    file.setContentType(byteSource.getMediaType());
                    file.setContent(byteSource.read());
                    request.setFile(file);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            request.setMessage(message);
            return request;
        });
    }
}

