/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public class EPCompiledManifest
implements Serializable {
    private final String compilerVersion;
    private final String moduleProviderClassName;
    private final String queryProviderClassName;
    private final boolean targetHA;

    public EPCompiledManifest(String compilerVersion, String moduleProviderClassName, String queryProviderClassName, boolean targetHA) {
        this.compilerVersion = compilerVersion;
        this.moduleProviderClassName = moduleProviderClassName;
        this.queryProviderClassName = queryProviderClassName;
        this.targetHA = targetHA;
    }

    public String getCompilerVersion() {
        return this.compilerVersion;
    }

    public String getModuleProviderClassName() {
        return this.moduleProviderClassName;
    }

    public String getQueryProviderClassName() {
        return this.queryProviderClassName;
    }

    public boolean isTargetHA() {
        return this.targetHA;
    }

    public void write(DataOutput output) throws IOException {
        output.writeUTF(this.compilerVersion);
        this.writeNullableString(this.moduleProviderClassName, output);
        this.writeNullableString(this.queryProviderClassName, output);
        output.writeBoolean(this.targetHA);
    }

    public static EPCompiledManifest read(DataInput input) throws IOException {
        String compilerVersion = input.readUTF();
        String moduleClassName = EPCompiledManifest.readNullableString(input);
        String queryClassName = EPCompiledManifest.readNullableString(input);
        boolean targetHA = input.readBoolean();
        return new EPCompiledManifest(compilerVersion, moduleClassName, queryClassName, targetHA);
    }

    private void writeNullableString(String value, DataOutput output) throws IOException {
        if (value == null) {
            output.writeBoolean(false);
            return;
        }
        output.writeBoolean(true);
        output.writeUTF(value);
    }

    private static String readNullableString(DataInput input) throws IOException {
        boolean hasValue = input.readBoolean();
        if (!hasValue) {
            return null;
        }
        return input.readUTF();
    }
}

