/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.annotation;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.annotation.Hint;
import com.espertech.esper.common.internal.epl.annotation.AnnotationException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public enum HintEnum {
    ITERATE_ONLY("ITERATE_ONLY", false, false, false),
    DISABLE_RECLAIM_GROUP("DISABLE_RECLAIM_GROUP", false, false, false),
    RECLAIM_GROUP_AGED("RECLAIM_GROUP_AGED", true, true, false),
    RECLAIM_GROUP_FREQ("RECLAIM_GROUP_FREQ", true, true, false),
    ENABLE_WINDOW_SUBQUERY_INDEXSHARE("ENABLE_WINDOW_SUBQUERY_INDEXSHARE", false, false, false),
    DISABLE_WINDOW_SUBQUERY_INDEXSHARE("DISABLE_WINDOW_SUBQUERY_INDEXSHARE", false, false, false),
    SET_NOINDEX("SET_NOINDEX", false, false, false),
    FORCE_NESTED_ITER("FORCE_NESTED_ITER", false, false, false),
    PREFER_MERGE_JOIN("PREFER_MERGE_JOIN", false, false, false),
    INDEX("INDEX", false, false, true),
    EXCLUDE_PLAN("EXCLUDE_PLAN", false, false, true),
    DISABLE_UNIQUE_IMPLICIT_IDX("DISABLE_UNIQUE_IMPLICIT_IDX", false, false, false),
    MAX_FILTER_WIDTH("MAX_FILTER_WIDTH", true, true, false),
    DISABLE_WHEREEXPR_MOVETO_FILTER("DISABLE_WHEREEXPR_MOVETO_FILTER", false, false, false),
    ENABLE_OUTPUTLIMIT_OPT("ENABLE_OUTPUTLIMIT_OPT", false, false, false),
    DISABLE_OUTPUTLIMIT_OPT("DISABLE_OUTPUTLIMIT_OPT", false, false, false),
    SILENT_DELETE("SILENT_DELETE", false, false, false);

    private final String value;
    private final boolean acceptsParameters;
    private final boolean requiresParameters;
    private final boolean requiresParentheses;

    private HintEnum(String value, boolean acceptsParameters, boolean requiresParameters, boolean requiresParentheses) {
        this.value = value.toUpperCase(Locale.ENGLISH);
        this.acceptsParameters = acceptsParameters;
        this.requiresParameters = acceptsParameters ? true : requiresParameters;
        this.requiresParentheses = requiresParentheses;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isAcceptsParameters() {
        return this.acceptsParameters;
    }

    public boolean isRequiresParameters() {
        return this.requiresParameters;
    }

    public Hint getHint(Annotation[] annotations) {
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Hint)) continue;
            Hint hintAnnotation = (Hint)annotation;
            try {
                Map<HintEnum, List<String>> setOfHints = HintEnum.validateGetListed(hintAnnotation);
                if (!setOfHints.containsKey((Object)this)) continue;
                return hintAnnotation;
            }
            catch (AnnotationException e) {
                throw new EPException("Invalid hint: " + e.getMessage(), e);
            }
        }
        return null;
    }

    public static Map<HintEnum, List<String>> validateGetListed(Annotation annotation) throws AnnotationException {
        if (!(annotation instanceof Hint)) {
            return Collections.emptyMap();
        }
        Hint hint = (Hint)annotation;
        String hintValueCaseNeutral = hint.value().trim();
        String hintValueUppercase = hintValueCaseNeutral.toUpperCase(Locale.ENGLISH);
        for (HintEnum val : HintEnum.values()) {
            String assignment;
            if (!val.getValue().equals(hintValueUppercase) || val.requiresParentheses) continue;
            HintEnum.validateParameters(val, hint.value().trim());
            List<Object> parameters = val.acceptsParameters ? ((assignment = HintEnum.getAssignedValue(hint.value().trim(), val.value)) == null ? Collections.emptyList() : Collections.singletonList(assignment)) : Collections.emptyList();
            return Collections.singletonMap(val, parameters);
        }
        String[] hints = HintEnum.splitCommaUnlessInParen(hint.value());
        HashMap<HintEnum, List<String>> listed = new HashMap<HintEnum, List<String>>();
        for (int i = 0; i < hints.length; ++i) {
            ArrayList<String> existing;
            String hintValUppercase = hints[i].trim().toUpperCase(Locale.ENGLISH);
            String hintValNeutralcase = hints[i].trim();
            HintEnum found = null;
            String parameter = null;
            for (HintEnum val : HintEnum.values()) {
                if (val.getValue().equals(hintValUppercase) && !val.requiresParentheses) {
                    found = val;
                    parameter = HintEnum.getAssignedValue(hint.value().trim(), val.value);
                    break;
                }
                if (val.requiresParentheses) {
                    int indexOpen = hintValUppercase.indexOf(40);
                    int indexClosed = hintValUppercase.lastIndexOf(41);
                    if (indexOpen != -1) {
                        String hintNameNoParen = hintValUppercase.substring(0, indexOpen);
                        if (val.getValue().equals(hintNameNoParen)) {
                            if (indexClosed == -1 || indexClosed < indexOpen) {
                                throw new AnnotationException("Hint '" + (Object)((Object)val) + "' mismatches parentheses");
                            }
                            if (indexClosed != hintValUppercase.length() - 1) {
                                throw new AnnotationException("Hint '" + (Object)((Object)val) + "' has additional text after parentheses");
                            }
                            found = val;
                            parameter = hintValNeutralcase.substring(indexOpen + 1, indexClosed);
                            break;
                        }
                    }
                    if (hintValUppercase.equals(val.getValue()) && indexOpen == -1) {
                        throw new AnnotationException("Hint '" + (Object)((Object)val) + "' requires additional parameters in parentheses");
                    }
                }
                if (hintValUppercase.indexOf(61) == -1) continue;
                String hintName = hintValUppercase.substring(0, hintValUppercase.indexOf(61));
                if (!val.getValue().equals(hintName.trim().toUpperCase(Locale.ENGLISH))) continue;
                found = val;
                parameter = HintEnum.getAssignedValue(hint.value().trim(), val.value);
                break;
            }
            if (found == null) {
                String hintName = hints[i].trim();
                if (hintName.indexOf(61) != -1) {
                    hintName = hintName.substring(0, hintName.indexOf(61));
                }
                throw new AnnotationException("Hint annotation value '" + hintName.trim() + "' is not one of the known values");
            }
            if (!found.requiresParentheses) {
                HintEnum.validateParameters(found, hintValUppercase);
            }
            if ((existing = (ArrayList<String>)listed.get((Object)found)) == null) {
                existing = new ArrayList<String>();
                listed.put(found, existing);
            }
            if (parameter == null) continue;
            existing.add(parameter);
        }
        return listed;
    }

    private static void validateParameters(HintEnum val, String hintVal) throws AnnotationException {
        if (val.isRequiresParameters() && hintVal.indexOf(61) == -1) {
            throw new AnnotationException("Hint '" + (Object)((Object)val) + "' requires a parameter value");
        }
        if (!val.isAcceptsParameters() && hintVal.indexOf(61) != -1) {
            throw new AnnotationException("Hint '" + (Object)((Object)val) + "' does not accept a parameter value");
        }
    }

    public String getHintAssignedValue(Hint annotation) {
        try {
            Map<HintEnum, List<String>> hintValues = HintEnum.validateGetListed(annotation);
            if (hintValues == null || !hintValues.containsKey((Object)this)) {
                return null;
            }
            return hintValues.get((Object)this).get(0);
        }
        catch (AnnotationException ex) {
            throw new EPException("Failed to interpret hint annotation: " + ex.getMessage(), ex);
        }
    }

    public List<String> getHintAssignedValues(Annotation[] annotations) {
        List<String> allHints = null;
        try {
            for (Annotation annotation : annotations) {
                Map<HintEnum, List<String>> hintValues = HintEnum.validateGetListed(annotation);
                if (hintValues == null || !hintValues.containsKey((Object)this)) continue;
                if (allHints == null) {
                    allHints = hintValues.get((Object)this);
                    continue;
                }
                allHints.addAll((Collection<String>)hintValues.get((Object)this));
            }
        }
        catch (AnnotationException ex) {
            throw new EPException("Failed to interpret hint annotation: " + ex.getMessage(), ex);
        }
        return allHints;
    }

    private static String getAssignedValue(String value, String enumValue) {
        String[] hints;
        String valMixed = value.trim();
        String val = valMixed.toUpperCase(Locale.ENGLISH);
        if (!val.contains(",")) {
            if (val.indexOf(61) == -1) {
                return null;
            }
            String hintName = val.substring(0, val.indexOf(61));
            if (!hintName.equals(enumValue)) {
                return null;
            }
            return valMixed.substring(val.indexOf(61) + 1, val.length());
        }
        for (String hint : hints = valMixed.split(",")) {
            int indexOfEquals = hint.indexOf(61);
            if (indexOfEquals == -1 || !(val = hint.substring(0, indexOfEquals).trim().toUpperCase(Locale.ENGLISH)).equals(enumValue)) continue;
            String strValue = hint.substring(indexOfEquals + 1).trim();
            if (strValue.length() == 0) {
                return null;
            }
            return strValue;
        }
        return null;
    }

    public static String[] splitCommaUnlessInParen(String line) {
        int nestingLevelParen = 0;
        int lastComma = -1;
        ArrayList<String> parts = new ArrayList<String>();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '(') {
                ++nestingLevelParen;
            }
            if (c == ')') {
                if (nestingLevelParen == 0) {
                    throw new RuntimeException("Close parenthesis ')' found but none open");
                }
                --nestingLevelParen;
            }
            if (c != ',' || nestingLevelParen != 0) continue;
            String part = line.substring(lastComma + 1, i);
            if (part.trim().length() > 0) {
                parts.add(part);
            }
            lastComma = i;
        }
        String lastPart = line.substring(lastComma + 1);
        if (lastPart.trim().length() > 0) {
            parts.add(lastPart);
        }
        return parts.toArray(new String[parts.size()]);
    }
}

