/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.configuration.common;

import com.espertech.esper.common.client.annotation.Name;
import com.espertech.esper.common.client.configuration.ConfigurationException;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonDBRef;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeAvro;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeBean;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeMap;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeMeta;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeObjectArray;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeXMLDOM;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonExecution;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonLogging;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonMethodRef;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonTimeSource;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonVariable;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonVariantStream;
import com.espertech.esper.common.internal.epl.dataflow.ops.BeaconSourceForge;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ConfigurationCommon
implements Serializable {
    public static final String ANNOTATION_IMPORT = Name.class.getPackage().getName() + ".*";
    public static final String DATAFLOWOPERATOR_IMPORT = BeaconSourceForge.class.getPackage().getName() + ".*";
    protected Map<String, String> eventClasses;
    protected Map<String, ConfigurationCommonEventTypeXMLDOM> eventTypesXMLDOM;
    protected Map<String, ConfigurationCommonEventTypeAvro> eventTypesAvro;
    protected Map<String, ConfigurationCommonEventTypeBean> eventTypesBean;
    protected Map<String, Properties> mapNames;
    protected Map<String, Map<String, Object>> nestableMapNames;
    protected Map<String, Map<String, Object>> nestableObjectArrayNames;
    protected Map<String, ConfigurationCommonEventTypeMap> mapTypeConfigurations;
    protected Map<String, ConfigurationCommonEventTypeObjectArray> objectArrayTypeConfigurations;
    protected List<String> imports;
    protected List<String> annotationImports;
    protected Map<String, ConfigurationCommonDBRef> databaseReferences;
    protected Map<String, ConfigurationCommonVariable> variables;
    protected Map<String, ConfigurationCommonMethodRef> methodInvocationReferences;
    protected Map<String, ConfigurationCommonVariantStream> variantStreams;
    protected transient Map<String, Object> transientConfiguration;
    protected ConfigurationCommonEventTypeMeta eventMeta;
    protected ConfigurationCommonLogging logging;
    protected ConfigurationCommonTimeSource timeSource;
    protected ConfigurationCommonExecution execution;
    private Set<String> eventTypeAutoNamePackages;

    public ConfigurationCommon() {
        this.reset();
    }

    public boolean isEventTypeExists(String eventTypeName) {
        return this.eventClasses.containsKey(eventTypeName) || this.mapNames.containsKey(eventTypeName) || this.nestableMapNames.containsKey(eventTypeName) || this.nestableObjectArrayNames.containsKey(eventTypeName) || this.eventTypesXMLDOM.containsKey(eventTypeName) || this.eventTypesAvro.containsKey(eventTypeName);
    }

    public void addEventType(String eventTypeName, String eventClassName) {
        this.eventClasses.put(eventTypeName, eventClassName);
    }

    public void addEventType(String eventTypeName, Class eventClass) {
        this.addEventType(eventTypeName, eventClass.getName());
    }

    public void addEventType(Class eventClass) {
        this.addEventType(eventClass.getSimpleName(), eventClass.getName());
    }

    public void addEventType(String eventTypeName, Properties typeMap) {
        this.mapNames.put(eventTypeName, typeMap);
    }

    public void addEventType(String eventTypeName, Map<String, Object> typeMap) {
        this.nestableMapNames.put(eventTypeName, new LinkedHashMap<String, Object>(typeMap));
    }

    public void addEventType(String eventTypeName, Map<String, Object> typeMap, String[] superTypes) {
        this.nestableMapNames.put(eventTypeName, new LinkedHashMap<String, Object>(typeMap));
        if (superTypes != null) {
            for (int i = 0; i < superTypes.length; ++i) {
                this.addMapSuperType(eventTypeName, superTypes[i]);
            }
        }
    }

    public void addEventType(String eventTypeName, Map<String, Object> typeMap, ConfigurationCommonEventTypeMap mapConfig) {
        this.nestableMapNames.put(eventTypeName, new LinkedHashMap<String, Object>(typeMap));
        this.mapTypeConfigurations.put(eventTypeName, mapConfig);
    }

    public void addMapSuperType(String mapeventTypeName, String mapSupertypeName) {
        ConfigurationCommonEventTypeMap current = this.mapTypeConfigurations.get(mapeventTypeName);
        if (current == null) {
            current = new ConfigurationCommonEventTypeMap();
            this.mapTypeConfigurations.put(mapeventTypeName, current);
        }
        Set<String> superTypes = current.getSuperTypes();
        superTypes.add(mapSupertypeName);
    }

    public void addObjectArraySuperType(String eventTypeName, String supertypeName) {
        Set<String> superTypes;
        ConfigurationCommonEventTypeObjectArray current = this.objectArrayTypeConfigurations.get(eventTypeName);
        if (current == null) {
            current = new ConfigurationCommonEventTypeObjectArray();
            this.objectArrayTypeConfigurations.put(eventTypeName, current);
        }
        if (!(superTypes = current.getSuperTypes()).isEmpty()) {
            throw new ConfigurationException("Object-array event types may not have multiple supertypes");
        }
        superTypes.add(supertypeName);
    }

    public void addMapConfiguration(String mapeventTypeName, ConfigurationCommonEventTypeMap config) {
        this.mapTypeConfigurations.put(mapeventTypeName, config);
    }

    public void addObjectArrayConfiguration(String objectArrayeventTypeName, ConfigurationCommonEventTypeObjectArray config) {
        this.objectArrayTypeConfigurations.put(objectArrayeventTypeName, config);
    }

    public void addEventType(String eventTypeName, ConfigurationCommonEventTypeXMLDOM xmlDOMEventTypeDesc) {
        this.eventTypesXMLDOM.put(eventTypeName, xmlDOMEventTypeDesc);
    }

    public void addEventType(String eventTypeName, String[] propertyNames, Object[] propertyTypes) {
        LinkedHashMap<String, Object> propertyTypesMap = EventTypeUtility.validateObjectArrayDef(propertyNames, propertyTypes);
        this.nestableObjectArrayNames.put(eventTypeName, propertyTypesMap);
    }

    public void addEventType(String eventTypeName, String[] propertyNames, Object[] propertyTypes, ConfigurationCommonEventTypeObjectArray optionalConfiguration) throws ConfigurationException {
        LinkedHashMap<String, Object> propertyTypesMap = EventTypeUtility.validateObjectArrayDef(propertyNames, propertyTypes);
        this.nestableObjectArrayNames.put(eventTypeName, propertyTypesMap);
        this.objectArrayTypeConfigurations.put(eventTypeName, optionalConfiguration);
        if (optionalConfiguration.getSuperTypes() != null && optionalConfiguration.getSuperTypes().size() > 1) {
            throw new ConfigurationException("Object-array event types only allow a single supertype");
        }
    }

    public void addDatabaseReference(String name, ConfigurationCommonDBRef configurationDBRef) {
        this.databaseReferences.put(name, configurationDBRef);
    }

    public void addEventType(String eventTypeName, String eventClass, ConfigurationCommonEventTypeBean beanEventTypeDesc) {
        this.eventClasses.put(eventTypeName, eventClass);
        this.eventTypesBean.put(eventTypeName, beanEventTypeDesc);
    }

    public void addImport(String autoImport) {
        this.imports.add(autoImport);
    }

    public void addImport(Class autoImport) {
        this.addImport(autoImport.getName());
    }

    public void addAnnotationImport(String importName) {
        this.annotationImports.add(importName);
    }

    public void addAnnotationImport(Class autoImport) {
        this.addAnnotationImport(autoImport.getName());
    }

    public void removeImport(String name) {
        this.imports.remove(name);
    }

    public void addMethodRef(String className, ConfigurationCommonMethodRef methodInvocationConfig) {
        this.methodInvocationReferences.put(className, methodInvocationConfig);
    }

    public void addMethodRef(Class clazz, ConfigurationCommonMethodRef methodInvocationConfig) {
        this.methodInvocationReferences.put(clazz.getName(), methodInvocationConfig);
    }

    public Map<String, String> getEventTypeNames() {
        return this.eventClasses;
    }

    public Map<String, Properties> getEventTypesMapEvents() {
        return this.mapNames;
    }

    public Map<String, Map<String, Object>> getEventTypesNestableMapEvents() {
        return this.nestableMapNames;
    }

    public Map<String, Map<String, Object>> getEventTypesNestableObjectArrayEvents() {
        return this.nestableObjectArrayNames;
    }

    public Map<String, ConfigurationCommonEventTypeXMLDOM> getEventTypesXMLDOM() {
        return this.eventTypesXMLDOM;
    }

    public Map<String, ConfigurationCommonEventTypeAvro> getEventTypesAvro() {
        return this.eventTypesAvro;
    }

    public Map<String, ConfigurationCommonEventTypeBean> getEventTypesBean() {
        return this.eventTypesBean;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public List<String> getAnnotationImports() {
        return this.annotationImports;
    }

    public Map<String, ConfigurationCommonDBRef> getDatabaseReferences() {
        return this.databaseReferences;
    }

    public Map<String, ConfigurationCommonEventTypeObjectArray> getObjectArrayTypeConfigurations() {
        return this.objectArrayTypeConfigurations;
    }

    public Map<String, ConfigurationCommonVariable> getVariables() {
        return this.variables;
    }

    public Map<String, ConfigurationCommonMethodRef> getMethodInvocationReferences() {
        return this.methodInvocationReferences;
    }

    public Map<String, ConfigurationCommonEventTypeMap> getMapTypeConfigurations() {
        return this.mapTypeConfigurations;
    }

    public void addVariable(String variableName, Class type, Object initializationValue) {
        this.addVariable(variableName, type.getName(), initializationValue, false);
    }

    public void addVariable(String variableName, Class type, Object initializationValue, boolean constant) {
        this.addVariable(variableName, type.getName(), initializationValue, constant);
    }

    public void addVariable(String variableName, String type, Object initializationValue) {
        this.addVariable(variableName, type, initializationValue, false);
    }

    public void addVariable(String variableName, String type, Object initializationValue, boolean constant) {
        ConfigurationCommonVariable configVar = new ConfigurationCommonVariable();
        configVar.setType(type);
        configVar.setInitializationValue(initializationValue);
        configVar.setConstant(constant);
        this.variables.put(variableName, configVar);
    }

    public void addVariantStream(String variantStreamName, ConfigurationCommonVariantStream variantStreamConfig) {
        this.variantStreams.put(variantStreamName, variantStreamConfig);
    }

    public Map<String, ConfigurationCommonVariantStream> getVariantStreams() {
        return this.variantStreams;
    }

    public boolean isVariantStreamExists(String name) {
        return this.variantStreams.containsKey(name);
    }

    public void addEventTypeAvro(String eventTypeName, ConfigurationCommonEventTypeAvro avro) {
        this.eventTypesAvro.put(eventTypeName, avro);
    }

    public Map<String, Object> getTransientConfiguration() {
        return this.transientConfiguration;
    }

    public void setTransientConfiguration(Map<String, Object> transientConfiguration) {
        this.transientConfiguration = transientConfiguration;
    }

    public ConfigurationCommonEventTypeMeta getEventMeta() {
        return this.eventMeta;
    }

    public ConfigurationCommonTimeSource getTimeSource() {
        return this.timeSource;
    }

    protected void reset() {
        this.eventClasses = new LinkedHashMap<String, String>();
        this.mapNames = new LinkedHashMap<String, Properties>();
        this.nestableMapNames = new LinkedHashMap<String, Map<String, Object>>();
        this.nestableObjectArrayNames = new LinkedHashMap<String, Map<String, Object>>();
        this.eventTypesXMLDOM = new LinkedHashMap<String, ConfigurationCommonEventTypeXMLDOM>();
        this.eventTypesAvro = new LinkedHashMap<String, ConfigurationCommonEventTypeAvro>();
        this.eventTypesBean = new LinkedHashMap<String, ConfigurationCommonEventTypeBean>();
        this.databaseReferences = new HashMap<String, ConfigurationCommonDBRef>();
        this.imports = new ArrayList<String>();
        this.annotationImports = new ArrayList<String>(2);
        this.addDefaultImports();
        this.variables = new HashMap<String, ConfigurationCommonVariable>();
        this.methodInvocationReferences = new HashMap<String, ConfigurationCommonMethodRef>();
        this.variantStreams = new HashMap<String, ConfigurationCommonVariantStream>();
        this.mapTypeConfigurations = new HashMap<String, ConfigurationCommonEventTypeMap>();
        this.objectArrayTypeConfigurations = new HashMap<String, ConfigurationCommonEventTypeObjectArray>();
        this.eventMeta = new ConfigurationCommonEventTypeMeta();
        this.logging = new ConfigurationCommonLogging();
        this.timeSource = new ConfigurationCommonTimeSource();
        this.transientConfiguration = new HashMap<String, Object>(2);
        this.eventTypeAutoNamePackages = new HashSet<String>(2);
        this.execution = new ConfigurationCommonExecution();
    }

    public ConfigurationCommonLogging getLogging() {
        return this.logging;
    }

    public ConfigurationCommonExecution getExecution() {
        return this.execution;
    }

    public void addEventTypeAutoName(String packageName) {
        this.eventTypeAutoNamePackages.add(packageName);
    }

    public Set<String> getEventTypeAutoNamePackages() {
        return this.eventTypeAutoNamePackages;
    }

    private void addDefaultImports() {
        this.imports.add("java.lang.*");
        this.imports.add("java.math.*");
        this.imports.add("java.text.*");
        this.imports.add("java.util.*");
        this.imports.add(ANNOTATION_IMPORT);
        this.imports.add(DATAFLOWOPERATOR_IMPORT);
    }
}

