/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.dataflow.util;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpForgeInitializeContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.util.EPLValidationUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;

public class DataFlowParameterValidation {
    public static ExprNode validate(String name, ExprNode expr, Class expectedReturnType, DataFlowOpForgeInitializeContext context) throws ExprValidationException {
        if (expr == null) {
            return null;
        }
        return DataFlowParameterValidation.validate(name, expr, null, expectedReturnType, context);
    }

    public static ExprNode validate(String name, ExprNode expr, EventType eventType, Class expectedReturnType, DataFlowOpForgeInitializeContext context) throws ExprValidationException {
        if (expr == null) {
            return null;
        }
        ExprNode validated = EPLValidationUtil.validateSimpleGetSubtree(ExprNodeOrigin.DATAFLOWFILTER, expr, eventType, false, context.getStatementRawInfo(), context.getServices());
        DataFlowParameterValidation.validateReturnType(name, validated, expectedReturnType);
        return validated;
    }

    private static void validateReturnType(String name, ExprNode validated, Class expectedReturnType) throws ExprValidationException {
        Class returnType = validated.getForge().getEvaluationType();
        if (!JavaClassHelper.isAssignmentCompatible(JavaClassHelper.getBoxedType(returnType), expectedReturnType)) {
            String message = "Failed to validate return type of parameter '" + name + "', expected '" + JavaClassHelper.getClassNameFullyQualPretty(expectedReturnType) + "' but received '" + JavaClassHelper.getClassNameFullyQualPretty(returnType) + "'";
            throw new ExprValidationException(message);
        }
    }
}

