/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.module;

import com.espertech.esper.common.client.module.Module;
import com.espertech.esper.common.client.module.ModuleOrder;
import com.espertech.esper.common.client.module.ModuleOrderException;
import com.espertech.esper.common.client.module.ModuleOrderOptions;
import com.espertech.esper.common.internal.util.DependencyGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;

public class ModuleOrderUtil {
    public static ModuleOrder getModuleOrder(Collection<Module> modules, Set<String> deployedModules, ModuleOrderOptions options) throws ModuleOrderException {
        Stack<Integer> circular;
        if (options == null) {
            options = new ModuleOrderOptions();
        }
        ArrayList<Module> proposedModules = new ArrayList<Module>();
        proposedModules.addAll(modules);
        HashSet<String> availableModuleNames = new HashSet<String>();
        for (Module module : proposedModules) {
            if (module.getName() == null) continue;
            availableModuleNames.add(module.getName());
        }
        HashSet<String> allDeployedModules = new HashSet<String>();
        allDeployedModules.addAll(deployedModules);
        for (Module module : proposedModules) {
            allDeployedModules.add(module.getName());
        }
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
        for (Module proposedModule : proposedModules) {
            if (options.isCheckUses() && proposedModule.getUses() != null) {
                for (String uses : proposedModule.getUses()) {
                    boolean deployed;
                    if (availableModuleNames.contains(uses) || (deployed = allDeployedModules.contains(uses))) continue;
                    String message = "Module-dependency not found";
                    if (proposedModule.getName() != null) {
                        message = message + " as declared by module '" + proposedModule.getName() + "'";
                    }
                    message = message + " for uses-declaration '" + uses + "'";
                    throw new ModuleOrderException(message);
                }
            }
            if (proposedModule.getName() == null || proposedModule.getUses() == null) continue;
            Set<String> usesSet = (Set)hashMap.get(proposedModule.getName());
            if (usesSet == null) {
                usesSet = new HashSet<String>();
                hashMap.put(proposedModule.getName(), (HashSet<String>)usesSet);
            }
            usesSet.addAll(proposedModule.getUses());
        }
        HashMap<String, TreeSet<Integer>> hashMap2 = new HashMap<String, TreeSet<Integer>>();
        int count = 0;
        for (Module proposedModule : proposedModules) {
            TreeSet<Integer> moduleNumbers = (TreeSet<Integer>)hashMap2.get(proposedModule.getName());
            if (moduleNumbers == null) {
                moduleNumbers = new TreeSet<Integer>();
                hashMap2.put(proposedModule.getName(), moduleNumbers);
            }
            moduleNumbers.add(count);
            ++count;
        }
        DependencyGraph graph = new DependencyGraph(proposedModules.size(), false);
        int fromModule = 0;
        for (Module proposedModule : proposedModules) {
            if (proposedModule.getUses() == null || proposedModule.getUses().isEmpty()) {
                ++fromModule;
                continue;
            }
            TreeSet<Integer> dependentModuleNumbers = new TreeSet<Integer>();
            for (String use : proposedModule.getUses()) {
                SortedSet moduleNumbers = (SortedSet)hashMap2.get(use);
                if (moduleNumbers == null) continue;
                dependentModuleNumbers.addAll(moduleNumbers);
            }
            dependentModuleNumbers.remove(fromModule);
            graph.addDependency(fromModule, dependentModuleNumbers);
            ++fromModule;
        }
        if (options.isCheckCircularDependency() && (circular = graph.getFirstCircularDependency()) != null) {
            String message = "";
            String delimiter = "";
            Iterator<Object> iterator = circular.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                message = message + delimiter;
                message = message + "module '" + ((Module)proposedModules.get(i)).getName() + "'";
                delimiter = " uses (depends on) ";
            }
            throw new ModuleOrderException("Circular dependency detected in module uses-relationships: " + message);
        }
        ArrayList<Module> reverseDeployList = new ArrayList<Module>();
        HashSet<Integer> ignoreList = new HashSet<Integer>();
        while (ignoreList.size() < proposedModules.size()) {
            TreeSet<Integer> rootNodes = new TreeSet<Integer>(new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return -1 * o1.compareTo(o2);
                }
            });
            rootNodes.addAll(graph.getRootNodes(ignoreList));
            if (rootNodes.isEmpty()) {
                for (int i = 0; i < proposedModules.size(); ++i) {
                    if (ignoreList.contains(i)) continue;
                    rootNodes.add(i);
                    break;
                }
            }
            for (Integer root : rootNodes) {
                ignoreList.add(root);
                reverseDeployList.add((Module)proposedModules.get(root));
            }
        }
        Collections.reverse(reverseDeployList);
        return new ModuleOrder(reverseDeployList);
    }
}

