/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionBase;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;

public class BetweenExpression
extends ExpressionBase {
    private boolean isLowEndpointIncluded;
    private boolean isHighEndpointIncluded;
    private boolean isNotBetween;
    private static final long serialVersionUID = 4626033892510751123L;

    public BetweenExpression() {
    }

    public BetweenExpression(Expression datapoint, Expression lower, Expression higher) {
        this(datapoint, lower, higher, true, true, false);
    }

    public BetweenExpression(boolean lowEndpointIncluded, boolean highEndpointIncluded, boolean notBetween) {
        this.isLowEndpointIncluded = lowEndpointIncluded;
        this.isHighEndpointIncluded = highEndpointIncluded;
        this.isNotBetween = notBetween;
    }

    public BetweenExpression(Expression datapoint, Expression lower, Expression higher, boolean lowEndpointIncluded, boolean highEndpointIncluded, boolean notBetween) {
        this.getChildren().add(datapoint);
        this.getChildren().add(lower);
        this.getChildren().add(higher);
        this.isLowEndpointIncluded = lowEndpointIncluded;
        this.isHighEndpointIncluded = highEndpointIncluded;
        this.isNotBetween = notBetween;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (this.isLowEndpointIncluded && this.isHighEndpointIncluded) {
            this.getChildren().get(0).toEPL(writer, this.getPrecedence());
            if (this.isNotBetween) {
                writer.write(" not");
            }
            writer.write(" between ");
            this.getChildren().get(1).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.write(" and ");
            this.getChildren().get(2).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        } else {
            this.getChildren().get(0).toEPL(writer, this.getPrecedence());
            if (this.isNotBetween) {
                writer.write(" not");
            }
            writer.write(" in ");
            if (this.isLowEndpointIncluded) {
                writer.write(91);
            } else {
                writer.write(40);
            }
            this.getChildren().get(1).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.write(58);
            this.getChildren().get(2).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            if (this.isHighEndpointIncluded) {
                writer.write(93);
            } else {
                writer.write(41);
            }
        }
    }

    public boolean isLowEndpointIncluded() {
        return this.isLowEndpointIncluded;
    }

    public void setLowEndpointIncluded(boolean lowEndpointIncluded) {
        this.isLowEndpointIncluded = lowEndpointIncluded;
    }

    public boolean isHighEndpointIncluded() {
        return this.isHighEndpointIncluded;
    }

    public void setHighEndpointIncluded(boolean highEndpointIncluded) {
        this.isHighEndpointIncluded = highEndpointIncluded;
    }

    public boolean isNotBetween() {
        return this.isNotBetween;
    }

    public void setNotBetween(boolean notBetween) {
        this.isNotBetween = notBetween;
    }
}

